/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.ObjectField;
import org.drools.workbench.services.verifier.api.client.maps.InspectorMultiMap;
import org.drools.workbench.services.verifier.api.client.maps.util.RedundancyResult;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.RedundantConditionsIssue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.services.verifier.core.checks.base.SingleCheck;

public class DetectRedundantConditionsCheck
extends SingleCheck {
    private RedundancyResult<ObjectField, ConditionInspector> result;

    public DetectRedundantConditionsCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, configuration, CheckType.REDUNDANT_CONDITIONS_TITLE);
    }

    @Override
    public boolean check() {
        this.result = this.ruleInspector.getPatternsInspector().stream().map(PatternInspector::getConditionsInspector).map(InspectorMultiMap::hasRedundancy).filter(RedundancyResult::isTrue).findFirst().orElse(null);
        this.hasIssues = this.result != null;
        return this.hasIssues;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.NOTE;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new RedundantConditionsIssue(severity, checkType, ((ObjectField)this.result.getParent()).getFactType(), ((ObjectField)this.result.getParent()).getName(), ((ConditionInspector)this.result.get(0)).toHumanReadableString(), ((ConditionInspector)this.result.get(1)).toHumanReadableString(), new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1)));
    }
}

