/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspectorDumper;
import org.drools.workbench.services.verifier.core.checks.base.PairCheck;

public class DetectConflictingRowsCheck
extends PairCheck {
    public DetectConflictingRowsCheck(RuleInspector ruleInspector, RuleInspector other, AnalyzerConfiguration configuration) {
        super(ruleInspector, other, configuration);
    }

    @Override
    protected CheckType getCheckType() {
        return CheckType.CONFLICTING_ROWS;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    public boolean check() {
        this.hasIssues = this.ruleInspector.conflicts(this.other);
        return this.hasIssues;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        Issue issue = new Issue(severity, checkType, new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1, this.other.getRowIndex() + 1)));
        issue.setDebugMessage(new RuleInspectorDumper(this.ruleInspector).dump() + " ## " + new RuleInspectorDumper(this.other).dump());
        return issue;
    }
}

