/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks.base;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.maps.MultiSet;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.Check;
import org.drools.workbench.services.verifier.core.checks.base.CheckFactory;
import org.drools.workbench.services.verifier.core.checks.base.OneToManyCheck;
import org.drools.workbench.services.verifier.core.checks.base.PairCheckBundle;
import org.drools.workbench.services.verifier.core.checks.base.PairCheckStorage;

public class CheckStorage {
    private final PairCheckStorage pairCheckStorage = new PairCheckStorage();
    private final MultiSet<RuleInspector, Check> ruleInspectorChecks = new MultiSet();
    private final MultiSet<RuleInspector, OneToManyCheck> oneToManyChecks = new MultiSet();
    private final CheckFactory checkFactory;

    public CheckStorage(CheckFactory checkFactory) {
        this.checkFactory = checkFactory;
    }

    private void makeSingleRowChecks(RuleInspector ruleInspector) {
        Set<Check> checks = this.checkFactory.makeSingleChecks(ruleInspector);
        for (Check check : checks) {
            if (!(check instanceof OneToManyCheck)) continue;
            this.oneToManyChecks.put((Object)ruleInspector, (Object)((OneToManyCheck)check));
        }
        this.ruleInspectorChecks.addAllValues((Object)ruleInspector, checks);
    }

    private void makePairRowChecks(RuleInspector ruleInspector, Collection<RuleInspector> all) {
        for (RuleInspector other : all) {
            if (ruleInspector.equals(other)) continue;
            this.checkFactory.makePairRowCheck(ruleInspector, other).ifPresent(this.pairCheckStorage::add);
        }
    }

    public Set<Check> getChecks(RuleInspector ruleInspector) {
        HashSet<Check> result = new HashSet<Check>();
        result.addAll(this.getRuleInspectorChecks(ruleInspector));
        result.addAll(this.getReferencingChecks(ruleInspector));
        result.addAll(this.oneToManyChecks.allValues());
        return result;
    }

    private Collection<PairCheckBundle> getReferencingChecks(RuleInspector ruleInspector) {
        Collection<PairCheckBundle> checks = this.pairCheckStorage.get(ruleInspector);
        return checks == null ? Collections.emptyList() : checks;
    }

    private Collection<Check> getRuleInspectorChecks(RuleInspector ruleInspector) {
        Collection checks = this.ruleInspectorChecks.get((Object)ruleInspector);
        return checks == null ? Collections.emptyList() : checks;
    }

    public Set<Check> remove(RuleInspector ruleInspector) {
        HashSet<Check> result = new HashSet<Check>();
        result.addAll(this.removeRuleInspectorChecks(ruleInspector));
        result.addAll(this.pairCheckStorage.remove(ruleInspector));
        result.addAll(this.removeOneToMany(ruleInspector));
        return result;
    }

    private Collection<Check> removeRuleInspectorChecks(RuleInspector ruleInspector) {
        Collection remove = this.ruleInspectorChecks.remove((Object)ruleInspector);
        return remove == null ? Collections.emptyList() : remove;
    }

    private Collection<OneToManyCheck> removeOneToMany(RuleInspector ruleInspector) {
        Collection remove = this.oneToManyChecks.remove((Object)ruleInspector);
        return remove == null ? Collections.emptyList() : remove;
    }

    public void makeChecks(RuleInspector ruleInspector) {
        this.makeSingleRowChecks(ruleInspector);
        Set knownRuleInspectors = this.ruleInspectorChecks.keys();
        this.makePairRowChecks(ruleInspector, knownRuleInspectors);
        for (RuleInspector other : knownRuleInspectors) {
            if (other.equals(ruleInspector)) continue;
            this.checkFactory.makePairRowCheck(other, ruleInspector).ifPresent(this.pairCheckStorage::add);
        }
    }
}

