/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.maps.InspectorMultiMap;
import org.drools.workbench.services.verifier.api.client.maps.util.RedundancyResult;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.reporting.ValueForActionIsSetTwiceIssue;
import org.drools.workbench.services.verifier.core.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.action.ActionInspector;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantActionBase;

public class DetectRedundantActionValueCheck
extends DetectRedundantActionBase {
    public DetectRedundantActionValueCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, configuration, CheckType.VALUE_FOR_ACTION_IS_SET_TWICE);
    }

    @Override
    public boolean check() {
        this.result = this.ruleInspector.getPatternsInspector().stream().filter(p -> p.getPattern().getBoundName() != null).peek(p -> {
            this.patternInspector = p;
        }).map(PatternInspector::getActionsInspector).map(InspectorMultiMap::hasRedundancy).filter(RedundancyResult::isTrue).findFirst().orElse(null);
        this.hasIssues = this.result != null;
        return this.hasIssues;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new ValueForActionIsSetTwiceIssue(severity, checkType, ((ActionInspector)this.result.get(0)).toHumanReadableString(), ((ActionInspector)this.result.get(1)).toHumanReadableString(), new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1)));
    }
}

