/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors.condition;

import java.util.Date;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.FieldCondition;
import org.drools.workbench.services.verifier.api.client.index.keys.Values;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.services.verifier.core.checks.AnalyzerConfigurationMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DateConditionInspectorSubsumptionTest {
    @Mock
    private Field field;

    @Test
    public void testSubsume001() throws Exception {
        ComparableConditionInspector<Date> a = this.getCondition(new Date(100L), "!=");
        ComparableConditionInspector<Date> b = this.getCondition(new Date(100L), "!=");
        Assert.assertTrue((boolean)a.subsumes(b));
        Assert.assertTrue((boolean)b.subsumes(a));
    }

    @Test
    public void testSubsumeEquals001() throws Exception {
        ComparableConditionInspector<Date> a = this.getCondition(new Date(100L), "==");
        ComparableConditionInspector<Date> b = this.getCondition(new Date(10L), ">");
        Assert.assertFalse((boolean)a.subsumes(b));
        Assert.assertTrue((boolean)b.subsumes(a));
    }

    @Test
    public void testSubsumeEquals002() throws Exception {
        ComparableConditionInspector<Date> a = this.getCondition(new Date(10L), "==");
        ComparableConditionInspector<Date> b = this.getCondition(new Date(100L), ">");
        Assert.assertFalse((boolean)a.subsumes(b));
        Assert.assertFalse((boolean)b.subsumes(a));
    }

    private ComparableConditionInspector<Date> getCondition(Date date, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{date}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

