/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks.base;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.workbench.services.verifier.api.client.maps.MultiSet;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.PairCheckBundle;

public class PairCheckStorage {
    private final MultiSet<RuleInspector, PairCheckBundle> pairChecks = new MultiSet();
    private final Map<RuleInspector, MultiSet<RuleInspector, PairCheckBundle>> pairChecksByOtherRowInspector = new HashMap<RuleInspector, MultiSet<RuleInspector, PairCheckBundle>>();

    public void add(PairCheckBundle pairCheckList) {
        this.pairChecks.put((Object)pairCheckList.getRuleInspector(), (Object)pairCheckList);
        this.addByOther(pairCheckList);
    }

    private void addByOther(PairCheckBundle pairCheckList) {
        MultiSet<RuleInspector, PairCheckBundle> multiSet = this.getByOther(pairCheckList.getOther());
        Collection collection = multiSet.get((Object)pairCheckList.getRuleInspector());
        if (collection == null) {
            multiSet.put((Object)pairCheckList.getRuleInspector(), (Object)pairCheckList);
        } else {
            collection.add(pairCheckList);
        }
    }

    private MultiSet<RuleInspector, PairCheckBundle> getByOther(RuleInspector other) {
        MultiSet<RuleInspector, PairCheckBundle> multiSet = this.pairChecksByOtherRowInspector.get(other);
        if (multiSet == null) {
            MultiSet result = new MultiSet();
            this.pairChecksByOtherRowInspector.put(other, (MultiSet<RuleInspector, PairCheckBundle>)result);
            return result;
        }
        return multiSet;
    }

    public Collection<PairCheckBundle> remove(RuleInspector ruleInspector) {
        HashSet<PairCheckBundle> result = new HashSet<PairCheckBundle>();
        Collection removedPairCheckLists = this.pairChecks.remove((Object)ruleInspector);
        if (removedPairCheckLists != null) {
            result.addAll(removedPairCheckLists);
        }
        result.addAll(this.removeByOther(ruleInspector));
        return result;
    }

    private List<PairCheckBundle> removeByOther(RuleInspector ruleInspector) {
        MultiSet<RuleInspector, PairCheckBundle> removedMap = this.pairChecksByOtherRowInspector.remove(ruleInspector);
        if (removedMap != null) {
            for (RuleInspector inspector : removedMap.keys()) {
                Collection collection = removedMap.get((Object)inspector);
                this.pairChecks.get((Object)inspector).removeAll(collection);
                this.getByOther(inspector).remove((Object)ruleInspector);
            }
            return removedMap.allValues();
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<PairCheckBundle> get(RuleInspector ruleInspector) {
        Collection pairCheckLists = this.pairChecks.get((Object)ruleInspector);
        MultiSet<RuleInspector, PairCheckBundle> multiSet = this.getByOther(ruleInspector);
        HashSet<PairCheckBundle> result = new HashSet<PairCheckBundle>();
        if (pairCheckLists != null) {
            result.addAll(pairCheckLists);
        }
        result.addAll(multiSet.allValues());
        return result;
    }

    public void remove(Collection<PairCheckBundle> checks) {
        for (PairCheckBundle check : checks) {
            this.get(check.getOther()).remove(check);
        }
    }
}

