/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Action;
import org.drools.workbench.services.verifier.api.client.index.Actions;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.Columns;
import org.drools.workbench.services.verifier.api.client.index.Condition;
import org.drools.workbench.services.verifier.api.client.index.Conditions;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.Fields;
import org.drools.workbench.services.verifier.api.client.index.Index;
import org.drools.workbench.services.verifier.api.client.index.Patterns;
import org.drools.workbench.services.verifier.api.client.index.Rule;
import org.drools.workbench.services.verifier.api.client.index.Rules;
import org.drools.workbench.services.verifier.api.client.index.matchers.Matcher;
import org.drools.workbench.services.verifier.api.client.index.matchers.UUIDMatcher;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.SingleRangeCheck;
import org.drools.workbench.services.verifier.core.checks.base.Check;
import org.drools.workbench.services.verifier.core.checks.base.CheckFactory;
import org.drools.workbench.services.verifier.core.checks.base.CheckStorage;
import org.kie.soup.commons.validation.PortablePreconditions;

public class RuleInspectorCache {
    private final Map<Rule, RuleInspector> ruleInspectors = new HashMap<Rule, RuleInspector>();
    private final Set<Check> generalChecks = new HashSet<Check>();
    protected final Index index;
    private final CheckStorage checkStorage;
    private final AnalyzerConfiguration configuration;

    public RuleInspectorCache(Index index, AnalyzerConfiguration configuration) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.checkStorage = new CheckStorage(new CheckFactory((AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration)));
        this.configuration = configuration;
    }

    public void reset() {
        for (RuleInspector ruleInspector : this.ruleInspectors.values()) {
            ruleInspector.clearChecks();
        }
        this.ruleInspectors.clear();
        this.generalChecks.clear();
        for (Rule rule : ((Rules.RulesSelect)this.index.getRules().where(Rule.uuid().any()).select()).all()) {
            this.add(new RuleInspector(rule, this.checkStorage, this, this.configuration));
        }
        this.generalChecks.add(new SingleRangeCheck(this.configuration, this.ruleInspectors.values()));
    }

    public Set<Check> getGeneralChecks() {
        return this.generalChecks;
    }

    public void newColumn(Column column) {
        this.index.getColumns().add(column);
    }

    public Collection<RuleInspector> all() {
        return this.ruleInspectors.values();
    }

    public Set<Issue> getAllIssues() {
        HashSet<Issue> issues = new HashSet<Issue>();
        issues.addAll(this.all().stream().flatMap(inspector -> inspector.getChecks().stream()).filter(Check::hasIssues).map(Check::getIssue).collect(Collectors.toSet()));
        issues.addAll(this.generalChecks.stream().filter(Check::hasIssues).map(Check::getIssue).collect(Collectors.toSet()));
        return issues;
    }

    public Collection<RuleInspector> all(Predicate<RuleInspector> filter) {
        return this.all().stream().filter(filter).collect(Collectors.toList());
    }

    private void add(RuleInspector ruleInspector) {
        this.ruleInspectors.put(ruleInspector.getRule(), ruleInspector);
    }

    public RuleInspector removeRow(int rowNumber) {
        Rule rule = this.getRule(rowNumber);
        RuleInspector remove = this.ruleInspectors.remove(rule);
        this.index.getRules().remove(rule);
        return remove;
    }

    private Rule getRule(int rowNumber) {
        return (Rule)((Rules.RulesSelect)this.index.getRules().where((Matcher)Rule.index().is((Comparable)Integer.valueOf(rowNumber))).select()).first();
    }

    public void deleteColumns(int firstColumnIndex) {
        Collection all = ((Columns.ColumnSelect)this.index.getColumns().where((Matcher)Column.index().is((Comparable)Integer.valueOf(firstColumnIndex))).select()).all();
        Fields.FieldSelector fieldSelector = (Fields.FieldSelector)((Patterns.PatternsSelect)((Rules.RulesSelect)this.index.getRules().where(UUIDMatcher.uuid().any()).select()).patterns().where(UUIDMatcher.uuid().any()).select()).fields().where(UUIDMatcher.uuid().any()).select();
        ArrayList actions = new ArrayList();
        ArrayList conditions = new ArrayList();
        for (Field field : fieldSelector.all()) {
            for (Column column : all) {
                Collection all1 = ((Actions.ActionSelect)field.getActions().where((Matcher)Action.columnUUID().is((Comparable)column.getUuidKey())).select()).all();
                Collection all2 = ((Conditions.ConditionSelector)field.getConditions().where((Matcher)Condition.columnUUID().is((Comparable)column.getUuidKey())).select()).all();
                actions.addAll(all1);
                conditions.addAll(all2);
            }
        }
        for (Action action : actions) {
            action.getUuidKey().retract();
        }
        for (Condition condition : conditions) {
            condition.getUuidKey().retract();
        }
        for (Column column : all) {
            column.getUuidKey().retract();
        }
        this.reset();
    }

    public RuleInspector addRule(Rule rule) {
        this.index.getRules().add(rule);
        RuleInspector ruleInspector = new RuleInspector(rule, this.checkStorage, this, this.configuration);
        this.add(ruleInspector);
        return ruleInspector;
    }

    public RuleInspector getRuleInspector(int row) {
        return this.ruleInspectors.get(this.getRule(row));
    }

    public AnalyzerConfiguration getConfiguration() {
        return this.configuration;
    }
}

