/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.maps.InspectorMultiMap;
import org.drools.workbench.services.verifier.api.client.relations.Conflict;
import org.drools.workbench.services.verifier.api.client.relations.HumanReadable;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.MultipleValuesForOneActionIssue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.SingleCheck;

public class DetectMultipleValuesForOneActionCheck
extends SingleCheck {
    private Conflict conflict = Conflict.EMPTY;

    public DetectMultipleValuesForOneActionCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, configuration, CheckType.MULTIPLE_VALUES_FOR_ONE_ACTION);
    }

    @Override
    public boolean check() {
        this.conflict = this.ruleInspector.getPatternsInspector().stream().map(PatternInspector::getActionsInspector).map(InspectorMultiMap::hasConflicts).filter(Conflict::foundIssue).findFirst().orElse(Conflict.EMPTY);
        this.hasIssues = this.conflict != Conflict.EMPTY;
        return this.hasIssues;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new MultipleValuesForOneActionIssue(severity, checkType, HumanReadable.toHumanReadableString((Object)this.conflict.getConflictedItem()), HumanReadable.toHumanReadableString((Object)this.conflict.getConflictingItem()), new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1)));
    }
}

