/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors;

import java.util.Collection;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Action;
import org.drools.workbench.services.verifier.api.client.index.ActionSuperType;
import org.drools.workbench.services.verifier.api.client.index.Actions;
import org.drools.workbench.services.verifier.api.client.index.BRLAction;
import org.drools.workbench.services.verifier.api.client.index.BRLCondition;
import org.drools.workbench.services.verifier.api.client.index.Condition;
import org.drools.workbench.services.verifier.api.client.index.ConditionSuperType;
import org.drools.workbench.services.verifier.api.client.index.Conditions;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.FieldCondition;
import org.drools.workbench.services.verifier.api.client.index.Fields;
import org.drools.workbench.services.verifier.api.client.index.Pattern;
import org.drools.workbench.services.verifier.api.client.index.Patterns;
import org.drools.workbench.services.verifier.api.client.index.Rule;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.index.matchers.Matcher;
import org.drools.workbench.services.verifier.api.client.index.select.AllListener;
import org.drools.workbench.services.verifier.api.client.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.maps.util.HasKeys;
import org.drools.workbench.services.verifier.api.client.maps.util.HasUUID;
import org.drools.workbench.services.verifier.api.client.relations.HumanReadable;
import org.drools.workbench.services.verifier.api.client.relations.IsConflicting;
import org.drools.workbench.services.verifier.api.client.relations.IsDeficient;
import org.drools.workbench.services.verifier.api.client.relations.IsRedundant;
import org.drools.workbench.services.verifier.api.client.relations.IsSubsuming;
import org.drools.workbench.services.verifier.core.cache.RuleInspectorCache;
import org.drools.workbench.services.verifier.core.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.services.verifier.core.cache.inspectors.action.ActionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.action.ActionsInspectorMultiMap;
import org.drools.workbench.services.verifier.core.cache.inspectors.action.BRLActionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.BRLConditionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.services.verifier.core.checks.base.Check;
import org.drools.workbench.services.verifier.core.checks.base.CheckStorage;
import org.kie.soup.commons.validation.PortablePreconditions;

public class RuleInspector
implements IsRedundant,
IsSubsuming,
IsConflicting,
IsDeficient<RuleInspector>,
HumanReadable,
HasKeys {
    private final Rule rule;
    private final CheckStorage checkStorage;
    private final RuleInspectorCache cache;
    private final AnalyzerConfiguration configuration;
    private final UUIDKey uuidKey;
    private final InspectorList<PatternInspector> patternInspectorList;
    private final InspectorList<ConditionInspector> brlConditionsInspectors;
    private final InspectorList<ActionInspector> brlActionInspectors;
    private InspectorList<ActionsInspectorMultiMap> actionsInspectors = null;
    private InspectorList<ConditionsInspectorMultiMap> conditionsInspectors = null;

    public RuleInspector(Rule rule, CheckStorage checkStorage, RuleInspectorCache cache, AnalyzerConfiguration configuration) {
        this.rule = (Rule)PortablePreconditions.checkNotNull((String)"rule", (Object)rule);
        this.checkStorage = (CheckStorage)PortablePreconditions.checkNotNull((String)"checkStorage", (Object)checkStorage);
        this.cache = (RuleInspectorCache)PortablePreconditions.checkNotNull((String)"cache", (Object)cache);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
        this.uuidKey = configuration.getUUID((HasKeys)this);
        this.patternInspectorList = new InspectorList(configuration);
        this.brlConditionsInspectors = new InspectorList(true, configuration);
        this.brlActionInspectors = new InspectorList(true, configuration);
        this.makePatternsInspectors();
        this.makeBRLActionInspectors();
        this.makeBRLConditionInspectors();
        this.makeChecks();
    }

    private void makeConditionsInspectors() {
        this.conditionsInspectors = new InspectorList(true, this.configuration);
        for (PatternInspector patternInspector : this.patternInspectorList) {
            this.conditionsInspectors.add((HasUUID)patternInspector.getConditionsInspector());
        }
    }

    private void makeActionsInspectors() {
        this.actionsInspectors = new InspectorList(true, this.configuration);
        for (PatternInspector patternInspector : this.patternInspectorList) {
            this.actionsInspectors.add((HasUUID)patternInspector.getActionsInspector());
        }
    }

    private void makeBRLConditionInspectors() {
        this.updateBRLConditionInspectors(((Conditions.ConditionSelector)this.rule.getConditions().where((Matcher)Condition.superType().is((Comparable)ConditionSuperType.BRL_CONDITION)).select()).all());
        ((Conditions.ConditionListen)this.rule.getConditions().where((Matcher)Condition.superType().is((Comparable)ConditionSuperType.BRL_CONDITION)).listen()).all((AllListener)new AllListener<Condition>(){

            public void onAllChanged(Collection<Condition> all) {
                RuleInspector.this.updateBRLConditionInspectors(all);
            }
        });
    }

    private void makeBRLActionInspectors() {
        this.updateBRLActionInspectors(((Actions.ActionSelect)this.rule.getActions().where((Matcher)Action.superType().is((Comparable)ActionSuperType.BRL_ACTION)).select()).all());
        ((Actions.ActionListen)this.rule.getActions().where((Matcher)Action.superType().is((Comparable)ActionSuperType.BRL_ACTION)).listen()).all((AllListener)new AllListener<Action>(){

            public void onAllChanged(Collection<Action> all) {
                RuleInspector.this.updateBRLActionInspectors(all);
            }
        });
    }

    private void makePatternsInspectors() {
        for (Pattern pattern : ((Patterns.PatternsSelect)this.rule.getPatterns().where(Pattern.uuid().any()).select()).all()) {
            PatternInspector patternInspector = new PatternInspector(pattern, new RuleInspectorUpdater(){

                @Override
                public void resetActionsInspectors() {
                    RuleInspector.this.actionsInspectors = null;
                }

                @Override
                public void resetConditionsInspectors() {
                    RuleInspector.this.conditionsInspectors = null;
                }
            }, this.configuration);
            this.patternInspectorList.add((HasUUID)patternInspector);
        }
    }

    private void updateBRLConditionInspectors(Collection<Condition> conditions) {
        this.brlConditionsInspectors.clear();
        for (Condition condition : conditions) {
            this.brlConditionsInspectors.add((HasUUID)new BRLConditionInspector((BRLCondition)condition, this.configuration));
        }
    }

    private void updateBRLActionInspectors(Collection<Action> actions) {
        this.brlActionInspectors.clear();
        for (Action action : actions) {
            this.brlActionInspectors.add((HasUUID)new BRLActionInspector((BRLAction)action, this.configuration));
        }
    }

    public InspectorList<ConditionsInspectorMultiMap> getConditionsInspectors() {
        if (this.conditionsInspectors == null) {
            this.makeConditionsInspectors();
        }
        return this.conditionsInspectors;
    }

    public InspectorList<ActionsInspectorMultiMap> getActionsInspectors() {
        if (this.actionsInspectors == null) {
            this.makeActionsInspectors();
        }
        return this.actionsInspectors;
    }

    public InspectorList<PatternInspector> getPatternsInspector() {
        return this.patternInspectorList;
    }

    public int getRowIndex() {
        return this.rule.getRowNumber();
    }

    public RuleInspectorCache getCache() {
        return this.cache;
    }

    public boolean isRedundant(Object other) {
        return other instanceof RuleInspector && this.brlConditionsInspectors.isRedundant(((RuleInspector)other).brlConditionsInspectors) && this.brlActionInspectors.isRedundant(((RuleInspector)other).brlActionInspectors) && this.getActionsInspectors().isRedundant(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().isRedundant(((RuleInspector)other).getConditionsInspectors());
    }

    public boolean subsumes(Object other) {
        return other instanceof RuleInspector && this.brlActionInspectors.subsumes(((RuleInspector)other).brlActionInspectors) && this.brlConditionsInspectors.subsumes(((RuleInspector)other).brlConditionsInspectors) && this.getActionsInspectors().subsumes(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().subsumes(((RuleInspector)other).getConditionsInspectors());
    }

    public boolean conflicts(Object other) {
        return other instanceof RuleInspector && this.getActionsInspectors().conflicts(((RuleInspector)other).getActionsInspectors()) && this.getConditionsInspectors().subsumes(((RuleInspector)other).getConditionsInspectors()) && this.getBrlConditionsInspectors().subsumes(((RuleInspector)other).getBrlConditionsInspectors());
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean isDeficient(RuleInspector other) {
        if (other.atLeastOneActionHasAValue() && !this.getActionsInspectors().conflicts(other.getActionsInspectors())) {
            return false;
        }
        Collection allConditionsFromTheOtherRule = ((Conditions.ConditionSelector)other.rule.getConditions().where(Condition.value().any()).select()).all();
        if (allConditionsFromTheOtherRule.isEmpty()) {
            return true;
        }
        for (Condition condition : allConditionsFromTheOtherRule) {
            if (condition.getValues() == null || !(condition instanceof FieldCondition)) continue;
            FieldCondition fieldCondition = (FieldCondition)condition;
            Conditions conditions = ((Fields.FieldSelector)((Patterns.PatternsSelect)this.rule.getPatterns().where((Matcher)Pattern.name().is((Comparable)((Object)fieldCondition.getField().getFactType()))).select()).fields().where((Matcher)Field.name().is((Comparable)((Object)fieldCondition.getField().getName()))).select()).conditions();
            if (!((Conditions.ConditionSelector)conditions.where(Condition.value().any()).select()).exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return !this.atLeastOneConditionHasAValue() && !this.atLeastOneActionHasAValue();
    }

    public boolean atLeastOneActionHasAValue() {
        int amountOfActions = ((Actions.ActionSelect)this.rule.getActions().where(Action.value().any()).select()).all().size();
        return amountOfActions > 0;
    }

    public boolean atLeastOneConditionHasAValue() {
        int amountOfConditions = ((Conditions.ConditionSelector)this.rule.getConditions().where(Condition.value().any()).select()).all().size();
        return amountOfConditions > 0;
    }

    public String toHumanReadableString() {
        return this.rule.getRowNumber().toString();
    }

    public InspectorList<ConditionInspector> getBrlConditionsInspectors() {
        return this.brlConditionsInspectors;
    }

    public InspectorList<ActionInspector> getBrlActionInspectors() {
        return this.brlActionInspectors;
    }

    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }

    public Set<Check> getChecks() {
        return this.checkStorage.getChecks(this);
    }

    private void makeChecks() {
        this.checkStorage.makeChecks(this);
    }

    public Set<Check> clearChecks() {
        return this.checkStorage.remove(this);
    }
}

