/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks.base;

import java.util.Optional;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.configuration.CheckConfiguration;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.checks.base.Check;
import org.kie.soup.commons.validation.PortablePreconditions;

public abstract class CheckBase
implements Check {
    protected final AnalyzerConfiguration configuration;
    protected boolean hasIssues = false;

    public CheckBase(AnalyzerConfiguration configuration) {
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    @Override
    public boolean hasIssues() {
        return this.hasIssues;
    }

    @Override
    public final Issue getIssue() {
        return this.makeIssue(this.resolveSeverity(), this.getCheckType());
    }

    protected abstract Issue makeIssue(Severity var1, CheckType var2);

    protected abstract CheckType getCheckType();

    protected abstract Severity getDefaultSeverity();

    @Override
    public boolean isActive(CheckConfiguration checkConfiguration) {
        return checkConfiguration.getCheckConfiguration().contains(this.getCheckType());
    }

    protected Severity resolveSeverity() {
        Optional severityOverwrite = this.configuration.getCheckConfiguration().getSeverityOverwrite(this.getCheckType());
        if (severityOverwrite.isPresent()) {
            return (Severity)severityOverwrite.get();
        }
        return this.getDefaultSeverity();
    }
}

