/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.verifier.webworker.client;

import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.api.client.index.Action;
import org.drools.workbench.services.verifier.api.client.index.Actions;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.Columns;
import org.drools.workbench.services.verifier.api.client.index.Condition;
import org.drools.workbench.services.verifier.api.client.index.Conditions;
import org.drools.workbench.services.verifier.api.client.index.Index;
import org.drools.workbench.services.verifier.api.client.index.Rule;
import org.drools.workbench.services.verifier.api.client.index.Rules;
import org.drools.workbench.services.verifier.api.client.index.matchers.Matcher;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.Logger;
import org.drools.workbench.verifier.webworker.client.UpdateException;

public abstract class CellUpdateManagerBase {
    protected final Column column;
    protected final Actions actions;
    protected final Conditions conditions;
    protected final GuidedDecisionTable52 model;
    protected final Coordinate coordinate;

    public CellUpdateManagerBase(Index index, GuidedDecisionTable52 model, Coordinate coordinate) throws UpdateException {
        this.model = model;
        this.coordinate = coordinate;
        Logger.add((String)("Updating: " + coordinate.toString()));
        try {
            this.column = (Column)((Columns.ColumnSelect)index.getColumns().where((Matcher)Column.index().is((Comparable)Integer.valueOf(coordinate.getCol()))).select()).first();
            Rule rule = (Rule)((Rules.RulesSelect)index.getRules().where((Matcher)Rule.index().is((Comparable)Integer.valueOf(coordinate.getRow()))).select()).first();
            this.actions = rule.getActions();
            this.conditions = rule.getConditions();
        }
        catch (Exception e) {
            throw new UpdateException("Failed to update: " + coordinate.toString());
        }
    }

    public boolean update() {
        if (!this.updateCondition()) {
            return this.updateAction();
        }
        return true;
    }

    private boolean updateCondition() {
        Condition condition = (Condition)((Conditions.ConditionSelector)this.conditions.where((Matcher)Condition.columnUUID().is((Comparable)this.column.getUuidKey())).select()).first();
        if (condition != null) {
            return this.updateCondition(condition);
        }
        return false;
    }

    private boolean updateAction() {
        Action action = (Action)((Actions.ActionSelect)this.actions.where((Matcher)Action.columnUUID().is((Comparable)this.column.getUuidKey())).select()).first();
        if (action != null) {
            return this.updateAction(action);
        }
        return false;
    }

    protected abstract boolean updateCondition(Condition var1);

    protected abstract boolean updateAction(Action var1);
}

