/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifierWebWorkerServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifierWebWorkerServlet.class);

    public static String loadResource(String name) throws Exception {
        InputStream in = VerifierWebWorkerServlet.class.getResourceAsStream(name);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Loading verifier web worker");
        try {
            String fileName;
            String requestURI = request.getRequestURI();
            int indexOf = requestURI.indexOf("/verifier");
            if (indexOf >= 0 && (fileName = requestURI.substring(indexOf)).endsWith("cache.js")) {
                byte[] bytes = VerifierWebWorkerServlet.loadResource(fileName).getBytes();
                response.setContentType("application/javascript");
                response.getOutputStream().write(bytes, 0, bytes.length);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load verifier web worker.");
        }
    }
}

