/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client;

import java.util.HashSet;
import java.util.List;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Rule;
import org.drools.verifier.core.index.model.Rules;
import org.drools.verifier.core.main.Analyzer;
import org.drools.verifier.core.util.PortablePreconditions;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.api.FactTypes;
import org.drools.workbench.services.verifier.plugin.client.api.HeaderMetaData;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.BuilderFactory;
import org.drools.workbench.services.verifier.plugin.client.builders.VerifierColumnUtilities;
import org.drools.workbench.services.verifier.plugin.client.util.NullEqualityOperator;
import org.drools.workbench.services.verifier.webworker.client.CellUpdateManagerBase;
import org.drools.workbench.services.verifier.webworker.client.NullEqualityOperatorCellUpdateManager;
import org.drools.workbench.services.verifier.webworker.client.RegularCellUpdateManager;
import org.drools.workbench.services.verifier.webworker.client.UpdateException;

public class DTableUpdateManager {
    private static final int ROW_NUMBER_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private Index index;
    private final Analyzer analyzer;
    private final AnalyzerConfiguration configuration;

    public DTableUpdateManager(Index index, Analyzer analyzer, AnalyzerConfiguration configuration) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.analyzer = (Analyzer)PortablePreconditions.checkNotNull((String)"analyzer", (Object)analyzer);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    public void removeRule(Integer rowDeleted) {
        this.analyzer.removeRule((Integer)PortablePreconditions.checkNotNull((String)"rowDeleted", (Object)rowDeleted));
    }

    public void update(GuidedDecisionTable52 model, List<Coordinate> coordinates) throws UpdateException {
        boolean hadUpdates;
        PortablePreconditions.checkNotNull((String)"model", (Object)model);
        PortablePreconditions.checkNotNull((String)"coordinates", coordinates);
        HashSet<Integer> canBeUpdated = new HashSet<Integer>();
        for (Coordinate coordinate : coordinates) {
            if (coordinate.getCol() == 0 || coordinate.getCol() == 1 || !this.getCellUpdateManager(coordinate, model).update()) continue;
            canBeUpdated.add(coordinate.getRow());
        }
        boolean bl = hadUpdates = !canBeUpdated.isEmpty();
        if (hadUpdates) {
            this.analyzer.update(canBeUpdated);
            this.analyzer.analyze();
        }
    }

    private CellUpdateManagerBase getCellUpdateManager(Coordinate coordinate, GuidedDecisionTable52 model) throws UpdateException {
        BaseColumn baseColumn = (BaseColumn)model.getExpandedColumns().get(coordinate.getCol());
        if (this.isConditionColumnWithSpecialOperator(baseColumn)) {
            return new NullEqualityOperatorCellUpdateManager(this.index, model, coordinate);
        }
        return new RegularCellUpdateManager(this.index, model, coordinate);
    }

    private boolean isConditionColumnWithSpecialOperator(BaseColumn baseColumn) {
        return baseColumn instanceof ConditionCol52 && NullEqualityOperator.contains((String)((ConditionCol52)baseColumn).getOperator());
    }

    public void newColumn(GuidedDecisionTable52 model, HeaderMetaData headerMetaData, FactTypes factTypes, int columnIndex) throws BuildException {
        PortablePreconditions.checkNotNull((String)"model", (Object)model);
        PortablePreconditions.checkNotNull((String)"headerMetaData", (Object)headerMetaData);
        PortablePreconditions.checkNotNull((String)"fieldTypes", (Object)factTypes);
        PortablePreconditions.checkNotNull((String)"columnIndex", (Object)columnIndex);
        BuilderFactory builderFactory = new BuilderFactory(new VerifierColumnUtilities(model, headerMetaData, factTypes), this.index, model, headerMetaData, this.configuration);
        Column column = builderFactory.getColumnBuilder().with(columnIndex).build();
        this.analyzer.newColumn(column);
        int rowIndex = 0;
        for (List row : model.getData()) {
            BaseColumn baseColumn = (BaseColumn)model.getExpandedColumns().get(columnIndex);
            Rule rule = (Rule)((Rules.RulesSelect)this.index.getRules().where((Matcher)Rule.index().is((Comparable)Integer.valueOf(rowIndex))).select()).first();
            builderFactory.getCellBuilder().with(columnIndex).with(baseColumn).with(rule).with(row).build();
            ++rowIndex;
        }
        this.analyzer.resetChecks();
        this.analyzer.analyze();
    }

    public void deleteColumns(int firstColumnIndex, int numberOfColumns) {
        PortablePreconditions.checkNotNull((String)"firstColumnIndex", (Object)firstColumnIndex);
        PortablePreconditions.checkNotNull((String)"numberOfColumns", (Object)numberOfColumns);
        this.analyzer.deleteColumn(firstColumnIndex);
        this.analyzer.resetChecks();
        this.analyzer.analyze();
    }

    public void makeRule(GuidedDecisionTable52 model, HeaderMetaData headerMetaData, FactTypes factTypes, int rowIndex) throws BuildException {
        PortablePreconditions.checkNotNull((String)"model", (Object)model);
        PortablePreconditions.checkNotNull((String)"fieldTypes", (Object)factTypes);
        PortablePreconditions.checkNotNull((String)"index", (Object)rowIndex);
        Rule rule = new BuilderFactory(new VerifierColumnUtilities(model, headerMetaData, factTypes), this.index, model, headerMetaData, this.configuration).getRuleBuilder().with(rowIndex).build();
        this.analyzer.newRule(rule);
        this.analyzer.analyze();
    }
}

