/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client;

import java.util.Set;
import org.drools.verifier.api.Status;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Issues;
import org.drools.verifier.core.checks.base.CheckRunner;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.main.Analyzer;
import org.drools.verifier.core.main.Reporter;
import org.drools.workbench.services.verifier.plugin.client.api.DeleteColumns;
import org.drools.workbench.services.verifier.plugin.client.api.Initialize;
import org.drools.workbench.services.verifier.plugin.client.api.MakeRule;
import org.drools.workbench.services.verifier.plugin.client.api.NewColumn;
import org.drools.workbench.services.verifier.plugin.client.api.RemoveRule;
import org.drools.workbench.services.verifier.plugin.client.api.RequestStatus;
import org.drools.workbench.services.verifier.plugin.client.api.Update;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.webworker.client.AnalyzerBuilder;
import org.drools.workbench.services.verifier.webworker.client.DTableUpdateManager;
import org.drools.workbench.services.verifier.webworker.client.Poster;
import org.drools.workbench.services.verifier.webworker.client.UpdateException;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.verifier.api.client.api.WebWorkerException;

public class Receiver {
    private Analyzer analyzer;
    private Poster poster;
    private CheckRunner checkRunner;
    private Issues latestReport;
    private Index index;
    private AnalyzerConfiguration configuration;

    public Receiver(Poster poster, CheckRunner checkRunner) {
        this.poster = (Poster)PortablePreconditions.checkNotNull((String)"poster", (Object)poster);
        this.checkRunner = (CheckRunner)PortablePreconditions.checkNotNull((String)"checkRunner", (Object)checkRunner);
    }

    public void received(Object o) {
        if (o instanceof Initialize) {
            this.init((Initialize)o);
        } else if (o instanceof RequestStatus) {
            this.requestStatus();
        } else if (o instanceof RemoveRule) {
            this.removeRule((RemoveRule)o);
        } else if (o instanceof Update) {
            this.update((Update)o);
        } else if (o instanceof DeleteColumns) {
            this.deleteColumns((DeleteColumns)o);
        } else if (o instanceof MakeRule) {
            this.makeRule((MakeRule)o);
        } else if (o instanceof NewColumn) {
            this.newColumn((NewColumn)o);
        }
    }

    private void removeRule(RemoveRule removeRule) {
        try {
            this.getUpdateManager().removeRule(removeRule.getDeletedRow());
        }
        catch (Exception e) {
            this.poster.post(new WebWorkerException("Failed to remove a rule: " + e.getMessage()));
        }
    }

    private void deleteColumns(DeleteColumns deleteColumns) {
        try {
            this.getUpdateManager().deleteColumns(deleteColumns.getFirstColumnIndex(), deleteColumns.getNumberOfColumns());
        }
        catch (Exception e) {
            this.poster.post(new WebWorkerException("Deleting columns failed: " + e.getMessage()));
        }
    }

    private void update(Update update) {
        try {
            this.getUpdateManager().update(update.getModel(), update.getCoordinates());
        }
        catch (UpdateException e) {
            this.poster.post(new WebWorkerException("Dtable update failed: " + e.getMessage()));
        }
    }

    private void requestStatus() {
        if (this.latestReport != null) {
            this.poster.post(this.latestReport);
        }
    }

    private void newColumn(NewColumn newColumn) {
        try {
            this.getUpdateManager().newColumn(newColumn.getModel(), newColumn.getHeaderMetaData(), newColumn.getFactTypes(), newColumn.getColumnIndex());
        }
        catch (BuildException buildException) {
            this.poster.post(new WebWorkerException("Adding a new column failed: " + buildException.getMessage()));
        }
    }

    private void makeRule(MakeRule makeRule) {
        try {
            this.getUpdateManager().makeRule(makeRule.getModel(), makeRule.getHeaderMetaData(), makeRule.getFactTypes(), makeRule.getIndex());
        }
        catch (BuildException buildException) {
            this.poster.post(new WebWorkerException("Rule Creation failed: " + buildException.getMessage()));
        }
    }

    private DTableUpdateManager getUpdateManager() {
        return new DTableUpdateManager(this.index, this.analyzer, this.configuration);
    }

    private void init(final Initialize initialize) {
        try {
            AnalyzerBuilder analyzerBuilder = new AnalyzerBuilder().with(initialize).with(this.checkRunner).with(new Reporter(){

                public void sendReport(Set<Issue> issues) {
                    Receiver.this.latestReport = new Issues(initialize.getUuid(), issues);
                    Receiver.this.poster.post(Receiver.this.latestReport);
                }

                public void sendStatus(Status status) {
                    Receiver.this.poster.post(status);
                }
            });
            this.analyzer = analyzerBuilder.buildAnalyzer();
            this.index = analyzerBuilder.getIndex();
            this.configuration = analyzerBuilder.getConfiguration();
            this.analyzer.resetChecks();
            this.analyzer.analyze();
        }
        catch (BuildException e) {
            this.poster.post(new WebWorkerException("Initialization failed: " + e.getMessage()));
        }
    }
}

