/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.webworker.client;

import java.util.List;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Condition;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.builders.ActionBuilder;
import org.drools.workbench.services.verifier.webworker.client.CellUpdateManagerBase;
import org.drools.workbench.services.verifier.webworker.client.UpdateException;

public class RegularCellUpdateManager
extends CellUpdateManagerBase {
    private final Values values;

    public RegularCellUpdateManager(Index index, GuidedDecisionTable52 model, Coordinate coordinate) throws UpdateException {
        super(index, model, coordinate);
        this.values = this.getValue((DTCellValue52)((List)model.getData().get(coordinate.getRow())).get(coordinate.getCol()));
    }

    @Override
    protected boolean updateAction(Action action) {
        Values comparable = action.getValues();
        if (this.values.isThereChanges(comparable)) {
            action.setValue(this.values);
            return true;
        }
        return false;
    }

    @Override
    protected boolean updateCondition(Condition condition) {
        Values oldValues = condition.getValues();
        if (this.values == null && oldValues == null) {
            return false;
        }
        if (this.values == null || oldValues == null) {
            condition.setValue(this.values);
            return true;
        }
        if (this.values.isThereChanges(oldValues)) {
            condition.setValue(this.values);
            return true;
        }
        return false;
    }

    private Values getValue(DTCellValue52 cell) {
        Comparable value = ActionBuilder.getValue((DTCellValue52)cell);
        if (value == null) {
            return new Values();
        }
        if (value instanceof String && ((String)((Object)value)).isEmpty()) {
            return new Values();
        }
        Values values = new Values();
        values.add((Object)value);
        return values;
    }
}

