/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Value;

public interface MultiMapChangeHandler<T> {

    void onChange( final ChangeSet<T> changeSet );

    class ChangeSet<T> {
        final MultiMap<Value, T> added   = new MultiMap();
        final MultiMap<Value, T> updated = new MultiMap();
        final MultiMap<Value, T> removed = new MultiMap();

        public MultiMap<Value, T> getAdded() {
            return added;
        }

        public MultiMap<Value, T> getUpdated() {
            return updated;
        }

        public MultiMap<Value, T> getRemoved() {
            return removed;
        }
    }
}
