/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys;

import java.util.ArrayList;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.HasKeys;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.KeyDefinition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.RetractHandler;
import org.uberfire.ext.wires.core.api.shapes.UUID;

public class UUIDKey
        extends Key {

    public static final KeyDefinition UNIQUE_UUID = KeyDefinition.newKeyDefinition().withId( "unique---uuid" ).build();

    private ArrayList<RetractHandler> retractHandlers = new ArrayList<>();

    private HasKeys hasKeys;

    public UUIDKey( final HasKeys hasKeys ) {
        super( UNIQUE_UUID,
               UUID.uuid() );
        this.hasKeys = hasKeys;
    }

    public static UUIDKey getUUIDKey( final Key[] keys ) {
        UUIDKey result = null;
        for ( final Key key : keys ) {
            if ( key instanceof UUIDKey ) {

                if ( result == null ) {
                    result = ( UUIDKey ) key;
                } else {
                    throw new IllegalArgumentException( "You can only have one uuid key." );
                }
            }
        }

        if ( result == null ) {
            throw new IllegalArgumentException( "You must set a uuid key." );
        } else {
            return result;
        }
    }

    public void retract() {
        for ( final RetractHandler retractHandler : retractHandlers ) {
            retractHandler.retract( this );
        }
    }

    public void addRetractHandler( final RetractHandler retractHandler ) {
        retractHandlers.add( retractHandler );
    }

    public Key[] getKeys() {
        return hasKeys.keys();
    }

    @Override
    public int compareTo( final Key key ) {
        return getSingleValue().compareTo( key.getSingleValue() );
    }

}
