/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.select;

import java.util.Collection;

import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.ChangeHandledMultiMap;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.cache.KeyDefinition;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.keys.Value;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.index.matchers.ExactMatcher;
import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class ListenAllTest {


    private Listen<String>                listen;
    private ChangeHandledMultiMap<String> map;
    private Collection<String>            all;

    @Before
    public void setUp() throws Exception {
        map = new ChangeHandledMultiMap<>();

        listen = new Listen<>( map,
                               new ExactMatcher( KeyDefinition.newKeyDefinition().withId( "ID" ).build(),
                                                 "value" ) );

        listen.all( new AllListener<String>() {
            @Override
            public void onAllChanged( final Collection<String> all ) {
                ListenAllTest.this.all = all;
            }
        } );
    }

    @Test
    public void testEmpty() throws Exception {
        assertNull( all );
    }

    @Test
    public void testAll() throws Exception {
        map.put( new Value( "value" ),
                 "hello" );

        assertTrue( all.contains( "hello" ) );
    }
}