/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.workbench.services.verifier.api.client.maps;

import java.util.List;

public interface MultiMapChangeHandler<V extends Comparable, T> {

    void onChange( final ChangeSet<V, T> changeSet );

    class ChangeSet<V extends Comparable, T> {
        final MultiMap<V, T, List<T>> added   = MultiMapFactory.make();
        final MultiMap<V, T, List<T>> removed = MultiMapFactory.make();

        public MultiMap<V, T, List<T>> getAdded() {
            return added;
        }

        public MultiMap<V, T, List<T>> getRemoved() {
            return removed;
        }
    }
}
