/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.workbench.screens.scenariosimulation.client.commands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

@RunWith(GwtMockitoTestRunner.class)
public class DeleteRowCommandTest extends AbstractCommandTest {



    private DeleteRowCommand deleteRowCommand;

    @Before
    public void setup() {
        super.setup();
        deleteRowCommand = new DeleteRowCommand(mockScenarioGridModel, ROW_INDEX);
    }

    @Test
    public void execute() {
        deleteRowCommand.execute();
        verify(mockScenarioGridModel, times(1)).deleteNewRow(eq(ROW_INDEX));
    }
}