/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.reset;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

@RunWith(GwtMockitoTestRunner.class)
public class SourceTypeSelectorTest {

    @Mock
    private TitledAttachmentFileWidget uploadWidgetMock;

    private SourceTypeSelector sourceTypeSelector;

    @Before
    public void setUp() throws Exception {
        sourceTypeSelector = spy(new SourceTypeSelector(uploadWidgetMock));
    }

    @Test
    public void onValueChange() {
        reset(uploadWidgetMock);
        ValueChangeEvent eventMock = mock(ValueChangeEvent.class);
        doReturn(false).when(sourceTypeSelector).isDMNSelected();
        sourceTypeSelector.onValueChange(eventMock);
        verify(uploadWidgetMock, never()).updateAssetList();
        doReturn(true).when(sourceTypeSelector).isDMNSelected();
        sourceTypeSelector.onValueChange(eventMock);
        verify(uploadWidgetMock, times(1)).updateAssetList();
    }

    @Test
    public void addRadioButtons() {
        reset(uploadWidgetMock);
        sourceTypeSelector.addRadioButtons();
        assertEquals(2, sourceTypeSelector.radioButtonList.size());
        verify(uploadWidgetMock, times(1)).setVisible(false);

    }
}