/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.workitem.email;

import org.drools.process.instance.WorkItemHandler;
import org.drools.process.workitem.email.Connection;
import org.drools.process.workitem.email.Email;
import org.drools.process.workitem.email.Message;
import org.drools.process.workitem.email.Recipient;
import org.drools.process.workitem.email.Recipients;
import org.drools.process.workitem.email.SendHtml;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemManager;

public class EmailWorkItemHandler
implements WorkItemHandler {
    private Connection connection;

    public void setConnection(String host, String port, String userName, String password) {
        this.connection = new Connection();
        this.connection.setHost(host);
        this.connection.setPort(port);
        this.connection.setUserName(userName);
        this.connection.setPassword(password);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String bcc;
        if (this.connection == null) {
            throw new IllegalArgumentException("Connection not initialized for Email");
        }
        Email email = new Email();
        Message message = new Message();
        message.setFrom((String)workItem.getParameter("From"));
        message.setReplyTo((String)workItem.getParameter("Reply-To"));
        Recipients recipients = new Recipients();
        String to = (String)workItem.getParameter("To");
        if (to == null || to.trim().length() == 0) {
            throw new RuntimeException("Email must have one or more to adresses");
        }
        for (String s : to.split(";")) {
            if (s == null || "".equals(s)) continue;
            Recipient recipient = new Recipient();
            recipient.setEmail(s);
            recipient.setType("To");
            recipients.addRecipient(recipient);
        }
        String cc = (String)workItem.getParameter("Cc");
        if (cc != null && cc.trim().length() > 0) {
            for (String s : cc.split(";")) {
                if (s == null || "".equals(s)) continue;
                Recipient recipient = new Recipient();
                recipient.setEmail(s);
                recipient.setType("Cc");
                recipients.addRecipient(recipient);
            }
        }
        if ((bcc = (String)workItem.getParameter("Bcc")) != null && bcc.trim().length() > 0) {
            for (String s : bcc.split(";")) {
                if (s == null || "".equals(s)) continue;
                Recipient recipient = new Recipient();
                recipient.setEmail(s);
                recipient.setType("Bcc");
                recipients.addRecipient(recipient);
            }
        }
        message.setRecipients(recipients);
        message.setSubject((String)workItem.getParameter("Subject"));
        message.setBody((String)workItem.getParameter("Body"));
        email.setMessage(message);
        email.setConnection(this.connection);
        SendHtml.sendHtml(email);
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem arg0, WorkItemManager arg1) {
    }
}

