/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.workitem.email;

import java.util.ArrayList;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;
import org.drools.process.instance.impl.DefaultWorkItemManager;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.process.workitem.email.EmailWorkItemHandler;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemManager;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassLoaderUtil;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class EmailWorkItemHandlerTest
extends TestCase {
    Wiser wiser;
    String emailHost;
    String emailPort;

    protected void setUp() throws Exception {
        ChainedProperties props = new ChainedProperties("email.conf", (ClassLoader)ClassLoaderUtil.getClassLoader(null, ((Object)((Object)this)).getClass(), (boolean)false));
        this.emailHost = props.getProperty("host", "localhost");
        this.emailPort = props.getProperty("port", "2345");
        this.wiser = new Wiser();
        this.wiser.setHostname(this.emailHost);
        this.wiser.setPort(Integer.parseInt(this.emailPort));
        this.wiser.start();
    }

    protected void tearDown() throws Exception {
        this.wiser.stop();
    }

    public void test1() {
    }

    public void FIXME_testSingleTo() throws Exception {
        EmailWorkItemHandler handler = new EmailWorkItemHandler();
        handler.setConnection(this.emailHost, this.emailPort, null, null);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)"person1@domain.com");
        workItem.setParameter("From", (Object)"person2@domain.com");
        workItem.setParameter("Reply-To", (Object)"person3@domain.com");
        workItem.setParameter("Subject", (Object)"Subject 1");
        workItem.setParameter("Body", (Object)"Body 1");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        EmailWorkItemHandlerTest.assertEquals((int)1, (int)this.wiser.getMessages().size());
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Body"), (Object)msg.getContent());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Subject"), (Object)msg.getSubject());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Reply-To"), (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("To"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        EmailWorkItemHandlerTest.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.CC));
        EmailWorkItemHandlerTest.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.BCC));
    }

    public void FIXME_testSingleToWithSingleCCAndBCC() throws Exception {
        EmailWorkItemHandler handler = new EmailWorkItemHandler();
        handler.setConnection(this.emailHost, this.emailPort, null, null);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)"person1@domain.com");
        workItem.setParameter("Cc", (Object)"person2@domain.com");
        workItem.setParameter("Bcc", (Object)"person3@domain.com");
        workItem.setParameter("From", (Object)"person4@domain.com");
        workItem.setParameter("Reply-To", (Object)"person5@domain.com");
        workItem.setParameter("Subject", (Object)"Subject 1");
        workItem.setParameter("Body", (Object)"Body 1");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        EmailWorkItemHandlerTest.assertEquals((int)3, (int)this.wiser.getMessages().size());
        ArrayList<String> list = new ArrayList<String>(3);
        list.add(((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(1)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(2)).getEnvelopeReceiver());
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person1@domain.com"));
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person2@domain.com"));
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person3@domain.com"));
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeSender());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Body"), (Object)msg.getContent());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Subject"), (Object)msg.getSubject());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Reply-To"), (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("To"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Cc"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.CC)[0]).getAddress());
        msg = ((WiserMessage)this.wiser.getMessages().get(1)).getMimeMessage();
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((WiserMessage)this.wiser.getMessages().get(1)).getEnvelopeSender());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Body"), (Object)msg.getContent());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Subject"), (Object)msg.getSubject());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Reply-To"), (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("To"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Cc"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.CC)[0]).getAddress());
        msg = ((WiserMessage)this.wiser.getMessages().get(2)).getMimeMessage();
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((WiserMessage)this.wiser.getMessages().get(2)).getEnvelopeSender());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Body"), (Object)msg.getContent());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Subject"), (Object)msg.getSubject());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Reply-To"), (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("To"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Cc"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.CC)[0]).getAddress());
    }

    public void FIXME_testMultipleToWithSingleCCAndBCC() throws Exception {
        EmailWorkItemHandler handler = new EmailWorkItemHandler();
        handler.setConnection(this.emailHost, this.emailPort, null, null);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)"person1@domain.com; person2@domain.com");
        workItem.setParameter("Cc", (Object)"person3@domain.com; person4@domain.com");
        workItem.setParameter("Bcc", (Object)"person5@domain.com; person6@domain.com");
        workItem.setParameter("From", (Object)"person4@domain.com");
        workItem.setParameter("Reply-To", (Object)"person5@domain.com");
        workItem.setParameter("Subject", (Object)"Subject 1");
        workItem.setParameter("Body", (Object)"Body 1");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        EmailWorkItemHandlerTest.assertEquals((int)6, (int)this.wiser.getMessages().size());
        ArrayList<String> list = new ArrayList<String>(6);
        list.add(((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(1)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(2)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(3)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(4)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(5)).getEnvelopeReceiver());
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person1@domain.com"));
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person2@domain.com"));
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person3@domain.com"));
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person4@domain.com"));
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person5@domain.com"));
        EmailWorkItemHandlerTest.assertTrue((boolean)list.contains("person6@domain.com"));
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeSender());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Body"), (Object)msg.getContent());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Subject"), (Object)msg.getSubject());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("From"), (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Reply-To"), (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("To"), (Object)(((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress() + "; " + ((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[1]).getAddress()));
        EmailWorkItemHandlerTest.assertEquals((Object)workItem.getParameter("Cc"), (Object)(((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.CC)[0]).getAddress() + "; " + ((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.CC)[1]).getAddress()));
    }
}

