/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.modeldriven.dt;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.DescriptionCol;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;
import org.junit.Assert;
import org.junit.Test;

public class GuidedDecisionTableTest {
    @Test
    public void testValueLists() {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        ConditionCol c1 = new ConditionCol();
        c1.setBoundName("c1");
        c1.setFactType("Driver");
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        dt.getConditionCols().add(c1);
        ConditionCol c1_ = new ConditionCol();
        c1_.setBoundName("c1");
        c1_.setFactType("Driver");
        c1_.setFactField("name");
        c1_.setConstraintValueType(3);
        dt.getConditionCols().add(c1_);
        ConditionCol c1__ = new ConditionCol();
        c1__.setBoundName("c1");
        c1__.setFactType("Driver");
        c1__.setFactField("name");
        c1__.setConstraintValueType(1);
        c1__.setValueList("one,two,three");
        dt.getConditionCols().add(c1__);
        ConditionCol c2 = new ConditionCol();
        c2.setBoundName("c2");
        c2.setFactType("Driver");
        c2.setFactField("nothing");
        c2.setConstraintValueType(1);
        dt.getConditionCols().add(c2);
        ActionSetFieldCol asf = new ActionSetFieldCol();
        asf.setBoundName("c1");
        asf.setFactField("name");
        dt.getActionCols().add(asf);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.setBoundName("x");
        ins.setFactField("rating");
        ins.setFactType("Person");
        dt.getActionCols().add(ins);
        ActionInsertFactCol ins_ = new ActionInsertFactCol();
        ins_.setBoundName("x");
        ins_.setFactField("rating");
        ins_.setFactType("Person");
        ins_.setValueList("one,two,three");
        dt.getActionCols().add(ins_);
        ActionSetFieldCol asf_ = new ActionSetFieldCol();
        asf_.setBoundName("c1");
        asf_.setFactField("goo");
        dt.getActionCols().add(asf_);
        ActionSetFieldCol asf__ = new ActionSetFieldCol();
        asf__.setBoundName("c1");
        asf__.setFactField("goo");
        asf__.setValueList("one,two,three");
        dt.getActionCols().add(asf__);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.putDataEnumList("Driver.name", new String[]{"bob", "michael"});
        sce.putDataEnumList("Person.rating", new String[]{"1", "2"});
        String[] r = dt.getValueList((DTColumnConfig)c1, sce);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"bob", (Object)r[0]);
        Assert.assertEquals((Object)"michael", (Object)r[1]);
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig)c1_, sce).length);
        r = dt.getValueList((DTColumnConfig)c1__, sce);
        Assert.assertEquals((long)3L, (long)r.length);
        Assert.assertEquals((Object)"one", (Object)r[0]);
        Assert.assertEquals((Object)"two", (Object)r[1]);
        Assert.assertEquals((Object)"three", (Object)r[2]);
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig)c2, sce).length);
        r = dt.getValueList((DTColumnConfig)asf, sce);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"bob", (Object)r[0]);
        Assert.assertEquals((Object)"michael", (Object)r[1]);
        r = dt.getValueList((DTColumnConfig)ins, sce);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"1", (Object)r[0]);
        Assert.assertEquals((Object)"2", (Object)r[1]);
        r = dt.getValueList((DTColumnConfig)ins_, sce);
        Assert.assertEquals((long)3L, (long)r.length);
        Assert.assertEquals((Object)"one", (Object)r[0]);
        Assert.assertEquals((Object)"two", (Object)r[1]);
        Assert.assertEquals((Object)"three", (Object)r[2]);
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig)asf_, sce).length);
        r = dt.getValueList((DTColumnConfig)asf__, sce);
        Assert.assertEquals((long)3L, (long)r.length);
        Assert.assertEquals((Object)"one", (Object)r[0]);
        Assert.assertEquals((Object)"two", (Object)r[1]);
        Assert.assertEquals((Object)"three", (Object)r[2]);
        AttributeCol at = new AttributeCol();
        at.setAttribute("no-loop");
        dt.getAttributeCols().add(at);
        r = dt.getValueList((DTColumnConfig)at, sce);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"true", (Object)r[0]);
        Assert.assertEquals((Object)"false", (Object)r[1]);
        at.setAttribute("enabled");
        Assert.assertEquals((long)2L, (long)dt.getValueList((DTColumnConfig)at, sce).length);
        at.setAttribute("salience");
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig)at, sce).length);
    }

    @Test
    public void testNumeric() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        AttributeCol at = new AttributeCol();
        at.setAttribute("salience");
        AttributeCol at_ = new AttributeCol();
        at_.setAttribute("enabled");
        dt.getAttributeCols().add(at);
        dt.getAttributeCols().add(at_);
        ConditionCol c1 = new ConditionCol();
        c1.setBoundName("c1");
        c1.setFactType("Driver");
        c1.setFactField("name");
        c1.setOperator("==");
        c1.setConstraintValueType(1);
        dt.getConditionCols().add(c1);
        ConditionCol c1_ = new ConditionCol();
        c1_.setBoundName("c1");
        c1_.setFactType("Driver");
        c1_.setFactField("age");
        c1_.setOperator("==");
        c1_.setConstraintValueType(1);
        dt.getConditionCols().add(c1_);
        ConditionCol c2 = new ConditionCol();
        c2.setBoundName("c1");
        c2.setFactType("Driver");
        c2.setFactField("age");
        c2.setConstraintValueType(1);
        dt.getConditionCols().add(c2);
        ActionSetFieldCol a = new ActionSetFieldCol();
        a.setBoundName("c1");
        a.setFactField("name");
        dt.getActionCols().add(a);
        ActionSetFieldCol a2 = new ActionSetFieldCol();
        a2.setBoundName("c1");
        a2.setFactField("age");
        dt.getActionCols().add(a2);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.setBoundName("x");
        ins.setFactType("Driver");
        ins.setFactField("name");
        dt.getActionCols().add(ins);
        ActionInsertFactCol ins_ = new ActionInsertFactCol();
        ins_.setBoundName("x");
        ins_.setFactType("Driver");
        ins_.setFactField("age");
        dt.getActionCols().add(ins_);
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig)at, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig)c1_, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig)a2, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig)ins_, sce));
        Assert.assertEquals((Object)"Boolean", (Object)dt.getType((DTColumnConfig)at_, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig)c1, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig)a, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig)ins, sce));
        Assert.assertEquals(null, (Object)dt.getType((DTColumnConfig)c2, sce));
    }

    @Test
    public void testGetType() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String"), new ModelField("date", Date.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Date"), new ModelField("approved", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Boolean")});
            }
        });
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        AttributeCol salienceAttribute = new AttributeCol();
        salienceAttribute.setAttribute("salience");
        AttributeCol enabledAttribute = new AttributeCol();
        enabledAttribute.setAttribute("enabled");
        dt.getAttributeCols().add(salienceAttribute);
        dt.getAttributeCols().add(enabledAttribute);
        ConditionCol conditionColName = new ConditionCol();
        conditionColName.setBoundName("c1");
        conditionColName.setFactType("Driver");
        conditionColName.setFactField("name");
        conditionColName.setOperator("==");
        conditionColName.setConstraintValueType(1);
        dt.getConditionCols().add(conditionColName);
        ConditionCol conditionColAge = new ConditionCol();
        conditionColAge.setBoundName("c1");
        conditionColAge.setFactType("Driver");
        conditionColAge.setFactField("age");
        conditionColAge.setOperator("==");
        conditionColAge.setConstraintValueType(1);
        dt.getConditionCols().add(conditionColAge);
        ConditionCol conditionColDate = new ConditionCol();
        conditionColDate.setBoundName("c1");
        conditionColDate.setFactType("Driver");
        conditionColDate.setFactField("date");
        conditionColDate.setOperator("==");
        conditionColDate.setConstraintValueType(1);
        dt.getConditionCols().add(conditionColDate);
        ConditionCol conditionColApproved = new ConditionCol();
        conditionColApproved.setBoundName("c1");
        conditionColApproved.setFactType("Driver");
        conditionColApproved.setFactField("approved");
        conditionColApproved.setOperator("==");
        conditionColApproved.setConstraintValueType(1);
        dt.getConditionCols().add(conditionColApproved);
        ConditionCol conditionColAge2 = new ConditionCol();
        conditionColAge2.setBoundName("c1");
        conditionColAge2.setFactType("Driver");
        conditionColAge2.setFactField("age");
        conditionColAge2.setConstraintValueType(1);
        dt.getConditionCols().add(conditionColAge2);
        ActionSetFieldCol a = new ActionSetFieldCol();
        a.setBoundName("c1");
        a.setFactField("name");
        dt.getActionCols().add(a);
        ActionSetFieldCol a2 = new ActionSetFieldCol();
        a2.setBoundName("c1");
        a2.setFactField("age");
        dt.getActionCols().add(a2);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.setBoundName("x");
        ins.setFactType("Driver");
        ins.setFactField("name");
        dt.getActionCols().add(ins);
        ActionInsertFactCol ins_ = new ActionInsertFactCol();
        ins_.setBoundName("x");
        ins_.setFactType("Driver");
        ins_.setFactField("age");
        dt.getActionCols().add(ins_);
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig)salienceAttribute, sce));
        Assert.assertEquals((Object)"Boolean", (Object)dt.getType((DTColumnConfig)enabledAttribute, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig)conditionColName, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig)conditionColAge, sce));
        Assert.assertEquals((Object)"Date", (Object)dt.getType((DTColumnConfig)conditionColDate, sce));
        Assert.assertEquals((Object)"Boolean", (Object)dt.getType((DTColumnConfig)conditionColApproved, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig)a, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig)a2, sce));
        Assert.assertEquals((Object)"String", (Object)dt.getType((DTColumnConfig)ins, sce));
        Assert.assertEquals((Object)"Numeric", (Object)dt.getType((DTColumnConfig)ins_, sce));
        Assert.assertEquals(null, (Object)dt.getType((DTColumnConfig)conditionColAge2, sce));
    }

    @Test
    public void testNoConstraintLists() {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        ConditionCol c1 = new ConditionCol();
        c1.setBoundName("c1");
        c1.setFactType("Driver");
        c1.setConstraintValueType(1);
        dt.getConditionCols().add(c1);
        ConditionCol c2 = new ConditionCol();
        c2.setBoundName("c2");
        c2.setFactType("Driver");
        c2.setConstraintValueType(1);
        c2.setValueList("a,b,c");
        dt.getConditionCols().add(c2);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.putDataEnumList("Driver.name", new String[]{"bob", "michael"});
        Assert.assertEquals((long)0L, (long)dt.getValueList((DTColumnConfig)c1, sce).length);
        Assert.assertEquals((long)3L, (long)dt.getValueList((DTColumnConfig)c2, sce).length);
    }

    @Test
    public void testNoConstraints() {
        TypeSafeGuidedDecisionTable dt = new TypeSafeGuidedDecisionTable();
        RowNumberCol rnc = new RowNumberCol();
        DescriptionCol dc = new DescriptionCol();
        MetadataCol mdc = new MetadataCol();
        mdc.setMetadata("cheese");
        AttributeCol ac = new AttributeCol();
        ac.setAttribute("salience");
        ActionSetFieldCol asfc = new ActionSetFieldCol();
        asfc.setBoundName("d1");
        asfc.setFactField("age");
        ActionInsertFactCol aifc = new ActionInsertFactCol();
        aifc.setBoundName("d2");
        aifc.setFactType("Driver");
        aifc.setFactField("age");
        ConditionCol c1 = new ConditionCol();
        c1.setBoundName("c1");
        c1.setFactType("Driver");
        c1.setConstraintValueType(1);
        dt.getConditionCols().add(c1);
        ConditionCol c2 = new ConditionCol();
        c2.setBoundName("c2");
        c2.setFactType("Driver");
        c2.setFactField("age");
        c2.setConstraintValueType(1);
        dt.getConditionCols().add(c2);
        ConditionCol c3 = new ConditionCol();
        c3.setBoundName("c3");
        c3.setFactType("Driver");
        c3.setOperator("==");
        c3.setConstraintValueType(1);
        dt.getConditionCols().add(c3);
        ConditionCol c4 = new ConditionCol();
        c4.setBoundName("c4");
        c4.setFactType("Driver");
        c4.setFactField("age");
        c4.setOperator("==");
        c4.setConstraintValueType(1);
        dt.getConditionCols().add(c4);
        ConditionCol c5 = new ConditionCol();
        c5.setBoundName("c5");
        c5.setFactType("Driver");
        c5.setConstraintValueType(5);
        dt.getConditionCols().add(c5);
        ConditionCol c6 = new ConditionCol();
        c6.setBoundName("c6");
        c6.setFactType("Driver");
        c6.setConstraintValueType(3);
        dt.getConditionCols().add(c6);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)rnc, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)dc, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)mdc, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)ac, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)asfc, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)aifc, sce));
        Assert.assertFalse((boolean)dt.isConstraintValid((DTColumnConfig)c1, sce));
        Assert.assertFalse((boolean)dt.isConstraintValid((DTColumnConfig)c2, sce));
        Assert.assertFalse((boolean)dt.isConstraintValid((DTColumnConfig)c3, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)c4, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)c5, sce));
        Assert.assertTrue((boolean)dt.isConstraintValid((DTColumnConfig)c6, sce));
    }
}

