/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.assistant;

import java.util.List;
import org.drools.ide.common.assistant.option.ReplaceAssistantOption;
import org.drools.ide.common.assistant.processor.AbstractRuleAssistantProcessor;
import org.drools.ide.common.assistant.processor.DRLRefactorProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DRLAssistantTest {
    private AbstractRuleAssistantProcessor ruleAssistant;
    private String rule;

    @Before
    public void setUp() throws Exception {
        this.ruleAssistant = new DRLRefactorProcessor();
        this.rule = "package org.drools.assistant.test;\n\n";
        this.rule = this.rule + "import org.drools.assistant.test.model.Company;\n";
        this.rule = this.rule + "IMPORT org.drools.assistant.test.model.Employee;\n\n";
        this.rule = this.rule + "import function org.drools.assistant.model.Class1.anotherFunction \n";
        this.rule = this.rule + "import\t\tfunction org.drools.assistant.model.Class1.mathFunction \n";
        this.rule = this.rule + "global     org.drools.assistant.test.model.Class2    results \n";
        this.rule = this.rule + "GLOBAL org.drools.assistant.test.model.Class3 current\n";
        this.rule = this.rule + "expander help-expander.dsl\n";
        this.rule = this.rule + "query \"all clients\"\n";
        this.rule = this.rule + "\tresult : Clients()\n";
        this.rule = this.rule + "end\n";
        this.rule = this.rule + "query \"new query\"\n";
        this.rule = this.rule + "\tobjects : Clients()\n";
        this.rule = this.rule + "end\n";
        this.rule = this.rule + "function String hello(String name) {\n";
        this.rule = this.rule + "    return \"Hello \"+name+\"!\";\n";
        this.rule = this.rule + "}\n";
        this.rule = this.rule + "function String helloWithAge(String name, Integer age) {\n";
        this.rule = this.rule + "    return \"Hello2 \"+name+\"! \" + age;\n";
        this.rule = this.rule + "}\n";
        this.rule = this.rule + "rule   \"My Test Rule\"\n";
        this.rule = this.rule + "when\n";
        this.rule = this.rule + "\t$employee : Employee($company : company, $company1 : oldcompany, $age : age > 80, salary > 400)\n";
        this.rule = this.rule + "\t$result : Company(company==$company, retireAge <= $age)\n";
        this.rule = this.rule + "then\n";
        this.rule = this.rule + "\tSystem.out.println(\"can retire\")\n";
        this.rule = this.rule + "end\n";
        this.rule = this.rule + "rule   \"My Second Rule\"\n";
        this.rule = this.rule + "when\n";
        this.rule = this.rule + "\tDriver(licence = 1234, $name : name)\n";
        this.rule = this.rule + "\t$car : Car(company : $company, ownerLicense == licence, year == 2009)\n";
        this.rule = this.rule + "then\n";
        this.rule = this.rule + "\tSystem.out.println(\"licence 1234 has a new car\")\n";
        this.rule = this.rule + "end\n";
    }

    @Test
    public void testAssignSalaryFieldToVariable() throws Exception {
        List options = this.ruleAssistant.getRuleAssistant(this.rule, Integer.valueOf(780));
        Assert.assertEquals((long)options.size(), (long)1L);
        ReplaceAssistantOption assistantOption = (ReplaceAssistantOption)options.get(0);
        Assert.assertEquals((Object)"\t$employee : Employee($company : company, $company1 : oldcompany, $age : age > 80, salary $ : > 400)", (Object)assistantOption.getContent());
    }

    @Test
    public void testDontAssignFieldInsideRHS() throws Exception {
        List options = this.ruleAssistant.getRuleAssistant(this.rule, Integer.valueOf(840));
        Assert.assertEquals((long)options.size(), (long)0L);
    }

    @Test
    public void testAssignLicenseFromSecondRule() throws Exception {
        List options = this.ruleAssistant.getRuleAssistant(this.rule, Integer.valueOf(930));
        Assert.assertEquals((long)options.size(), (long)1L);
        ReplaceAssistantOption assistantOption = (ReplaceAssistantOption)options.get(0);
        Assert.assertEquals((Object)"\tDriver($licence : licence = 1234, $name : name)", (Object)assistantOption.getContent());
    }
}

