/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.rules;

import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.base.ClassTypeResolver;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.ClassToGenericClassConverter;
import org.drools.ide.common.server.util.ClassMethodInspector;
import org.drools.ide.common.server.util.DataEnumLoader;
import org.drools.ide.common.server.util.SuggestionCompletionEngineBuilder;
import org.drools.lang.descr.AnnotationDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.rule.MapBackedClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionCompletionLoader
implements ClassToGenericClassConverter {
    private final SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();
    private final MapBackedClassLoader loader;
    private final List<String> errors = new ArrayList<String>();
    private final ClassTypeResolver resolver;
    private PackageDescr pkgDescr;
    private List<ExternalImportDescrProvider> externalImportDescrProviders = new ArrayList<ExternalImportDescrProvider>();

    public SuggestionCompletionLoader() {
        this(null);
    }

    public SuggestionCompletionLoader(ClassLoader classLoader) {
        this.loader = this.getMapBackedClassLoader(classLoader);
        this.resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)this.loader);
    }

    private MapBackedClassLoader getMapBackedClassLoader(ClassLoader classLoader) {
        MapBackedClassLoader mapBackedClassLoader = new MapBackedClassLoader(this.createClassLoader(classLoader));
        return mapBackedClassLoader;
    }

    private ClassLoader createClassLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List<JarInputStream> jars, List<DSLTokenizedMappingFile> dsls) {
        return this.getSuggestionEngine(header, jars, dsls, Collections.<String>emptyList());
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List<JarInputStream> jars, List<DSLTokenizedMappingFile> dsls, List<String> dataEnums) {
        this.builder.newCompletionEngine();
        if (this.headerNotEmpty(header)) {
            this.processPackageHeader(header, jars);
        }
        this.populateDSLSentences(dsls);
        this.populateDateEnums(dataEnums);
        return this.builder.getInstance();
    }

    private void populateDateEnums(List<String> dataEnums) {
        for (String enumFile : dataEnums) {
            DataEnumLoader enumLoader = new DataEnumLoader(enumFile);
            if (enumLoader.hasErrors()) {
                this.errors.addAll(enumLoader.getErrors());
                continue;
            }
            this.builder.addAllDataEnumsList(enumLoader.getData());
        }
    }

    private boolean headerNotEmpty(String header) {
        return !header.trim().equals("");
    }

    private void processPackageHeader(String header, List jars) {
        DrlParser parser = this.getParser(header);
        this.logErrors(parser);
        this.populateEngineBuilder(jars);
    }

    private void populateEngineBuilder(List jars) {
        if (this.thereWasNoErrorsAndPackageDescrWasCreated()) {
            this.populateModelInfo(jars);
            this.populateDeclaredFactTypes();
            this.populateGlobalInfo(jars);
        }
    }

    private void logErrors(DrlParser parser) {
        if (parser.hasErrors()) {
            for (DroolsError droolsError : parser.getErrors()) {
                this.errors.add(droolsError.getMessage());
            }
        }
    }

    private DrlParser getParser(String header) {
        DrlParser parser = new DrlParser();
        try {
            this.pkgDescr = parser.parse(header);
        }
        catch (DroolsParserException e1) {
            throw new IllegalStateException("Serious error, unable to validate package.");
        }
        return parser;
    }

    private boolean thereWasNoErrorsAndPackageDescrWasCreated() {
        return this.pkgDescr != null;
    }

    private void populateDSLSentences(List<DSLTokenizedMappingFile> dsls) {
        for (DSLTokenizedMappingFile file : dsls) {
            for (DSLMappingEntry entry : file.getMapping().getEntries()) {
                if (entry.getSection() == DSLMappingEntry.CONDITION) {
                    this.builder.addDSLConditionSentence(entry.getMappingKey());
                    continue;
                }
                if (entry.getSection() == DSLMappingEntry.CONSEQUENCE) {
                    this.builder.addDSLActionSentence(entry.getMappingKey());
                    continue;
                }
                if (entry.getSection() == DSLMappingEntry.KEYWORD) {
                    this.builder.addDSLMapping(entry);
                    continue;
                }
                if (entry.getSection() != DSLMappingEntry.ANY) continue;
                this.builder.addDSLConditionSentence(entry.getMappingKey());
                this.builder.addDSLActionSentence(entry.getMappingKey());
            }
        }
    }

    private void populateGlobalInfo(List jars) {
        for (GlobalDescr global : this.pkgDescr.getGlobals()) {
            try {
                String shortTypeName = this.getShortNameOfClass(global.getType());
                Class clazz = this.loadClass(global.getType(), jars);
                if (!this.builder.hasFieldsForType(shortTypeName)) {
                    this.loadClassFields(clazz, shortTypeName);
                    this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
                }
                if (this.implementsCollection(clazz)) {
                    this.builder.addGlobalCollection(global.getIdentifier());
                }
                this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting class for global: " + global.getType() + " error message: " + e.getMessage());
            }
        }
    }

    private boolean implementsCollection(Class<?> clazz) {
        return clazz != null && Collection.class.isAssignableFrom(clazz);
    }

    private void populateModelInfo(List jars) {
        ArrayList<ImportDescr> imports = new ArrayList<ImportDescr>(this.pkgDescr.getImports());
        this.addAnyExternalImports(imports);
        for (ImportDescr importDescr : imports) {
            String className = importDescr.getTarget();
            try {
                this.addImport(className);
                this.addFactType(jars, className);
            }
            catch (WildCardException e) {
                this.errors.add(String.format("Unable to introspect model for wild card imports (%s). Please explicitly import each fact type you require.", className));
            }
        }
    }

    private void populateDeclaredFactTypes() {
        Set<String> declaredTypes = this.getDeclaredTypes(this.pkgDescr);
        HashMap<String, FieldAccessorsAndMutators> accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();
        for (TypeDeclarationDescr typeDeclarationDescr : this.pkgDescr.getTypeDeclarations()) {
            String declaredType = typeDeclarationDescr.getTypeName();
            HashMap<String, Map<String, String>> annotations = new HashMap<String, Map<String, String>>();
            for (String annotationName : typeDeclarationDescr.getAnnotationNames()) {
                AnnotationDescr annotation = typeDeclarationDescr.getAnnotation(annotationName);
                annotations.put(annotationName, annotation.getValues());
            }
            this.builder.addAnnotationsForType(declaredType, annotations);
            if (!this.typeDeclarationDescrHasFields(typeDeclarationDescr)) continue;
            ArrayList<String> fieldNames = new ArrayList<String>();
            this.builder.addFactType(declaredType, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS);
            fieldNames.add("this");
            this.builder.addFieldType(declaredType + ".this", "this", null);
            accessorsAndMutators.put(declaredType + ".this", FieldAccessorsAndMutators.ACCESSOR);
            for (Map.Entry f : typeDeclarationDescr.getFields().entrySet()) {
                String fieldName = (String)f.getKey();
                fieldNames.add(fieldName);
                String factField = declaredType + "." + fieldName;
                accessorsAndMutators.put(factField, FieldAccessorsAndMutators.BOTH);
                String fieldClass = ((TypeFieldDescr)f.getValue()).getPattern().getObjectType();
                if (declaredTypes.contains(fieldClass)) {
                    this.builder.addFieldType(declaredType + "." + fieldName, fieldClass, null);
                    continue;
                }
                try {
                    Class clz = this.resolver.resolveType(fieldClass);
                    this.builder.addFieldType(declaredType + "." + fieldName, this.translateClassToGenericType(clz), clz);
                }
                catch (ClassNotFoundException e) {
                    this.errors.add("Class of field not found: " + fieldClass);
                }
            }
            this.builder.addFieldsForType(declaredType, fieldNames.toArray(new String[fieldNames.size()]));
        }
        this.builder.addFieldAccessorsAndMutatorsForField(accessorsAndMutators);
    }

    private boolean typeDeclarationDescrHasFields(TypeDeclarationDescr typeDeclarationDescr) {
        return typeDeclarationDescr.getFields().size() > 0;
    }

    private Set<String> getDeclaredTypes(PackageDescr pkgDescr) {
        HashSet<String> declaredTypes = new HashSet<String>();
        for (TypeDeclarationDescr typeDeclarationDescr : pkgDescr.getTypeDeclarations()) {
            declaredTypes.add(typeDeclarationDescr.getTypeName());
        }
        return declaredTypes;
    }

    private void addImport(String className) throws WildCardException {
        if (this.isWildCardImport(className)) {
            throw new WildCardException();
        }
        this.resolver.addImport(className);
    }

    private void addFactType(List jars, String className) {
        Class clazz = this.loadClass(className, jars);
        if (clazz != null) {
            try {
                String shortTypeName = this.getShortNameOfClass(clazz.getName());
                this.builder.addFactType(shortTypeName, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS);
                this.loadClassFields(clazz, shortTypeName);
            }
            catch (IOException e) {
                this.errors.add(String.format("Error while inspecting the class: %s. The error was: %s", className, e.getMessage()));
            }
            catch (NoClassDefFoundError e) {
                this.errors.add(String.format("Unable to find the class: %s which is required by: %s. You may need to add more classes to the model.", e.getMessage().replace('/', '.'), className));
            }
        }
    }

    private boolean isWildCardImport(String className) {
        return className.endsWith("*");
    }

    private void addAnyExternalImports(List<ImportDescr> imports) {
        if (this.externalImportDescrProviders != null) {
            for (ExternalImportDescrProvider externalImportDescrProvider : this.externalImportDescrProviders) {
                imports.addAll(externalImportDescrProvider.getImportDescrs());
            }
        }
    }

    private Class loadClass(String className, List jars) {
        Class clazz = null;
        try {
            clazz = this.resolver.resolveType(className);
        }
        catch (ClassFormatError e1) {
            clazz = this.loadClass(className, jars, clazz);
        }
        catch (ClassNotFoundException e1) {
            clazz = this.loadClass(className, jars, clazz);
        }
        return clazz;
    }

    private Class loadClass(String className, List jars, Class clazz) {
        try {
            this.addJars(jars);
            clazz = this.resolver.resolveType(className);
        }
        catch (Exception e) {
            this.errors.add("Class not found: " + className);
        }
        return clazz;
    }

    private void loadClassFields(Class<?> clazz, String shortTypeName) throws IOException {
        if (clazz == null) {
            return;
        }
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        TreeSet<String> fieldsSet = new TreeSet<String>();
        fieldsSet.addAll(inspector.getFieldNames().keySet());
        List<String> fields = this.removeIrrelevantFields(fieldsSet);
        Method[] methods = clazz.getMethods();
        ArrayList<String> modifierStrings = new ArrayList<String>();
        HashMap<String, FieldAccessorsAndMutators> accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();
        fields.add(0, "this");
        accessorsAndMutators.put(shortTypeName + ".this", FieldAccessorsAndMutators.ACCESSOR);
        this.builder.addFieldType(shortTypeName + ".this", "this", clazz);
        this.builder.addFieldsForType(shortTypeName, fields.toArray(new String[fields.size()]));
        for (Method method : methods) {
            String factField;
            modifierStrings.add(method.getName());
            String name = method.getName();
            if (method.getParameterTypes().length > 0) {
                if (name.startsWith("set")) {
                    name = Introspector.decapitalize(name.substring(3));
                }
                if (accessorsAndMutators.get(factField = shortTypeName + "." + name) == FieldAccessorsAndMutators.ACCESSOR) {
                    accessorsAndMutators.put(factField, FieldAccessorsAndMutators.BOTH);
                    continue;
                }
                accessorsAndMutators.put(factField, FieldAccessorsAndMutators.MUTATOR);
                continue;
            }
            if (method.getReturnType().equals("void")) continue;
            if (name.startsWith("get")) {
                name = Introspector.decapitalize(name.substring(3));
            } else if (name.startsWith("is")) {
                name = Introspector.decapitalize(name.substring(2));
            }
            factField = shortTypeName + "." + name;
            if (accessorsAndMutators.get(factField) == FieldAccessorsAndMutators.MUTATOR) {
                accessorsAndMutators.put(factField, FieldAccessorsAndMutators.BOTH);
                continue;
            }
            accessorsAndMutators.put(shortTypeName + "." + name, FieldAccessorsAndMutators.ACCESSOR);
        }
        String[] modifiers = new String[modifierStrings.size()];
        modifierStrings.toArray(modifiers);
        this.builder.addModifiersForType(shortTypeName, modifiers);
        this.builder.addFieldAccessorsAndMutatorsForField(accessorsAndMutators);
        fields.remove("this");
        for (String field : fields) {
            Class type = (Class)inspector.getFieldTypes().get(field);
            String fieldType = this.translateClassToGenericType(type);
            this.builder.addFieldType(shortTypeName + "." + field, fieldType, type);
            Field f = (Field)inspector.getFieldTypesField().get(field);
            this.builder.addFieldTypeField(shortTypeName + "." + field, f);
        }
        ClassMethodInspector methodInspector = new ClassMethodInspector(clazz, this);
        List<MethodInfo> methodInfos = methodInspector.getMethodInfos();
        for (MethodInfo mi : methodInfos) {
            String genericType = mi.getParametricReturnType();
            if (genericType == null) continue;
            this.builder.putParametricFieldType(shortTypeName + "." + mi.getNameWithParameters(), genericType);
        }
        this.builder.getInstance().addMethodInfo(shortTypeName, methodInfos);
    }

    public String getShortNameOfClass(String clazz) {
        return clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    public List<String> removeIrrelevantFields(Collection<String> fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (String field : fields) {
            if (field.equals("class") || field.equals("hashCode") || field.equals("toString")) continue;
            result.add(field);
        }
        return result;
    }

    private void addJars(List<JarInputStream> jars) throws IOException {
        for (JarInputStream jis : jars) {
            JarEntry entry;
            byte[] buf = new byte[1024];
            while ((entry = jis.getNextJarEntry()) != null) {
                int len;
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                this.loader.addResource(entry.getName(), out.toByteArray());
            }
        }
    }

    @Override
    public String translateClassToGenericType(Class<?> type) {
        String fieldType = null;
        if (type != null) {
            if (type.isPrimitive() && type != Boolean.TYPE) {
                fieldType = "Numeric";
            } else if (Number.class.isAssignableFrom(type)) {
                fieldType = "Numeric";
            } else if (String.class.isAssignableFrom(type)) {
                fieldType = "String";
            } else if (Collection.class.isAssignableFrom(type)) {
                fieldType = "Collection";
            } else if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                fieldType = "Boolean";
            } else if (Date.class.isAssignableFrom(type)) {
                fieldType = "Date";
            } else if (Comparable.class.isAssignableFrom(type)) {
                fieldType = "Comparable";
            } else {
                try {
                    Class clazz = this.resolver.resolveType(type.getName());
                    fieldType = clazz.getSimpleName();
                }
                catch (ClassNotFoundException e) {
                    fieldType = "Object";
                }
            }
        }
        return fieldType;
    }

    public void addExternalImportDescrProvider(ExternalImportDescrProvider provider) {
        this.externalImportDescrProviders.add(provider);
    }

    public Set<ImportDescr> getExternalImportDescrs() {
        HashSet<ImportDescr> result = new HashSet<ImportDescr>();
        for (ExternalImportDescrProvider externalImportDescrProvider : this.externalImportDescrProviders) {
            result.addAll(externalImportDescrProvider.getImportDescrs());
        }
        return result;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    class WildCardException
    extends Exception {
        WildCardException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExternalImportDescrProvider {
        public Set<ImportDescr> getImportDescrs();
    }
}

