/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.drools.ClockType;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.AgendaEventListener;
import org.drools.ide.common.client.modeldriven.testing.ActivateRuleFlowGroup;
import org.drools.ide.common.client.modeldriven.testing.CallFieldValue;
import org.drools.ide.common.client.modeldriven.testing.CallMethod;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Expectation;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.RetractFact;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;
import org.drools.ide.common.server.util.ScenarioXMLPersistence;
import org.drools.rule.Package;
import org.drools.testframework.FactFieldValueVerifier;
import org.drools.testframework.TestingEventListener;
import org.drools.time.impl.PseudoClockScheduler;
import org.drools.util.CompositeClassLoader;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioRunner {
    private final Scenario scenario;
    private final Map<String, Object> populatedData = new HashMap<String, Object>();
    private final Map<String, Object> globalData = new HashMap<String, Object>();
    private final Map<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
    private final InternalWorkingMemory workingMemory;
    private final TypeResolver resolver;

    public ScenarioRunner(Scenario scenario, TypeResolver resolver, InternalWorkingMemory wm) throws ClassNotFoundException {
        this.scenario = scenario;
        this.workingMemory = wm;
        this.resolver = resolver;
        this.runScenario();
    }

    public ScenarioRunner(String xml, RuleBase ruleBase) throws ClassNotFoundException {
        this.scenario = ScenarioXMLPersistence.getInstance().unmarshal(xml);
        SessionConfiguration sessionConfiguration = new SessionConfiguration();
        sessionConfiguration.setClockType(ClockType.PSEUDO_CLOCK);
        this.workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession(sessionConfiguration, null);
        CompositeClassLoader classLoader = ((InternalRuleBase)ruleBase).getRootClassLoader();
        HashSet<String> imports = this.getImports(ruleBase.getPackages()[0]);
        this.resolver = new ClassTypeResolver(imports, (ClassLoader)classLoader);
        this.runScenario();
    }

    public HashSet<String> getImports(Package aPackage) {
        HashSet<String> imports = new HashSet<String>();
        imports.add(aPackage.getName() + ".*");
        imports.addAll(aPackage.getImports().keySet());
        return imports;
    }

    private void runScenario() throws ClassNotFoundException {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        this.scenario.setLastRunResult(new Date());
        HashSet<String> ruleList = new HashSet<String>();
        ruleList.addAll(this.scenario.getRules());
        TestingEventListener listener = null;
        ArrayList<Populate> toPopulate = new ArrayList<Populate>();
        for (final FactData fact : this.scenario.getGlobals()) {
            final Object factObject = MVEL.eval((String)("new " + this.getTypeName(this.resolver, fact) + "()"));
            toPopulate.add(new Populate(){

                public void go() {
                    ScenarioRunner.this.populateFields(fact, factObject);
                }
            });
            this.globalData.put(fact.getName(), factObject);
            this.workingMemory.setGlobal(fact.getName(), factObject);
        }
        this.doPopulate(toPopulate);
        for (Fixture fixture : this.scenario.getFixtures()) {
            if (fixture instanceof FactData) {
                Object factObject;
                final FactData fact = (FactData)fixture;
                Object object = factObject = fact.isModify() ? this.populatedData.get(fact.getName()) : MVEL.eval((String)("new " + this.getTypeName(this.resolver, fact) + "()"));
                if (fact.isModify()) {
                    if (!this.factHandles.containsKey(fact.getName())) {
                        throw new IllegalArgumentException("Was not a previously inserted fact. [" + fact.getName() + "]");
                    }
                    toPopulate.add(new Populate(){

                        public void go() {
                            ScenarioRunner.this.populateFields(fact, factObject);
                            ScenarioRunner.this.workingMemory.update((org.drools.runtime.rule.FactHandle)ScenarioRunner.this.factHandles.get(fact.getName()), factObject);
                        }
                    });
                    continue;
                }
                this.populatedData.put(fact.getName(), factObject);
                toPopulate.add(new Populate(){

                    public void go() {
                        ScenarioRunner.this.populateFields(fact, factObject);
                        ScenarioRunner.this.factHandles.put(fact.getName(), ScenarioRunner.this.workingMemory.insert(factObject));
                    }
                });
                continue;
            }
            if (fixture instanceof RetractFact) {
                RetractFact retractFact = (RetractFact)fixture;
                this.workingMemory.retract((org.drools.runtime.rule.FactHandle)this.factHandles.get(retractFact.getName()));
                this.populatedData.remove(retractFact.getName());
                continue;
            }
            if (fixture instanceof CallMethod) {
                CallMethod aCall = (CallMethod)fixture;
                Object targetInstance = this.populatedData.get(aCall.getVariable());
                this.executeMethodOnObject(aCall, targetInstance);
                continue;
            }
            if (fixture instanceof ActivateRuleFlowGroup) {
                String ruleFlowGroupName = ((ActivateRuleFlowGroup)fixture).getName();
                this.workingMemory.getAgenda().getRuleFlowGroup(ruleFlowGroupName).setAutoDeactivate(false);
                this.workingMemory.getAgenda().activateRuleFlowGroup(ruleFlowGroupName);
                continue;
            }
            if (fixture instanceof ExecutionTrace) {
                this.doPopulate(toPopulate);
                ExecutionTrace executionTrace = (ExecutionTrace)fixture;
                if (listener != null) {
                    this.workingMemory.removeEventListener(listener);
                }
                listener = new TestingEventListener();
                this.workingMemory.addEventListener((AgendaEventListener)listener);
                this.applyTimeMachine(this.workingMemory, executionTrace);
                long time = System.currentTimeMillis();
                this.workingMemory.fireAllRules(listener.getAgendaFilter(ruleList, this.scenario.isInclusive()), this.scenario.getMaxRuleFirings());
                executionTrace.setExecutionTimeResult(System.currentTimeMillis() - time);
                executionTrace.setNumberOfRulesFired(listener.totalFires);
                executionTrace.setRulesFired(listener.getRulesFiredSummary());
                continue;
            }
            if (fixture instanceof Expectation) {
                this.doPopulate(toPopulate);
                Expectation assertion = (Expectation)fixture;
                if (assertion instanceof VerifyFact) {
                    this.verify((VerifyFact)assertion);
                    continue;
                }
                if (!(assertion instanceof VerifyRuleFired)) continue;
                this.verify((VerifyRuleFired)assertion, listener.firingCounts != null ? listener.firingCounts : new HashMap());
                continue;
            }
            throw new IllegalArgumentException("Not sure what to do with " + fixture);
        }
        this.doPopulate(toPopulate);
    }

    private void doPopulate(List<Populate> toPopulate) {
        for (Populate p : toPopulate) {
            p.go();
        }
        toPopulate.clear();
    }

    private String getTypeName(TypeResolver resolver, FactData fact) throws ClassNotFoundException {
        String fullName = resolver.getFullTypeName(fact.getType());
        if (fullName.equals("java.util.List") || fullName.equals("java.util.Collection")) {
            return "java.util.ArrayList";
        }
        return fullName;
    }

    private void applyTimeMachine(InternalWorkingMemory wm, ExecutionTrace executionTrace) {
        long targetTime = 0L;
        targetTime = executionTrace.getScenarioSimulatedDate() != null ? executionTrace.getScenarioSimulatedDate().getTime() : new Date().getTime();
        long currentTime = wm.getSessionClock().getCurrentTime();
        ((PseudoClockScheduler)wm.getSessionClock()).advanceTime(targetTime - currentTime, TimeUnit.MILLISECONDS);
    }

    void verify(VerifyRuleFired assertion, Map<String, Integer> firingCounts) {
        assertion.setActualResult(firingCounts.containsKey(assertion.getRuleName()) ? firingCounts.get(assertion.getRuleName()) : 0);
        if (assertion.getExpectedFire() != null) {
            if (assertion.getExpectedFire().booleanValue()) {
                if (assertion.getActualResult() > 0) {
                    assertion.setSuccessResult(true);
                    assertion.setExplanation("Rule [" + assertion.getRuleName() + "] was actived " + assertion.getActualResult() + " times.");
                } else {
                    assertion.setSuccessResult(false);
                    assertion.setExplanation("Rule [" + assertion.getRuleName() + "] was not activated. Expected it to be activated.");
                }
            } else if (assertion.getActualResult() == 0) {
                assertion.setSuccessResult(true);
                assertion.setExplanation("Rule [" + assertion.getRuleName() + "] was not activated.");
            } else {
                assertion.setSuccessResult(false);
                assertion.setExplanation("Rule [" + assertion.getRuleName() + "] was activated " + assertion.getActualResult() + " times, but expected none.");
            }
        }
        if (assertion.getExpectedCount() != null) {
            if (assertion.getActualResult().equals(assertion.getExpectedCount())) {
                assertion.setSuccessResult(true);
                assertion.setExplanation("Rule [" + assertion.getRuleName() + "] activated " + assertion.getActualResult() + " times.");
            } else {
                assertion.setSuccessResult(false);
                assertion.setExplanation("Rule [" + assertion.getRuleName() + "] activated " + assertion.getActualResult() + " times. Expected " + assertion.getExpectedCount() + " times.");
            }
        }
    }

    void verify(VerifyFact value) {
        if (!value.anonymous) {
            Object factObject = this.populatedData.get(value.getName());
            if (factObject == null) {
                factObject = this.globalData.get(value.getName());
            }
            FactFieldValueVerifier fieldVerifier = new FactFieldValueVerifier(this.populatedData, value.getName(), factObject, this.resolver);
            fieldVerifier.checkFields(value.getFieldValues());
        } else {
            Iterator obs = this.workingMemory.iterateObjects();
            while (obs.hasNext()) {
                Object factObject = obs.next();
                if (!factObject.getClass().getSimpleName().equals(value.getName())) continue;
                FactFieldValueVerifier fieldVerifier = new FactFieldValueVerifier(this.populatedData, value.getName(), factObject, this.resolver);
                fieldVerifier.checkFields(value.getFieldValues());
                if (!value.wasSuccessful()) continue;
                return;
            }
            for (VerifyField vfl : value.getFieldValues()) {
                if (vfl.getSuccessResult() != null) continue;
                vfl.setSuccessResult(Boolean.FALSE);
                vfl.setActualResult("No match");
            }
        }
    }

    Object populateFields(FactData fact, Object factObject) {
        for (int i = 0; i < fact.getFieldData().size(); ++i) {
            FieldData field = fact.getFieldData().get(i);
            Object val = null;
            if (field.getValue() == null || field.getValue().equals("")) continue;
            if (field.getValue().startsWith("=")) {
                val = MVEL.eval((String)field.getValue().substring(1), this.populatedData);
            } else if (field.getNature() == 4L) {
                try {
                    String classNameOfEnum = field.getValue().substring(0, field.getValue().indexOf("."));
                    String valueOfEnum = field.getValue().substring(field.getValue().indexOf(".") + 1);
                    String fullName = this.resolver.getFullTypeName(classNameOfEnum);
                    val = MVEL.eval((String)(fullName + "." + valueOfEnum));
                }
                catch (ClassNotFoundException e) {}
            } else {
                val = field.getValue();
            }
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.putAll(this.populatedData);
            vars.put("__val__", val);
            vars.put("__fact__", factObject);
            MVEL.eval((String)("__fact__." + field.getName() + " = __val__"), vars);
        }
        return factObject;
    }

    Object executeMethodOnObject(CallMethod fact, Object factObject) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("__fact__", factObject);
        String methodName = "__fact__." + fact.getMethodName() + "(";
        for (int i = 0; i < fact.getCallFieldValues().length; ++i) {
            CallFieldValue field = fact.getCallFieldValues()[i];
            if (field.value == null || field.value.equals("")) continue;
            Object val = field.value.startsWith("=") ? this.populatedData.get(field.value.substring(1)) : field.value;
            vars.put("__val" + i + "__", val);
            methodName = methodName + "__val" + i + "__";
            if (i >= fact.getCallFieldValues().length - 1) continue;
            methodName = methodName + ",";
        }
        methodName = methodName + ")";
        MVEL.eval((String)methodName, vars);
        return factObject;
    }

    public boolean wasSuccess() {
        return this.scenario.wasSuccessful();
    }

    Scenario getScenario() {
        return this.scenario;
    }

    Map<String, Object> getPopulatedData() {
        return this.populatedData;
    }

    Map<String, Object> getGlobalData() {
        return this.globalData;
    }

    Map<String, FactHandle> getFactHandles() {
        return this.factHandles;
    }

    InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    TypeResolver getResolver() {
        return this.resolver;
    }

    static interface Populate {
        public void go();
    }
}

