/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.ExpressionField;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPart;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.ExpressionUnboundFact;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRLPersistence;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BRDRLPersistenceTest {
    private BRLPersistence brlPersistence;

    @Before
    public void setUp() throws Exception {
        this.brlPersistence = BRDRLPersistence.getInstance();
    }

    @Test
    public void testGenerateEmptyDRL() {
        String expected = "rule \"null\"\n\tdialect \"mvel\"\n\twhen\n\tthen\nend\n";
        String drl = this.brlPersistence.marshal(new RuleModel());
        Assert.assertNotNull((Object)drl);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testFreeForm() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        m.lhs = new IPattern[1];
        m.rhs = new IAction[1];
        FreeFormLine fl = new FreeFormLine();
        fl.text = "Person()";
        m.lhs[0] = fl;
        FreeFormLine fr = new FreeFormLine();
        fr.text = "fun()";
        m.rhs[0] = fr;
        String drl = this.brlPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("Person()") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("fun()") > drl.indexOf("Person()") ? 1 : 0) != 0);
    }

    @Test
    public void testBasics() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testInsertLogical() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsertLogical( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertLogicalFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testAttr() {
        RuleModel m = new RuleModel();
        m.attributes = new RuleAttribute[1];
        m.attributes[0] = new RuleAttribute("enabled", "true");
        String drl = this.brlPersistence.marshal(m);
        Assert.assertTrue((drl.indexOf("enabled true") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEnumNoType() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == \"CheeseType.CHEDDAR\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("CheeseType.CHEDDAR");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeString() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == \"CHEDDAR\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("CHEDDAR");
        con.setFieldType("String");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeNumeric() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( age == 100 )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("==");
        con.setValue("100");
        con.setFieldType("Numeric");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeBoolean() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( smelly == true )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("smelly");
        con.setOperator("==");
        con.setValue("true");
        con.setFieldType("Boolean");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeDate() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( dateMade == \"31-Jan-2010\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("dateMade");
        con.setOperator("==");
        con.setValue("31-Jan-2010");
        con.setFieldType("Date");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeComparable() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == Cheese.CHEDDAR )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("Cheese.CHEDDAR");
        con.setFieldType("Comparable");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testMoreComplexRendering() {
        RuleModel m = this.getComplexModel();
        String expected = "rule \"Complex Rule\"\n\tno-loop true\n\tsalience -10\n\tagenda-group \"aGroup\"\n\tdialect \"mvel\"\n\twhen\n\t\t>p1 : Person( f1 : age < 42 )\n\t\t>not (Cancel( )) \n\tthen\n\t\t>p1.setStatus( \"rejected\" );\n\t\t>update( p1 );\n\t\t>retract( p1 );\n\t\tSend an email to administrator\nend\n";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testFieldBindingWithNoConstraints() {
        RuleModel m = this.getModelWithNoConstraints();
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( f1 : age)") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void textIsNullOperator() {
        RuleModel m = new RuleModel();
        m.name = "IsNullOperator";
        FactPattern pat = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("== null");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( age == null )") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void textIsNotNullOperator() {
        RuleModel m = new RuleModel();
        m.name = "IsNotNullOperator";
        FactPattern pat = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("!= null");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( age != null )") != -1 ? 1 : 0) != 0);
    }

    private RuleModel getModelWithNoConstraints() {
        RuleModel m = new RuleModel();
        m.name = "Complex Rule";
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        return m;
    }

    private RuleModel getComplexModel() {
        RuleModel m = new RuleModel();
        m.name = "Complex Rule";
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addAttribute(new RuleAttribute("salience", "-10"));
        m.addAttribute(new RuleAttribute("agenda-group", "aGroup"));
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        con.setOperator("<");
        con.setValue("42");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        CompositeFactPattern comp = new CompositeFactPattern("not");
        comp.addFactPattern((IFactPattern)new FactPattern("Cancel"));
        m.addLhsItem((IPattern)comp);
        ActionUpdateField set = new ActionUpdateField();
        set.variable = "p1";
        set.addFieldValue(new ActionFieldValue("status", "rejected", "String"));
        m.addRhsItem((IAction)set);
        ActionRetractFact ret = new ActionRetractFact("p1");
        m.addRhsItem((IAction)ret);
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("Send an email to {administrator}");
        m.addRhsItem((IAction)sen);
        return m;
    }

    @Test
    public void testOrComposite() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sf2 = new SingleFieldConstraint("age");
        sf2.setOperator("==");
        sf2.setValue("43");
        p2.addConstraint((FieldConstraint)sf2);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("( Person( age == 42 ) or Person( age == 43 ) )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExistsMultiPatterns() throws Exception {
        String result = this.getCompositeFOL("exists");
        Assert.assertTrue((result.indexOf("exists (Person( age == 42 ) and Person( age == 43 ))") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotMultiPatterns() throws Exception {
        String result = this.getCompositeFOL("not");
        Assert.assertTrue((result.indexOf("not (Person( age == 42 ) and Person( age == 43 ))") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSingleExists() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern("exists");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("exists (Person( age == 42 )) ") > 0 ? 1 : 0) != 0);
    }

    private String getCompositeFOL(String type) {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern(type);
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sf2 = new SingleFieldConstraint("age");
        sf2.setOperator("==");
        sf2.setValue("43");
        p2.addConstraint((FieldConstraint)sf2);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        return result;
    }

    @Test
    public void testCompositeConstraints() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        FactPattern p1 = new FactPattern("Person");
        p1.setBoundName("p1");
        m.addLhsItem((IPattern)p1);
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "||";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("goo");
        X.setFieldType("String");
        X.setConstraintValueType(1);
        X.setValue("foo");
        X.setOperator("==");
        X.connectives = new ConnectiveConstraint[1];
        X.connectives[0] = new ConnectiveConstraint();
        X.connectives[0].setConstraintValueType(1);
        X.connectives[0].setFieldType("String");
        X.connectives[0].setOperator("|| ==");
        X.connectives[0].setValue("bar");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("goo2");
        Y.setFieldType("String");
        Y.setConstraintValueType(1);
        Y.setValue("foo");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.compositeJunctionType = "&&";
        SingleFieldConstraint Q1 = new SingleFieldConstraint();
        Q1.setFieldType("String");
        Q1.setFieldName("goo");
        Q1.setOperator("==");
        Q1.setValue("whee");
        Q1.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q1);
        SingleFieldConstraint Q2 = new SingleFieldConstraint();
        Q2.setFieldType("String");
        Q2.setFieldName("gabba");
        Q2.setOperator("==");
        Q2.setValue("whee");
        Q2.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q2);
        comp.addConstraint((FieldConstraint)comp2);
        SingleFieldConstraint Z = new SingleFieldConstraint();
        Z.setFieldName("goo3");
        Z.setConstraintValueType(1);
        Z.setFieldType("String");
        Z.setValue("foo");
        Z.setOperator("==");
        p.addConstraint((FieldConstraint)Z);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"with composite\"  \tdialect \"mvel\"\n when p1 : Person( ) Goober( goo == \"foo\"  || == \"bar\" || goo2 == \"foo\" || ( goo == \"whee\" && gabba == \"whee\" ), goo3 == \"foo\" ) then insert( new Whee() );end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testFieldsDeclaredButNoConstraints() {
        RuleModel m = new RuleModel();
        m.name = "boo";
        FactPattern p = new FactPattern("Person");
        p.addConstraint((FieldConstraint)new SingleFieldConstraint("field1"));
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"boo\" \tdialect \"mvel\"\n when Person() then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
        SingleFieldConstraint con = (SingleFieldConstraint)p.constraintList.constraints[0];
        con.setFieldBinding("q");
        actual = BRDRLPersistence.getInstance().marshal(m);
        expected = "rule \"boo\" dialect \"mvel\" when Person(q : field1) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testLiteralStrings() {
        RuleModel m = new RuleModel();
        m.name = "test literal strings";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal strings\"\tdialect \"mvel\"\n when      Person(field1 == \"goo\", field2 == variableHere) then end", result);
    }

    @Test
    public void testLHSExpressionString1() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsString1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionText("field1"));
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsString1\"\tdialect \"mvel\"\n when      Person( field1 == \"goo\" ) then end", result);
    }

    @Test
    public void testLHSExpressionString2() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsString2";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.String", "String"));
        con.setOperator("==");
        con.setValue("Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsString2\"\tdialect \"mvel\"\n when      Person( field1 == \"Cheddar\" ) then end", result);
    }

    @Test
    public void testLHSExpressionJavaEnum() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsJavaEnum";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "CHEESE", "Comparable"));
        con.setOperator("==");
        con.setValue("CHEESE.Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsJavaEnum\"\tdialect \"mvel\"\n when      Person( field1 == CHEESE.Cheddar ) then end", result);
    }

    @Test
    public void testLHSExpressionNumber() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNumber";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.Integer", "Numeric"));
        con.setOperator("==");
        con.setValue("55");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNumber\"\tdialect \"mvel\"\n when      Person( field1 == 55 ) then end", result);
    }

    @Test
    public void testLHSExpressionDate() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsDate";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.util.Date", "Date"));
        con.setOperator("==");
        con.setValue("27-Jun-2011");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsDate\"\tdialect \"mvel\"\n when      Person( field1 == \"27-Jun-2011\" ) then end", result);
    }

    @Test
    public void testLHSExpressionBoolean() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsBoolean";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.Boolean", "Boolean"));
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsBoolean\"\tdialect \"mvel\"\n when      Person( field1 == true ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedString() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedString";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("name", "java.lang.String", "String"));
        con.setOperator("==");
        con.setValue("Cheedar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedString\"\tdialect \"mvel\"\n when      Person( favouriteCheese.name == \"Cheedar\" ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedNumber() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedNumber";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("age", "java.lang.Integer", "Numeric"));
        con.setOperator("==");
        con.setValue("55");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedNumber\"\tdialect \"mvel\"\n when      Person( favouriteCheese.age == 55 ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedDate() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedDate";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("dateBrought", "java.util.Date", "Date"));
        con.setOperator("==");
        con.setValue("27-Jun-2011");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedDate\"\tdialect \"mvel\"\n when      Person( favouriteCheese.dateBrought == \"27-Jun-2011\" ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedJavaEnum() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedJavaEnum";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("genericName", "CHEESE", "Comparable"));
        con.setOperator("==");
        con.setValue("CHEESE.Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedJavaEnum\"\tdialect \"mvel\"\n when      Person( favouriteCheese.genericName == CHEESE.Cheddar ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedBoolean() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedBoolean";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("smelly", "java.lang.Boolean", "Boolean"));
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedBoolean\"\tdialect \"mvel\"\n when      Person( favouriteCheese.smelly == true ) then end", result);
    }

    @Test
    public void testLiteralNumerics() {
        RuleModel m = new RuleModel();
        m.name = "test literal numerics";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Numeric");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal numerics\"\tdialect \"mvel\"\n when      Person(field1 == 44, field2 == variableHere) then end", result);
    }

    @Test
    public void testLiteralBooleans() {
        RuleModel m = new RuleModel();
        m.name = "test literal booleans";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Boolean");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal booleans\"\tdialect \"mvel\"\n when      Person(field1 == true, field2 == variableHere) then end", result);
    }

    @Test
    public void testLiteralDates() {
        RuleModel m = new RuleModel();
        m.name = "test literal dates";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Date");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("31-Jan-2010");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal dates\"\tdialect \"mvel\"\n when      Person(field1 == \"31-Jan-2010\", field2 == variableHere) then end", result);
    }

    @Test
    public void testLiteralNoType() {
        RuleModel m = new RuleModel();
        m.name = "test literal no type";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("bananna");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal no type\"\tdialect \"mvel\"\n when      Person(field1 == \"bananna\", field2 == variableHere) then end", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateInsertAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionInsertFact ai = new ActionInsertFact("Birthday");
            ai.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)ai);
            String result = BRDRLPersistence.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("fact0.setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateModifyAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionUpdateField am = new ActionUpdateField("$p");
            am.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)am);
            String result = BRDRLPersistence.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("update( $p );") != -1 ? 1 : 0) != 0);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateUpdateAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionSetField au = new ActionSetField("$p");
            au.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)au);
            String result = BRDRLPersistence.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("update( $p );") == -1 ? 1 : 0) != 0);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    @Test
    public void testSubConstraints() {
        RuleModel m = new RuleModel();
        m.name = "test sub constraints";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        con2.setParent((FieldConstraint)con);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test sub constraints\"\tdialect \"mvel\"\n when      Person(field1.field2 == variableHere) then end", result);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    @Test
    public void testReturnValueConstraint() {
        RuleModel m = new RuleModel();
        m.name = "yeah";
        FactPattern p = new FactPattern("Goober");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(3);
        con.setValue("someFunc(x)");
        con.setOperator("==");
        con.setFieldName("goo");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"yeah\" \tdialect \"mvel\"\n when Goober( goo == ( someFunc(x) ) ) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testPredicateConstraint() {
        RuleModel m = new RuleModel();
        m.name = "yeah";
        FactPattern p = new FactPattern("Goober");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(5);
        con.setValue("field soundslike 'poo'");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"yeah\" \tdialect \"mvel\"\n when Goober( eval( field soundslike 'poo' ) ) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testConnective() {
        RuleModel m = new RuleModel();
        m.name = "test literal strings";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("blah");
        con.connectives = new ConnectiveConstraint[1];
        con.connectives[0] = connective;
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"test literal strings\" \tdialect \"mvel\"\n when Person( field1 == goo  || == \"blah\" ) then end";
        this.assertEqualsIgnoreWhitespace(expected, result);
    }

    @Test
    public void testInvalidComposite() throws Exception {
        RuleModel m = new RuleModel();
        CompositeFactPattern com = new CompositeFactPattern("not");
        m.addLhsItem((IPattern)com);
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertNotNull((Object)s);
        m.addLhsItem((IPattern)new CompositeFactPattern("or"));
        m.addLhsItem((IPattern)new CompositeFactPattern("exists"));
        s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void testAssertWithDSL() throws Exception {
        RuleModel m = new RuleModel();
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("I CAN HAS DSL");
        m.addRhsItem((IAction)sen);
        ActionInsertFact ins = new ActionInsertFact("Shizzle");
        ActionFieldValue val = new ActionFieldValue("goo", "42", "Numeric");
        ins.fieldValues = new ActionFieldValue[1];
        ins.fieldValues[0] = val;
        m.addRhsItem((IAction)ins);
        ActionInsertLogicalFact insL = new ActionInsertLogicalFact("Shizzle");
        ActionFieldValue valL = new ActionFieldValue("goo", "42", "Numeric");
        insL.fieldValues = new ActionFieldValue[1];
        insL.fieldValues[0] = valL;
        m.addRhsItem((IAction)insL);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf(">insert") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf(">insertLogical") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultMVEL() {
        RuleModel m = new RuleModel();
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("mvel") > -1 ? 1 : 0) != 0);
        m.addAttribute(new RuleAttribute("dialect", "goober"));
        s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertFalse((s.indexOf("mvel") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("goober") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLockOnActive() {
        RuleModel m = new RuleModel();
        m.addAttribute(new RuleAttribute("lock-on-active", "true"));
        m.addAttribute(new RuleAttribute("auto-focus", "true"));
        m.addAttribute(new RuleAttribute("duration", "42"));
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("lock-on-active true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("auto-focus true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("duration 42") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddGlobal() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsert( new Report() );\n\t\tresults.add(f);\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        ActionGlobalCollectionAdd add = new ActionGlobalCollectionAdd();
        add.globalName = "results";
        add.factName = "f";
        m.addRhsItem((IAction)add);
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }
}

