/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.dt52;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DescriptionCol52;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidedDecisionTable52
implements PortableObject {
    private static final long serialVersionUID = 510L;
    public static final int INTERNAL_ELEMENTS = 2;
    public static final String SALIENCE_ATTR = "salience";
    public static final String ENABLED_ATTR = "enabled";
    public static final String DATE_EFFECTIVE_ATTR = "date-effective";
    public static final String DATE_EXPIRES_ATTR = "date-expires";
    public static final String NO_LOOP_ATTR = "no-loop";
    public static final String AGENDA_GROUP_ATTR = "agenda-group";
    public static final String ACTIVATION_GROUP_ATTR = "activation-group";
    public static final String DURATION_ATTR = "duration";
    public static final String AUTO_FOCUS_ATTR = "auto-focus";
    public static final String LOCK_ON_ACTIVE_ATTR = "lock-on-active";
    public static final String RULEFLOW_GROUP_ATTR = "ruleflow-group";
    public static final String DIALECT_ATTR = "dialect";
    public static final String NEGATE_RULE_ATTR = "negate";
    private String tableName;
    private String parentName;
    private RowNumberCol52 rowNumberCol = new RowNumberCol52();
    private DescriptionCol52 descriptionCol = new DescriptionCol52();
    private List<MetadataCol52> metadataCols = new ArrayList<MetadataCol52>();
    private List<AttributeCol52> attributeCols = new ArrayList<AttributeCol52>();
    private List<Pattern52> conditionPatterns = new ArrayList<Pattern52>();
    private List<ActionCol52> actionCols = new ArrayList<ActionCol52>();
    private List<List<DTCellValue52>> data = new ArrayList<List<DTCellValue52>>();

    public List<ActionCol52> getActionCols() {
        return this.actionCols;
    }

    public List<AttributeCol52> getAttributeCols() {
        return this.attributeCols;
    }

    public List<Pattern52> getConditionPatterns() {
        return this.conditionPatterns;
    }

    public Pattern52 getConditionPattern(String boundName) {
        for (Pattern52 p : this.conditionPatterns) {
            if (!p.getBoundName().equals(boundName)) continue;
            return p;
        }
        return null;
    }

    public Pattern52 getPattern(ConditionCol52 col) {
        for (Pattern52 p : this.conditionPatterns) {
            if (!p.getConditions().contains(col)) continue;
            return p;
        }
        return new Pattern52();
    }

    public long getConditionsCount() {
        long size = 0L;
        for (Pattern52 p : this.conditionPatterns) {
            size += (long)p.getConditions().size();
        }
        return size;
    }

    public List<List<DTCellValue52>> getData() {
        return this.data;
    }

    public List<DTColumnConfig52> getAllColumns() {
        ArrayList<DTColumnConfig52> columns = new ArrayList<DTColumnConfig52>();
        columns.add(this.rowNumberCol);
        columns.add(this.descriptionCol);
        columns.addAll(this.metadataCols);
        columns.addAll(this.attributeCols);
        for (Pattern52 p : this.conditionPatterns) {
            for (ConditionCol52 c : p.getConditions()) {
                columns.add(c);
            }
        }
        columns.addAll(this.actionCols);
        return columns;
    }

    public DescriptionCol52 getDescriptionCol() {
        if (this.descriptionCol == null) {
            this.descriptionCol = new DescriptionCol52();
        }
        return this.descriptionCol;
    }

    public List<MetadataCol52> getMetadataCols() {
        if (null == this.metadataCols) {
            this.metadataCols = new ArrayList<MetadataCol52>();
        }
        return this.metadataCols;
    }

    public String getParentName() {
        return this.parentName;
    }

    public RowNumberCol52 getRowNumberCol() {
        if (this.rowNumberCol == null) {
            this.rowNumberCol = new RowNumberCol52();
        }
        return this.rowNumberCol;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getType(DTColumnConfig52 col, SuggestionCompletionEngine sce) {
        if (col instanceof RowNumberCol52) {
            return this.getType((RowNumberCol52)col, sce);
        }
        if (col instanceof DescriptionCol52) {
            return this.getType((DescriptionCol52)col, sce);
        }
        if (col instanceof AttributeCol52) {
            return this.getType((AttributeCol52)col, sce);
        }
        if (col instanceof ConditionCol52) {
            return this.getType((ConditionCol52)col, sce);
        }
        if (col instanceof ActionSetFieldCol52) {
            return this.getType((ActionSetFieldCol52)col, sce);
        }
        if (col instanceof ActionInsertFactCol52) {
            return this.getType((ActionInsertFactCol52)col, sce);
        }
        return null;
    }

    private String getType(RowNumberCol52 col, SuggestionCompletionEngine sce) {
        String type = "Numeric";
        return type;
    }

    private String getType(DescriptionCol52 col, SuggestionCompletionEngine sce) {
        String type = "String";
        return type;
    }

    private String getType(AttributeCol52 col, SuggestionCompletionEngine sce) {
        String type = null;
        String attrName = col.getAttribute();
        if (attrName.equals(SALIENCE_ATTR)) {
            type = "Numeric";
        } else if (attrName.equals(ENABLED_ATTR)) {
            type = "Boolean";
        } else if (attrName.equals(NO_LOOP_ATTR)) {
            type = "Boolean";
        } else if (attrName.equals(DURATION_ATTR)) {
            type = "Numeric";
        } else if (attrName.equals(AUTO_FOCUS_ATTR)) {
            type = "Boolean";
        } else if (attrName.equals(LOCK_ON_ACTIVE_ATTR)) {
            type = "Boolean";
        } else if (attrName.equals(DATE_EFFECTIVE_ATTR)) {
            type = "Date";
        } else if (attrName.equals(DATE_EXPIRES_ATTR)) {
            type = "Date";
        } else if (attrName.equals(DIALECT_ATTR)) {
            type = "String";
        }
        return type;
    }

    private String getType(ConditionCol52 col, SuggestionCompletionEngine sce) {
        Pattern52 pattern = this.getPattern(col);
        String type = sce.getFieldType(pattern.getFactType(), col.getFactField());
        type = this.assertDataType(col, sce, type) ? type : null;
        return type;
    }

    private String getType(ActionSetFieldCol52 col, SuggestionCompletionEngine sce) {
        String type = sce.getFieldType(this.getBoundFactType(col.getBoundName()), col.getFactField());
        type = this.assertDataType(col, sce, type) ? type : null;
        return type;
    }

    private String getType(ActionInsertFactCol52 col, SuggestionCompletionEngine sce) {
        String type = sce.getFieldType(col.getFactType(), col.getFactField());
        type = this.assertDataType(col, sce, type) ? type : null;
        return type;
    }

    public String[] getValueList(DTColumnConfig52 col, SuggestionCompletionEngine sce) {
        if (col instanceof AttributeCol52) {
            return this.getValueList((AttributeCol52)col, sce);
        }
        if (col instanceof ConditionCol52) {
            return this.getValueList((ConditionCol52)col, sce);
        }
        if (col instanceof ActionSetFieldCol52) {
            return this.getValueList((ActionSetFieldCol52)col, sce);
        }
        if (col instanceof ActionInsertFactCol52) {
            return this.getValueList((ActionInsertFactCol52)col, sce);
        }
        return new String[0];
    }

    private String[] getValueList(AttributeCol52 col, SuggestionCompletionEngine sce) {
        if (NO_LOOP_ATTR.equals(col.getAttribute()) || ENABLED_ATTR.equals(col.getAttribute())) {
            return new String[]{"true", "false"};
        }
        return new String[0];
    }

    private String[] getValueList(ConditionCol52 col, SuggestionCompletionEngine sce) {
        Pattern52 pattern = this.getPattern(col);
        if (col.getConstraintValueType() == 3) {
            return new String[0];
        }
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        String[] r = sce.getEnumValues(pattern.getFactType(), col.getFactField());
        return r != null ? r : new String[]{};
    }

    private String[] getValueList(ActionSetFieldCol52 col, SuggestionCompletionEngine sce) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        String[] r = sce.getEnumValues(this.getBoundFactType(col.getBoundName()), col.getFactField());
        return r != null ? r : new String[]{};
    }

    private String[] getValueList(ActionInsertFactCol52 col, SuggestionCompletionEngine sce) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return col.getValueList().split(",");
        }
        String[] r = sce.getEnumValues(col.getFactType(), col.getFactField());
        return r != null ? r : new String[]{};
    }

    public boolean isConstraintValid(DTColumnConfig52 col, SuggestionCompletionEngine sce) {
        if (col instanceof RowNumberCol52) {
            return true;
        }
        if (col instanceof DescriptionCol52) {
            return true;
        }
        if (col instanceof MetadataCol52) {
            return true;
        }
        if (col instanceof AttributeCol52) {
            return true;
        }
        if (col instanceof ConditionCol52) {
            ConditionCol52 c = (ConditionCol52)col;
            if (c.getConstraintValueType() == 1) {
                if (c.getFactField() == null || c.getFactField().equals("")) {
                    return false;
                }
                return c.getOperator() != null && !c.getOperator().equals("");
            }
            return true;
        }
        return col instanceof ActionCol52;
    }

    public void setData(List<List<DTCellValue52>> data) {
        this.data = data;
    }

    public void setRowNumberCol(RowNumberCol52 rowNumberCol) {
        this.rowNumberCol = rowNumberCol;
    }

    public void setDescriptionCol(DescriptionCol52 descriptionCol) {
        this.descriptionCol = descriptionCol;
    }

    public void setMetadataCols(List<MetadataCol52> metadataCols) {
        this.metadataCols = metadataCols;
    }

    public void setAttributeCols(List<AttributeCol52> attributeCols) {
        this.attributeCols = attributeCols;
    }

    public void setConditionPatterns(List<Pattern52> conditionPatterns) {
        this.conditionPatterns = conditionPatterns;
    }

    public void setActionCols(List<ActionCol52> actionCols) {
        this.actionCols = actionCols;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private String getBoundFactType(String boundName) {
        for (Pattern52 p : this.conditionPatterns) {
            if (!p.getBoundName().equals(boundName)) continue;
            return p.getFactType();
        }
        return null;
    }

    private boolean assertDataType(ConditionCol52 col, SuggestionCompletionEngine sce, String dataType) {
        Pattern52 pattern = this.getPattern(col);
        if (col.getConstraintValueType() == 1) {
            if (col.getOperator() == null || "".equals(col.getOperator())) {
                return false;
            }
            String ft = sce.getFieldType(pattern.getFactType(), col.getFactField());
            if (ft != null && ft.equals(dataType)) {
                return true;
            }
        }
        return false;
    }

    private boolean assertDataType(ActionSetFieldCol52 col, SuggestionCompletionEngine sce, String dataType) {
        String ft = sce.getFieldType(this.getBoundFactType(col.getBoundName()), col.getFactField());
        return ft != null && ft.equals(dataType);
    }

    private boolean assertDataType(ActionInsertFactCol52 col, SuggestionCompletionEngine sce, String dataType) {
        String ft = sce.getFieldType(col.getFactType(), col.getFactField());
        return ft != null && ft.equals(dataType);
    }
}

