/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLSentence
implements IPattern,
IAction {
    private String sentence;
    private String definition;
    private List<String> values;

    public String toString() {
        this.getDefinition();
        char[] chars = this.definition.toCharArray();
        boolean inBracket = false;
        boolean inBracketAfterColon = false;
        String result = "";
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c != '{' && c != '}' && c != ':' && !inBracketAfterColon) {
                result = result + c;
                continue;
            }
            if (c == '{') {
                inBracket = true;
                continue;
            }
            if (c == '}') {
                inBracket = false;
                inBracketAfterColon = false;
                continue;
            }
            if (c == ':' && inBracket) {
                inBracketAfterColon = true;
                continue;
            }
            if (c != ':' || inBracket) continue;
            result = result + c;
        }
        return result.replace("\\n", "\n");
    }

    public String interpolate() {
        this.getValues();
        if (this.definition == null) {
            return "";
        }
        int variableStart = this.definition.indexOf("{");
        if (variableStart < 0) {
            return this.definition;
        }
        int index = 0;
        int variableEnd = 0;
        StringBuilder sb = new StringBuilder();
        while (variableStart >= 0) {
            sb.append(this.definition.substring(variableEnd, variableStart));
            variableEnd = this.getIndexForEndOfVariable(this.definition, variableStart) + 1;
            variableStart = this.definition.indexOf("{", variableEnd);
            sb.append(this.values.get(index++));
        }
        if (variableEnd < this.definition.length()) {
            sb.append(this.definition.substring(variableEnd));
        }
        return sb.toString();
    }

    public DSLSentence copy() {
        DSLSentence newOne = new DSLSentence();
        newOne.definition = this.getDefinition();
        List<String> values = this.getValues();
        if (values != null) {
            for (String value : this.getValues()) {
                newOne.getValues().add(value);
            }
        }
        return newOne;
    }

    public String getDefinition() {
        if (this.definition == null) {
            this.parseSentence();
        }
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public List<String> getValues() {
        if (this.values == null) {
            this.parseDefinition();
        }
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    private void parseSentence() {
        if (this.sentence == null) {
            return;
        }
        this.definition = this.sentence;
        this.values = new ArrayList<String>();
        this.sentence = null;
        int variableStart = this.definition.indexOf("{");
        while (variableStart >= 0) {
            int variableEnd = this.getIndexForEndOfVariable(this.definition, variableStart);
            String variable = this.definition.substring(variableStart + 1, variableEnd);
            this.values.add(this.parseValue(variable));
            variableStart = this.definition.indexOf("{", variableEnd);
        }
    }

    private void parseDefinition() {
        this.values = new ArrayList<String>();
        if (this.getDefinition() == null) {
            return;
        }
        int variableStart = this.definition.indexOf("{");
        while (variableStart >= 0) {
            int variableEnd = this.getIndexForEndOfVariable(this.definition, variableStart);
            String variable = this.definition.substring(variableStart + 1, variableEnd);
            this.values.add(this.parseValue(variable));
            variableStart = this.definition.indexOf("{", variableEnd);
        }
    }

    private int getIndexForEndOfVariable(String dsl, int start) {
        int end = -1;
        int bracketCount = 0;
        if (start > dsl.length()) {
            return end;
        }
        for (int i = start; i < dsl.length(); ++i) {
            char c = dsl.charAt(i);
            if (c == '{') {
                ++bracketCount;
            }
            if (c != '}' || --bracketCount != 0) continue;
            end = i;
            return end;
        }
        return -1;
    }

    private String parseValue(String variable) {
        if (!variable.contains(":")) {
            return variable;
        }
        String value = variable.substring(0, variable.indexOf(":"));
        return value;
    }
}

