/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl;

import java.util.List;
import org.drools.ide.common.client.modeldriven.brl.CEPWindow;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.HasCEPWindow;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;

public class FactPattern
implements IFactPattern,
HasCEPWindow {
    public CompositeFieldConstraint constraintList;
    private String factType;
    private String boundName;
    private boolean isNegated;
    private CEPWindow window;

    public FactPattern() {
    }

    public FactPattern(String factType) {
        this.factType = factType;
    }

    public String getBoundName() {
        return this.boundName;
    }

    public void setBoundName(String boundName) {
        this.boundName = boundName;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public void setNegated(boolean isNegated) {
        this.isNegated = isNegated;
    }

    public void addConstraint(FieldConstraint constraint) {
        if (this.constraintList == null) {
            this.constraintList = new CompositeFieldConstraint();
        }
        this.constraintList.addConstraint(constraint);
    }

    public void removeConstraint(int idx) {
        this.constraintList.removeConstraint(idx);
    }

    public boolean isBound() {
        return this.boundName != null && !"".equals(this.boundName);
    }

    public FieldConstraint[] getFieldConstraints() {
        if (this.constraintList == null) {
            return new FieldConstraint[0];
        }
        return this.constraintList.constraints;
    }

    public void setFieldConstraints(List sortedConstraints) {
        if (sortedConstraints != null) {
            if (this.constraintList != null) {
                this.constraintList.constraints = new FieldConstraint[sortedConstraints.size()];
                for (int i = 0; i < sortedConstraints.size(); ++i) {
                    this.constraintList.constraints[i] = (FieldConstraint)sortedConstraints.get(i);
                }
            } else if (sortedConstraints.size() > 0) {
                throw new IllegalStateException("Cannot have constraints if constraint list is null.");
            }
        } else {
            this.constraintList.constraints = null;
        }
    }

    public String getFactType() {
        return this.factType;
    }

    public void setFactType(String factType) {
        this.factType = factType;
    }

    public void setWindow(CEPWindow window) {
        this.window = window;
    }

    public CEPWindow getWindow() {
        if (this.window == null) {
            this.window = new CEPWindow();
        }
        return this.window;
    }
}

