/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FromEntryPointFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionRetractFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTDRLOtherwiseHelper;
import org.drools.ide.common.server.util.GuidedDTDRLUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidedDTDRLPersistence {
    public static GuidedDTDRLPersistence getInstance() {
        return new GuidedDTDRLPersistence();
    }

    public String marshal(GuidedDecisionTable52 dt) {
        StringBuilder sb = new StringBuilder();
        List<List<DTCellValue52>> data = dt.getData();
        List<DTColumnConfig52> allColumns = dt.getAllColumns();
        for (int i = 0; i < data.size(); ++i) {
            List<DTCellValue52> row = data.get(i);
            BigDecimal num = row.get(0).getNumericValue();
            String desc = row.get(1).getStringValue();
            RuleModel rm = new RuleModel();
            rm.name = this.getName(dt.getTableName(), num);
            this.doMetadata(allColumns, dt.getMetadataCols(), row, rm);
            this.doAttribs(allColumns, dt.getAttributeCols(), row, rm);
            this.doConditions(allColumns, dt.getConditionPatterns(), row, data, rm);
            this.doActions(allColumns, dt.getActionCols(), row, rm);
            if (dt.getParentName() != null) {
                rm.parentName = dt.getParentName();
            }
            sb.append("#from row number: " + (i + 1) + "\n");
            if (desc != null && desc.length() > 0) {
                sb.append("#" + desc + "\n");
            }
            String rule = BRDRLPersistence.getInstance().marshal(rm);
            sb.append(rule);
            sb.append("\n");
        }
        return sb.toString();
    }

    void doActions(List<DTColumnConfig52> allColumns, List<ActionCol52> actionCols, List<DTCellValue52> row, RuleModel rm) {
        int i;
        ArrayList<LabelledAction> actions = new ArrayList<LabelledAction>();
        for (i = 0; i < actionCols.size(); ++i) {
            ActionFieldValue val;
            LabelledAction a;
            ActionCol52 c = actionCols.get(i);
            int index = allColumns.indexOf(c);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(row.get(index));
            if (!this.validCell(cell)) {
                cell = c.getDefaultValue();
            }
            if (!this.validCell(cell)) continue;
            if (c instanceof ActionInsertFactCol52) {
                ActionInsertFact ins;
                ActionInsertFactCol52 ac = (ActionInsertFactCol52)c;
                a = this.findByLabelledAction(actions, ac.getBoundName());
                if (a == null) {
                    a = new LabelledAction();
                    a.boundName = ac.getBoundName();
                    if (!ac.isInsertLogical()) {
                        ins = new ActionInsertFact(ac.getFactType());
                        ins.setBoundName(ac.getBoundName());
                        a.action = ins;
                    } else {
                        ins = new ActionInsertLogicalFact(ac.getFactType());
                        ins.setBoundName(ac.getBoundName());
                        a.action = ins;
                    }
                    actions.add(a);
                }
                ins = (ActionInsertFact)a.action;
                val = new ActionFieldValue(ac.getFactField(), cell, ac.getType());
                ins.addFieldValue(val);
                continue;
            }
            if (c instanceof ActionRetractFactCol52) {
                ActionRetractFactCol52 rf = (ActionRetractFactCol52)c;
                a = this.findByLabelledAction(actions, rf.getBoundName());
                if (a != null) continue;
                a = new LabelledAction();
                a.action = new ActionRetractFact(rf.getBoundName());
                a.boundName = rf.getBoundName();
                actions.add(a);
                continue;
            }
            if (!(c instanceof ActionSetFieldCol52)) continue;
            ActionSetFieldCol52 sf = (ActionSetFieldCol52)c;
            a = this.findByLabelledAction(actions, sf.getBoundName());
            if (a == null) {
                a = new LabelledAction();
                a.boundName = sf.getBoundName();
                a.action = !sf.isUpdate() ? new ActionSetField(sf.getBoundName()) : new ActionUpdateField(sf.getBoundName());
                actions.add(a);
            } else if (sf.isUpdate() && !(a.action instanceof ActionUpdateField)) {
                ActionSetField old = (ActionSetField)a.action;
                ActionUpdateField update = new ActionUpdateField(sf.getBoundName());
                update.fieldValues = old.fieldValues;
                a.action = update;
            }
            ActionSetField asf = (ActionSetField)a.action;
            val = new ActionFieldValue(sf.getFactField(), cell, sf.getType());
            asf.addFieldValue(val);
        }
        rm.rhs = new IAction[actions.size()];
        for (i = 0; i < rm.rhs.length; ++i) {
            rm.rhs[i] = ((LabelledAction)actions.get((int)i)).action;
        }
    }

    private LabelledAction findByLabelledAction(List<LabelledAction> actions, String boundName) {
        for (LabelledAction labelledAction : actions) {
            if (!labelledAction.boundName.equals(boundName)) continue;
            return labelledAction;
        }
        return null;
    }

    void doConditions(List<DTColumnConfig52> allColumns, List<Pattern52> conditionPatterns, List<DTCellValue52> row, List<List<DTCellValue52>> data, RuleModel rm) {
        ArrayList<IFactPattern> patterns = new ArrayList<IFactPattern>();
        for (Pattern52 p : conditionPatterns) {
            List<ConditionCol52> cols = p.getConditions();
            block5: for (ConditionCol52 c : cols) {
                FromEntryPointFactPattern fep;
                FactPattern fp;
                boolean isOtherwise;
                int index = allColumns.indexOf(c);
                DTCellValue52 dcv = row.get(index);
                String cell = GuidedDTDRLUtilities.convertDTCellValueToString(dcv);
                boolean isValid = isOtherwise = dcv.isOtherwise();
                if (!isOtherwise) {
                    isValid = this.validCell(cell);
                }
                if (c.getOperator() != null && (c.getOperator().equals("== null") || c.getOperator().equals("!= null"))) {
                    isValid = true;
                }
                if (!isValid) continue;
                IFactPattern ifp = this.findByFactPattern(patterns, p.getBoundName());
                if (ifp == null) {
                    fp = new FactPattern(p.getFactType());
                    fp.setBoundName(p.getBoundName());
                    fp.setNegated(p.isNegated());
                    fp.setWindow(p.getWindow());
                    if (p.getEntryPointName() != null && p.getEntryPointName().length() > 0) {
                        fep = new FromEntryPointFactPattern();
                        fep.setEntryPointName(p.getEntryPointName());
                        fep.setFactPattern(fp);
                        patterns.add(fep);
                        ifp = fep;
                    } else {
                        patterns.add(fp);
                        ifp = fp;
                    }
                }
                if (ifp instanceof FactPattern) {
                    fp = (FactPattern)ifp;
                } else if (ifp instanceof FromEntryPointFactPattern) {
                    fep = (FromEntryPointFactPattern)ifp;
                    fp = fep.getFactPattern();
                } else {
                    throw new IllegalArgumentException("Inexpected IFactPattern implementation found.");
                }
                switch (c.getConstraintValueType()) {
                    case 1: 
                    case 3: {
                        FieldConstraint fc;
                        if (!isOtherwise) {
                            fc = this.makeSingleFieldConstraint(c, cell);
                            fp.addConstraint(fc);
                            continue block5;
                        }
                        fc = this.makeSingleFieldConstraint(c, allColumns, data);
                        fp.addConstraint(fc);
                        continue block5;
                    }
                    case 5: {
                        SingleFieldConstraint pred = new SingleFieldConstraint();
                        pred.setConstraintValueType(c.getConstraintValueType());
                        if (c.getFactField() != null && c.getFactField().indexOf("$param") > -1) {
                            pred.setValue(c.getFactField().replace("$param", cell));
                        } else {
                            pred.setValue(cell);
                        }
                        fp.addConstraint(pred);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unknown constraintValueType: " + c.getConstraintValueType());
            }
        }
        rm.lhs = patterns.toArray(new IPattern[patterns.size()]);
    }

    String makeInList(String cell) {
        if (cell.startsWith("(")) {
            return cell;
        }
        String res = "";
        StringTokenizer st = new StringTokenizer(cell, ",");
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            res = t.startsWith("\"") ? res + t : res + "\"" + t + "\"";
            if (!st.hasMoreTokens()) continue;
            res = res + ", ";
        }
        return "(" + res + ")";
    }

    private boolean no(String operator) {
        return operator == null || "".equals(operator);
    }

    private IFactPattern findByFactPattern(List<IFactPattern> patterns, String boundName) {
        if (boundName == null) {
            return null;
        }
        for (IFactPattern ifp : patterns) {
            FromEntryPointFactPattern fefp;
            FactPattern fp;
            if (ifp instanceof FactPattern) {
                FactPattern fp2 = (FactPattern)ifp;
                if (fp2.getBoundName() == null || !fp2.getBoundName().equals(boundName)) continue;
                return fp2;
            }
            if (!(ifp instanceof FromEntryPointFactPattern) || (fp = (fefp = (FromEntryPointFactPattern)ifp).getFactPattern()).getBoundName() == null || !fp.getBoundName().equals(boundName)) continue;
            return fp;
        }
        return null;
    }

    void doAttribs(List<DTColumnConfig52> allColumns, List<AttributeCol52> attributeCols, List<DTCellValue52> row, RuleModel rm) {
        ArrayList<RuleAttribute> attribs = new ArrayList<RuleAttribute>();
        for (int j = 0; j < attributeCols.size(); ++j) {
            AttributeCol52 at = attributeCols.get(j);
            int index = allColumns.indexOf(at);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(row.get(index));
            if (this.validCell(cell)) {
                if (at.getAttribute().equals("negate")) {
                    rm.setNegated(Boolean.valueOf(cell));
                    continue;
                }
                attribs.add(new RuleAttribute(at.getAttribute(), cell));
                continue;
            }
            if (at.getDefaultValue() == null) continue;
            attribs.add(new RuleAttribute(at.getAttribute(), at.getDefaultValue()));
        }
        if (attribs.size() > 0) {
            rm.attributes = attribs.toArray(new RuleAttribute[attribs.size()]);
        }
    }

    void doMetadata(List<DTColumnConfig52> allColumns, List<MetadataCol52> metadataCols, List<DTCellValue52> row, RuleModel rm) {
        ArrayList<RuleMetadata> metadataList = new ArrayList<RuleMetadata>();
        for (int j = 0; j < metadataCols.size(); ++j) {
            MetadataCol52 meta = metadataCols.get(j);
            int index = allColumns.indexOf(meta);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(row.get(index));
            if (!this.validCell(cell)) continue;
            metadataList.add(new RuleMetadata(meta.getMetadata(), cell));
        }
        if (metadataList.size() > 0) {
            rm.metadataList = metadataList.toArray(new RuleMetadata[metadataList.size()]);
        }
    }

    String getName(String tableName, Number num) {
        return "Row " + num.longValue() + " " + tableName;
    }

    boolean validCell(String c) {
        return c != null && !c.trim().equals("");
    }

    private FieldConstraint makeSingleFieldConstraint(ConditionCol52 c, String cell) {
        SingleFieldConstraint sfc = new SingleFieldConstraint(c.getFactField());
        if (this.no(c.getOperator())) {
            String[] a = cell.split("\\s");
            if (a.length > 1) {
                sfc.setOperator(a[0]);
                sfc.setValue(a[1]);
            } else {
                sfc.setValue(cell);
            }
        } else {
            sfc.setOperator(c.getOperator());
            if (c.getOperator().equals("in")) {
                sfc.setValue(this.makeInList(cell));
            } else if (!c.getOperator().equals("== null") && !c.getOperator().equals("!= null")) {
                sfc.setValue(cell);
            }
        }
        sfc.setParameters(c.getParameters());
        sfc.setConstraintValueType(c.getConstraintValueType());
        sfc.setFieldType(c.getFieldType());
        return sfc;
    }

    private FieldConstraint makeSingleFieldConstraint(ConditionCol52 c, List<DTColumnConfig52> allColumns, List<List<DTCellValue52>> data) {
        GuidedDTDRLOtherwiseHelper.OtherwiseBuilder builder = GuidedDTDRLOtherwiseHelper.getBuilder(c);
        return builder.makeFieldConstraint(c, allColumns, data);
    }

    private class LabelledAction {
        String boundName;
        IAction action;

        private LabelledAction() {
        }
    }
}

