/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;
import org.drools.ide.common.client.modeldriven.ModelAnnotation;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionCompletionLoaderTest {
    @Test
    public void testSuggestionCompLoader() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.Person", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
    }

    @Test
    public void testSuggestionCompLoaderWithExtraImportProviders() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        loader.addExternalImportDescrProvider(new SuggestionCompletionLoader.ExternalImportDescrProvider(){

            public Set<ImportDescr> getImportDescrs() {
                return new HashSet<ImportDescr>(){
                    {
                        this.add(new ImportDescr("java.util.List"));
                        this.add(new ImportDescr("java.util.Set"));
                    }
                };
            }
        });
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.Person", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((long)3L, (long)eng.getFactTypes().length);
        List<String> factTypes = Arrays.asList(eng.getFactTypes());
        Assert.assertTrue((boolean)factTypes.contains("List"));
        Assert.assertTrue((boolean)factTypes.contains("Set"));
        Assert.assertTrue((boolean)factTypes.contains("Person"));
        eng = loader.getSuggestionEngine("package foo \n import org.drools.Person \n declare GenBean \n   id: int \n name : String \n end \n declare GenBean2 \n list: java.util.List \n gb: GenBean \n end", new ArrayList(), new ArrayList());
        Assert.assertEquals((long)5L, (long)eng.getFactTypes().length);
        factTypes = Arrays.asList(eng.getFactTypes());
        Assert.assertTrue((boolean)factTypes.contains("List"));
        Assert.assertTrue((boolean)factTypes.contains("Set"));
        Assert.assertTrue((boolean)factTypes.contains("Person"));
        Assert.assertTrue((boolean)factTypes.contains("GenBean"));
        Assert.assertTrue((boolean)factTypes.contains("GenBean2"));
    }

    @Test
    public void testSuggestionCompLoaderWithExtraImportProvidersAndFilters() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        loader.addExternalImportDescrProvider(new SuggestionCompletionLoader.ExternalImportDescrProvider(){

            public Set<ImportDescr> getImportDescrs() {
                return new HashSet<ImportDescr>(){
                    {
                        this.add(new ImportDescr("java.util.List"));
                        this.add(new ImportDescr("java.util.Set"));
                    }
                };
            }
        });
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.Person \n declare GenBean \n   id: int \n name : String \n end \n declare GenBean2 \n list: java.util.List \n gb: GenBean \n end", new ArrayList(), new ArrayList());
        eng.setFactTypeFilter(new FactTypeFilter(){

            public boolean filter(String originalFact) {
                return originalFact.equals("List") || originalFact.equals("GenBean2");
            }
        });
        eng.setFilteringFacts(true);
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((long)3L, (long)eng.getFactTypes().length);
        List<String> factTypes = Arrays.asList(eng.getFactTypes());
        Assert.assertTrue((boolean)factTypes.contains("Set"));
        Assert.assertTrue((boolean)factTypes.contains("Person"));
        Assert.assertTrue((boolean)factTypes.contains("GenBean"));
    }

    @Test
    public void testSuggestionCompLoaderWildCards() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        loader.getSuggestionEngine("package foo \n import org.drools.*", Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((long)1L, (long)loader.getErrors().size());
        String err = (String)loader.getErrors().get(0);
        Assert.assertTrue((boolean)err.startsWith("Unable"));
    }

    @Test
    public void testTestAnyEnum() throws Exception {
        SuggestionCompletionLoader suggestionCompletionLoader = new SuggestionCompletionLoader();
        ArrayList<DSLTokenizedMappingFile> dsls = new ArrayList<DSLTokenizedMappingFile>();
        DSLTokenizedMappingFile dslTokenizedMappingFile = new DSLTokenizedMappingFile();
        DSLMappingEntry dslMappingEntry = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class);
        Mockito.when((Object)dslMappingEntry.getSection()).thenReturn((Object)DSLMappingEntry.ANY);
        dslTokenizedMappingFile.getMapping().addEntry(dslMappingEntry);
        dsls.add(dslTokenizedMappingFile);
        SuggestionCompletionEngine suggestionEngine = suggestionCompletionLoader.getSuggestionEngine("", Collections.emptyList(), dsls);
        Assert.assertEquals((long)1L, (long)suggestionEngine.actionDSLSentences.length);
        Assert.assertEquals((long)1L, (long)suggestionEngine.conditionDSLSentences.length);
        Assert.assertEquals((long)0L, (long)suggestionEngine.keywordDSLItems.length);
    }

    @Test
    public void testLoadDifferentFieldTypes() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((Object)"Numeric", (Object)eng.getFieldType("SomeFact", "age"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("SomeFact", "likes"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("SomeFact", "name"));
        Assert.assertEquals((Object)"Numeric", (Object)eng.getFieldType("SomeFact", "bigDecimal"));
        Assert.assertEquals((Object)"Boolean", (Object)eng.getFieldType("SomeFact", "alive"));
        Assert.assertEquals((Object)"Date", (Object)eng.getFieldType("SomeFact", "date"));
        Assert.assertEquals((Object)"Cheese", (Object)eng.getFieldType("SomeFact", "cheese"));
        Assert.assertEquals((Object)"Boolean", (Object)eng.getFieldType("SomeFact", "dead"));
        Assert.assertEquals((Object)"Boolean", (Object)eng.getFieldType("SomeFact", "alive"));
        Assert.assertEquals((Object)"Collection", (Object)eng.getFieldType("SomeFact", "factList"));
        Assert.assertEquals((Object)"SomeFact", (Object)eng.getParametricFieldType("SomeFact", "factList"));
        Assert.assertEquals((Object)"Collection", (Object)eng.getFieldType("SomeFact", "factListString"));
        Assert.assertEquals((Object)"String", (Object)eng.getParametricFieldType("SomeFact", "factListString"));
    }

    @Test
    public void testLoadDifferentMethodTypes() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((Object)List.class.getName(), (Object)eng.getMethodClassType("SomeFact", "aMethod(int)"));
        Assert.assertEquals((Object)"SomeFact", (Object)eng.getParametricFieldType("SomeFact", "aMethod(int)"));
    }

    @Test
    public void testGeneratedBeans() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n declare GenBean \n   id: int \n name : String \n end \n declare GenBean2 \n list: java.util.List \n gb: GenBean \n end", new ArrayList(), new ArrayList());
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((long)2L, (long)eng.getFactTypes().length);
        Assert.assertEquals((Object)"GenBean", (Object)eng.getFactTypes()[0]);
        Assert.assertEquals((Object)"GenBean2", (Object)eng.getFactTypes()[1]);
        Assert.assertEquals((Object)"Numeric", (Object)eng.getFieldType("GenBean", "id"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("GenBean", "name"));
        Assert.assertEquals((Object)"GenBean", (Object)eng.getFieldType("GenBean2", "gb"));
    }

    @Test
    public void testGeneratedBeansExtendsSimple() throws Exception {
        String packageDrl = "package foo \ndeclare Bean1 \nage: int \nname : String \nend \ndeclare Bean2 extends Bean1\ncheese : String \nend";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine(packageDrl, new ArrayList(), new ArrayList());
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((long)2L, (long)eng.getFactTypes().length);
        Assert.assertEquals((Object)"Bean1", (Object)eng.getFactTypes()[0]);
        Assert.assertEquals((Object)"Bean2", (Object)eng.getFactTypes()[1]);
        Assert.assertEquals((long)3L, (long)eng.getFieldCompletions("Bean1").length);
        Assert.assertEquals((Object)"Bean1", (Object)eng.getFieldType("Bean1", "this"));
        Assert.assertEquals((Object)"Numeric", (Object)eng.getFieldType("Bean1", "age"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Bean1", "name"));
        Assert.assertEquals((long)4L, (long)eng.getFieldCompletions("Bean2").length);
        Assert.assertEquals((Object)"Bean2", (Object)eng.getFieldType("Bean2", "this"));
        Assert.assertEquals((Object)"Numeric", (Object)eng.getFieldType("Bean2", "age"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Bean2", "name"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Bean2", "cheese"));
    }

    @Test
    public void testGeneratedBeansExtendsPOJOSimple() throws Exception {
        String packageDrl = "package foo \nimport org.drools.Address\ndeclare Address \nend";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine(packageDrl, new ArrayList(), new ArrayList());
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((long)1L, (long)eng.getFactTypes().length);
        Assert.assertEquals((Object)"Address", (Object)eng.getFactTypes()[0]);
        Assert.assertEquals((long)4L, (long)eng.getFieldCompletions("Address").length);
        Assert.assertEquals((Object)"Address", (Object)eng.getFieldType("Address", "this"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address", "street"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address", "suburb"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address", "zipCode"));
    }

    @Test
    public void testGeneratedBeansExtendsPOJOComplex() throws Exception {
        String packageDrl = "package foo \nimport org.drools.Address\ndeclare Address \nend\ndeclare Address2 extends Address\nisNicePlace : Boolean \nend";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine(packageDrl, new ArrayList(), new ArrayList());
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((long)2L, (long)eng.getFactTypes().length);
        Assert.assertEquals((Object)"Address", (Object)eng.getFactTypes()[0]);
        Assert.assertEquals((Object)"Address2", (Object)eng.getFactTypes()[1]);
        Assert.assertEquals((long)4L, (long)eng.getFieldCompletions("Address").length);
        Assert.assertEquals((Object)"Address", (Object)eng.getFieldType("Address", "this"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address", "street"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address", "suburb"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address", "zipCode"));
        Assert.assertEquals((long)5L, (long)eng.getFieldCompletions("Address2").length);
        Assert.assertEquals((Object)"Address2", (Object)eng.getFieldType("Address2", "this"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address2", "street"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address2", "suburb"));
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Address2", "zipCode"));
        Assert.assertEquals((Object)"Boolean", (Object)eng.getFieldType("Address2", "isNicePlace"));
    }

    @Test
    public void testGlobal() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n global org.drools.Person p", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertEquals((long)1L, (long)eng.getGlobalVariables().length);
        Assert.assertEquals((Object)"p", (Object)eng.getGlobalVariables()[0]);
        Assert.assertEquals((Object)"Person", (Object)eng.getGlobalVariable("p"));
        String[] flds = eng.getModelFields("Person");
        Assert.assertNotNull((Object)flds);
        Assert.assertEquals((long)0L, (long)eng.getGlobalCollections().length);
    }

    @Test
    public void testGlobalCollections() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n global java.util.List ls", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertEquals((long)1L, (long)eng.getGlobalVariables().length);
        Assert.assertEquals((Object)"ls", (Object)eng.getGlobalVariables()[0]);
        Assert.assertEquals((Object)"List", (Object)eng.getGlobalVariable("ls"));
        Assert.assertNotNull((Object)eng.getGlobalCollections());
        Assert.assertEquals((long)1L, (long)eng.getGlobalCollections().length);
        Assert.assertEquals((Object)"ls", (Object)eng.getGlobalCollections()[0]);
    }

    @Test
    public void testSortOrderOfFields() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        String[] fields = eng.getFieldCompletions("SomeFact");
        Assert.assertEquals((Object)"this", (Object)fields[0]);
        Assert.assertEquals((Object)"age", (Object)fields[1]);
        Assert.assertEquals((Object)"alive", (Object)fields[2]);
        Assert.assertEquals((Object)"anEnum", (Object)fields[3]);
        Assert.assertEquals((Object)"bigDecimal", (Object)fields[4]);
    }

    @Test
    public void testEnumFields() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertTrue((boolean)eng.hasDataEnumLists());
        Assert.assertEquals((long)eng.getDataEnumList("SomeFact.anEnum").length, (long)3L);
        String[] a = eng.getDataEnumList("SomeFact.anEnum");
        Assert.assertEquals((Object)a[0], (Object)"EnumClass.v1=EnumClass.v1");
        Assert.assertEquals((Object)a[1], (Object)"EnumClass.v2=EnumClass.v2");
        Assert.assertEquals((Object)a[2], (Object)"EnumClass.v3=EnumClass.v3");
    }

    @Test
    public void testSortOrderOfFacts() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact\n import org.drools.Person", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        String[] facts = eng.getFactTypes();
        Assert.assertEquals((long)2L, (long)facts.length);
        Assert.assertEquals((Object)"Person", (Object)facts[0]);
        Assert.assertEquals((Object)"SomeFact", (Object)facts[1]);
    }

    @Test
    public void testTypeDeclarations() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        String header = "";
        header = header + "package foo\n";
        header = header + "declare Applicant\n";
        header = header + "     creditRating: String\n";
        header = header + "     approved: Boolean\n";
        header = header + "     applicationDate: java.util.Date\n";
        header = header + "     age: Integer\n";
        header = header + "     name: String\n";
        header = header + "end\n";
        header = header + "declare LoanApplication\n";
        header = header + "     amount: Integer\n";
        header = header + "     approved: Boolean\n";
        header = header + "     deposit: Integer\n";
        header = header + "     approvedRate: Integer\n";
        header = header + "     lengthYears: Integer\n";
        header = header + "     explanation: String\n";
        header = header + "     insuranceCost: Integer\n";
        header = header + "     applicant: Applicant\n";
        header = header + "end\n";
        SuggestionCompletionEngine eng = loader.getSuggestionEngine(header, new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertEquals((Object)"String", (Object)eng.getFieldType("Applicant", "creditRating"));
        Assert.assertEquals((Object)"java.lang.String", (Object)eng.getFieldClassName("Applicant", "creditRating"));
        Assert.assertEquals((Object)ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, (Object)eng.getFieldClassType("Applicant", "creditRating"));
        Assert.assertEquals((Object)"Numeric", (Object)eng.getFieldType("LoanApplication", "deposit"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)eng.getFieldClassName("LoanApplication", "deposit"));
        Assert.assertEquals((Object)ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, (Object)eng.getFieldClassType("LoanApplication", "deposit"));
        Assert.assertEquals((Object)"Applicant", (Object)eng.getFieldType("LoanApplication", "applicant"));
        Assert.assertEquals((Object)"Applicant", (Object)eng.getFieldClassName("LoanApplication", "applicant"));
        Assert.assertEquals((Object)ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, (Object)eng.getFieldClassType("LoanApplication", "applicant"));
    }

    @Test
    public void testLoaderWithExistingClassloader() throws Exception {
        MockClassLoader mcl = new MockClassLoader();
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader((ClassLoader)mcl);
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.foo.Bar", new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertTrue((boolean)mcl.called);
    }

    @Test
    public void testTypeDeclarationsAnnotations() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        String header = "";
        header = header + "package foo\n";
        header = header + "declare Applicant\n";
        header = header + "@role( event )\n";
        header = header + "end\n";
        SuggestionCompletionEngine eng = loader.getSuggestionEngine(header, new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertNotNull((Object)eng.getAnnotations());
        Assert.assertEquals((long)1L, (long)eng.getAnnotations().size());
        Assert.assertNotNull(eng.getAnnotations().get("Applicant"));
        Assert.assertEquals((long)1L, (long)((List)eng.getAnnotations().get("Applicant")).size());
        Assert.assertNotNull(((List)eng.getAnnotations().get("Applicant")).get(0));
        Assert.assertEquals((Object)"role", (Object)((ModelAnnotation)((List)eng.getAnnotations().get("Applicant")).get(0)).getAnnotationName());
        Assert.assertEquals((Object)"event", ((ModelAnnotation)((List)eng.getAnnotations().get("Applicant")).get(0)).getAnnotationValues().get("value"));
        Assert.assertNotNull((Object)eng.getAnnotationsForFactType("Applicant"));
        Assert.assertNotNull(eng.getAnnotationsForFactType("Applicant").get(0));
        Assert.assertEquals((Object)"role", (Object)((ModelAnnotation)eng.getAnnotationsForFactType("Applicant").get(0)).getAnnotationName());
        Assert.assertEquals((Object)"event", ((ModelAnnotation)eng.getAnnotationsForFactType("Applicant").get(0)).getAnnotationValues().get("value"));
    }

    @Test
    public void testTypeDeclarationsMultipleAnnotations() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        String header = "";
        header = header + "package foo\n";
        header = header + "declare Applicant\n";
        header = header + "@role( event )\n";
        header = header + "@smurf( name = Pupa)\n";
        header = header + "end\n";
        SuggestionCompletionEngine eng = loader.getSuggestionEngine(header, new ArrayList(), new ArrayList());
        Assert.assertNotNull((Object)eng);
        Assert.assertNotNull((Object)eng.getAnnotations());
        Assert.assertEquals((long)1L, (long)eng.getAnnotations().size());
        Assert.assertNotNull(eng.getAnnotations().get("Applicant"));
        Assert.assertEquals((long)2L, (long)((List)eng.getAnnotations().get("Applicant")).size());
        int idx0 = this.getIndexOfAnnotation(eng.getAnnotationsForFactType("Applicant"), "role");
        int idx1 = this.getIndexOfAnnotation(eng.getAnnotationsForFactType("Applicant"), "smurf");
        Assert.assertNotNull(((List)eng.getAnnotations().get("Applicant")).get(idx0));
        Assert.assertEquals((Object)"role", (Object)((ModelAnnotation)((List)eng.getAnnotations().get("Applicant")).get(idx0)).getAnnotationName());
        Assert.assertEquals((Object)"event", ((ModelAnnotation)((List)eng.getAnnotations().get("Applicant")).get(idx0)).getAnnotationValues().get("value"));
        Assert.assertNotNull(((List)eng.getAnnotations().get("Applicant")).get(idx1));
        Assert.assertEquals((Object)"smurf", (Object)((ModelAnnotation)((List)eng.getAnnotations().get("Applicant")).get(idx1)).getAnnotationName());
        Assert.assertEquals((Object)"Pupa", ((ModelAnnotation)((List)eng.getAnnotations().get("Applicant")).get(idx1)).getAnnotationValues().get("name"));
    }

    private int getIndexOfAnnotation(List<ModelAnnotation> annotations, String annotationName) {
        for (int i = 0; i < annotations.size(); ++i) {
            ModelAnnotation annotation = annotations.get(i);
            if (!annotationName.equals(annotation.getAnnotationName())) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MockClassLoader
    extends ClassLoader {
        public boolean called = false;

        MockClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) {
            this.called = true;
            return Object.class;
        }
    }
}

