/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.ModelAnnotation;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionCompletionEngine
implements PortableObject {
    public static final String TYPE_COLLECTION = "Collection";
    public static final String TYPE_COMPARABLE = "Comparable";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_NUMERIC = "Numeric";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_OBJECT = "Object";
    public static final String TYPE_FINAL_OBJECT = "FinalObject";
    public static final String TYPE_THIS = "this";
    public static final String ANNOTATION_ROLE = "role";
    public static final String ANNOTATION_ROLE_EVENT = "event";
    private static final String[] STANDARD_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !="};
    private static final String[] STRING_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& >", "&& <", "|| >", "|| <", "&& >=", "&& <=", "|| <=", "|| >=", "&& matches", "|| matches"};
    private static final String[] COMPARABLE_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "&& >", "&& <", "|| >", "|| <", "&& >=", "&& <=", "|| <=", "|| >="};
    private static final String[] COLLECTION_CONNECTIVES = new String[]{"|| ==", "|| !=", "&& !=", "|| contains", "&& contains", "|| excludes", "&& excludes"};
    private static final String[] STANDARD_OPERATORS = new String[]{"==", "!=", "== null", "!= null"};
    private static final String[] COMPARABLE_OPERATORS = new String[]{"==", "!=", "<", ">", "<=", ">=", "== null", "!= null"};
    private static final String[] STRING_OPERATORS = new String[]{"==", "!=", "<", ">", "<=", ">=", "matches", "soundslike", "== null", "!= null"};
    private static final String[] COLLECTION_OPERATORS = new String[]{"contains", "excludes", "==", "!=", "== null", "!= null"};
    private static final String[] SIMPLE_CEP_OPERATORS = new String[]{"after", "before", "coincides"};
    private static final String[] COMPLEX_CEP_OPERATORS = new String[]{"during", "finishes", "finishedby", "includes", "meets", "metby", "overlaps", "overlappedby", "starts", "startedby"};
    private static final String[] WINDOW_CEP_OPERATORS = new String[]{"over window:time", "over window:length"};
    private static final String[] SIMPLE_CEP_CONNECTIVES = new String[]{"|| after", "|| before", "|| coincides", "&& after", "&& before", "&& coincides"};
    private static final String[] COMPLEX_CEP_CONNECTIVES = new String[]{"|| during", "|| finishes", "|| finishedby", "|| includes", "|| meets", "|| metby", "|| overlaps", "|| overlappedby", "|| starts", "|| startedby", "&& during", "&& finishes", "&& finishedby", "&& includes", "&& meets", "&& metby", "&& overlaps", "&& overlappedby", "&& starts", "&& startedby"};
    private static final Map<String, List<Integer>> CEP_OPERATORS_PARAMETERS = new HashMap<String, List<Integer>>();
    private static final String[] CONDITIONAL_ELEMENTS = new String[]{"not", "exists", "or"};
    private Map<String, String> fieldParametersType;
    private Map<String, String> globalTypes;
    private Map<String, String[]> modifiers;
    private Map<String, String[]> dataEnumLists;
    private Map<String, List<ModelAnnotation>> annotationsForTypes;
    private String[] globalCollections;
    public DSLSentence[] conditionDSLSentences;
    public DSLSentence[] actionDSLSentences;
    public DSLSentence[] keywordDSLItems;
    public DSLSentence[] anyScopeDSLItems;
    private transient Map<String, Object> dataEnumLookupFields;
    private Map<String, List<MethodInfo>> methodInfos;
    private Map<String, ModelField[]> modelFields;
    private Map<String, ModelField[]> filterModelFields;
    private Map<String, FieldAccessorsAndMutators> accessorsAndMutators;
    private FactTypeFilter factFilter;
    private boolean filteringFacts;

    public SuggestionCompletionEngine() {
        CEP_OPERATORS_PARAMETERS.put("after", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("before", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("coincides", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("during", Arrays.asList(0, 1, 2, 4));
        CEP_OPERATORS_PARAMETERS.put("finishes", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("finishedby", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("includes", Arrays.asList(0, 1, 2, 4));
        CEP_OPERATORS_PARAMETERS.put("meets", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("metby", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("overlaps", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("overlappedby", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("starts", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("startedby", Arrays.asList(0, 1));
        this.fieldParametersType = new HashMap<String, String>();
        this.globalTypes = new HashMap<String, String>();
        this.dataEnumLists = new HashMap<String, String[]>();
        this.annotationsForTypes = new HashMap<String, List<ModelAnnotation>>();
        this.conditionDSLSentences = new DSLSentence[0];
        this.actionDSLSentences = new DSLSentence[0];
        this.keywordDSLItems = new DSLSentence[0];
        this.anyScopeDSLItems = new DSLSentence[0];
        this.methodInfos = new HashMap<String, List<MethodInfo>>();
        this.modelFields = new HashMap<String, ModelField[]>();
        this.filterModelFields = null;
        this.accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();
        this.factFilter = null;
        this.filteringFacts = true;
    }

    public String[] getConditionalElements() {
        return CONDITIONAL_ELEMENTS;
    }

    public DSLSentence[] getDSLConditions() {
        return this.conditionDSLSentences;
    }

    public DSLSentence[] getDSLActions() {
        return this.actionDSLSentences;
    }

    public String[] getConnectiveOperatorCompletions(String factType, String fieldName) {
        String fieldType = this.getFieldType(factType + "." + fieldName);
        if (fieldType == null) {
            return STANDARD_CONNECTIVES;
        }
        if (fieldName.equals(TYPE_THIS)) {
            if (this.isFactTypeAnEvent(factType)) {
                return SuggestionCompletionEngine.joinArrays(STANDARD_CONNECTIVES, SIMPLE_CEP_CONNECTIVES, COMPLEX_CEP_CONNECTIVES);
            }
            return STANDARD_CONNECTIVES;
        }
        if (fieldType.equals(TYPE_STRING)) {
            return STRING_CONNECTIVES;
        }
        if (fieldType.equals(TYPE_COMPARABLE) || fieldType.equals(TYPE_NUMERIC)) {
            return COMPARABLE_CONNECTIVES;
        }
        if (fieldType.equals(TYPE_DATE)) {
            return SuggestionCompletionEngine.joinArrays(COMPARABLE_CONNECTIVES, new String[][]{SIMPLE_CEP_CONNECTIVES});
        }
        if (fieldType.equals(TYPE_COLLECTION)) {
            return COLLECTION_CONNECTIVES;
        }
        return STANDARD_CONNECTIVES;
    }

    public String[] getFieldCompletions(String factType) {
        return this.getModelFields(factType);
    }

    public String[] getFieldCompletions(FieldAccessorsAndMutators accessorOrMutator, String factType) {
        return this.getModelFields(accessorOrMutator, factType);
    }

    public String[] getOperatorCompletions(String factType, String fieldName) {
        String fieldType = this.getFieldType(factType, fieldName);
        if (fieldType == null) {
            return STANDARD_OPERATORS;
        }
        if (fieldName.equals(TYPE_THIS)) {
            if (this.isFactTypeAnEvent(factType)) {
                return SuggestionCompletionEngine.joinArrays(STANDARD_OPERATORS, SIMPLE_CEP_OPERATORS, COMPLEX_CEP_OPERATORS);
            }
            return STANDARD_OPERATORS;
        }
        if (fieldType.equals(TYPE_STRING)) {
            return STRING_OPERATORS;
        }
        if (fieldType.equals(TYPE_COMPARABLE) || fieldType.equals(TYPE_NUMERIC)) {
            return COMPARABLE_OPERATORS;
        }
        if (fieldType.equals(TYPE_DATE)) {
            return SuggestionCompletionEngine.joinArrays(COMPARABLE_OPERATORS, new String[][]{SIMPLE_CEP_OPERATORS});
        }
        if (fieldType.equals(TYPE_COLLECTION)) {
            return COLLECTION_OPERATORS;
        }
        return STANDARD_OPERATORS;
    }

    public String[] getFieldCompletionsForGlobalVariable(String varName) {
        String type = this.getGlobalVariable(varName);
        return this.getModelFields(type);
    }

    public List<MethodInfo> getMethodInfosForGlobalVariable(String varName) {
        String type = this.getGlobalVariable(varName);
        return this.methodInfos.get(type);
    }

    private String[] toStringArray(Set<?> set) {
        String[] f = new String[set.size()];
        int i = 0;
        Iterator<?> iter = set.iterator();
        while (iter.hasNext()) {
            f[i] = iter.next().toString();
            ++i;
        }
        return f;
    }

    public DropDownData getEnums(String factType, CompositeFieldConstraint constraintList, String field) {
        if (field == null) {
            return null;
        }
        HashMap<String, String> currentValueMap = new HashMap<String, String>();
        if (constraintList != null && constraintList.constraints != null) {
            for (FieldConstraint con : constraintList.constraints) {
                if (!(con instanceof SingleFieldConstraint)) continue;
                SingleFieldConstraint sfc = (SingleFieldConstraint)con;
                String fieldName = sfc.getFieldName();
                currentValueMap.put(fieldName, sfc.getValue());
            }
        }
        return this.getEnums(factType, field, currentValueMap);
    }

    public DropDownData getEnums(String type, String field, FieldNature[] currentFieldNatures) {
        HashMap<String, String> currentValueMap = new HashMap<String, String>();
        if (currentFieldNatures != null) {
            for (FieldNature currentFieldNature : currentFieldNatures) {
                currentValueMap.put(currentFieldNature.getField(), currentFieldNature.getValue());
            }
        }
        return this.getEnums(type, field, currentValueMap);
    }

    public DropDownData getEnums(String type, String field, Map<String, String> currentValueMap) {
        Map<String, Object> dataEnumLookupFields = this.loadDataEnumLookupFields();
        if (!currentValueMap.isEmpty()) {
            Object _typeFields = dataEnumLookupFields.get(type + "." + field);
            if (_typeFields instanceof String) {
                DropDownData data;
                String typeFields = (String)_typeFields;
                String dataEnumListsKey = type + "." + field;
                boolean addOpeninColumn = true;
                String[] splitTypeFields = typeFields.split(",");
                for (int j = 0; j < splitTypeFields.length; ++j) {
                    String typeField = splitTypeFields[j];
                    for (Map.Entry<String, String> currentValueEntry : currentValueMap.entrySet()) {
                        String fieldName = currentValueEntry.getKey();
                        String fieldValue = currentValueEntry.getValue();
                        if (!fieldName.trim().equals(typeField.trim())) continue;
                        if (addOpeninColumn) {
                            dataEnumListsKey = dataEnumListsKey + "[";
                            addOpeninColumn = false;
                        }
                        dataEnumListsKey = dataEnumListsKey + typeField + "=" + fieldValue;
                        if (j == splitTypeFields.length - 1) continue;
                        dataEnumListsKey = dataEnumListsKey + ",";
                    }
                }
                if (!addOpeninColumn) {
                    dataEnumListsKey = dataEnumListsKey + "]";
                }
                if ((data = DropDownData.create(this.dataEnumLists.get(dataEnumListsKey))) != null) {
                    return data;
                }
            } else if (_typeFields != null) {
                String[] fieldsNeeded = (String[])_typeFields;
                String queryString = this.getQueryString(type, field, fieldsNeeded, this.dataEnumLists);
                String[] valuePairs = new String[fieldsNeeded.length];
                for (int i = 0; i < fieldsNeeded.length; ++i) {
                    for (Map.Entry<String, String> currentValueEntry : currentValueMap.entrySet()) {
                        String fieldName = currentValueEntry.getKey();
                        String fieldValue = currentValueEntry.getValue();
                        if (!fieldName.equals(fieldsNeeded[i])) continue;
                        valuePairs[i] = fieldsNeeded[i] + "=" + fieldValue;
                    }
                }
                if (valuePairs.length > 0 && valuePairs[0] != null) {
                    return DropDownData.create(queryString, valuePairs);
                }
            }
        }
        return DropDownData.create(this.getEnumValues(type, field));
    }

    String getQueryString(String factType, String field, String[] fieldsNeeded, Map<String, String[]> dataEnumLists) {
        for (String key : dataEnumLists.keySet()) {
            if (key.startsWith(factType + "." + field) && fieldsNeeded != null && key.contains("[")) {
                String[] values = key.substring(key.indexOf(91) + 1, key.lastIndexOf(93)).split(",");
                if (values.length != fieldsNeeded.length) continue;
                boolean fail = false;
                for (int i = 0; i < values.length; ++i) {
                    String b;
                    String a = values[i].trim();
                    if (a.equals(b = fieldsNeeded[i].trim())) continue;
                    fail = true;
                    break;
                }
                if (fail) continue;
                String[] qry = this.getDataEnumList(key);
                return qry[0];
            }
            if (!key.startsWith(factType + "." + field) || fieldsNeeded != null && fieldsNeeded.length != 0) continue;
            String[] qry = this.getDataEnumList(key);
            return qry[0];
        }
        throw new IllegalStateException();
    }

    public String[] getEnumValues(String factType, String field) {
        return this.getDataEnumList(factType + "." + field);
    }

    Map<String, Object> loadDataEnumLookupFields() {
        if (this.dataEnumLookupFields == null) {
            this.dataEnumLookupFields = new HashMap<String, Object>();
            Set<String> keys = this.dataEnumLists.keySet();
            for (String key : keys) {
                if (key.indexOf(91) == -1) continue;
                int ix = key.indexOf(91);
                String factField = key.substring(0, ix);
                String predicate = key.substring(ix + 1, key.indexOf(93));
                if (predicate.indexOf(61) > -1) {
                    String[] bits = predicate.split(",");
                    String typeField = "";
                    for (int i = 0; i < bits.length; ++i) {
                        typeField = typeField + bits[i].substring(0, bits[i].indexOf(61));
                        if (i == bits.length - 1) continue;
                        typeField = typeField + ",";
                    }
                    this.dataEnumLookupFields.put(factField, typeField);
                    continue;
                }
                String[] fields = predicate.split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = fields[i].trim();
                }
                this.dataEnumLookupFields.put(factField, fields);
            }
        }
        return this.dataEnumLookupFields;
    }

    public void addMethodInfo(String factName, List<MethodInfo> methodInfos) {
        this.methodInfos.put(factName, methodInfos);
    }

    public List<String> getMethodParams(String factName, String methodNameWithParams) {
        if (this.methodInfos.get(factName) != null) {
            List<MethodInfo> infos = this.methodInfos.get(factName);
            for (MethodInfo info : infos) {
                if (!info.getNameWithParameters().startsWith(methodNameWithParams)) continue;
                return info.getParams();
            }
        }
        return null;
    }

    public List<String> getMethodNames(String factName) {
        List<MethodInfo> infos = this.methodInfos.get(factName);
        ArrayList<String> methodList = new ArrayList<String>();
        if (infos != null) {
            for (MethodInfo info : infos) {
                methodList.add(info.getName());
            }
        }
        return methodList;
    }

    public MethodInfo getMethodinfo(String factName, String methodFullName) {
        List<MethodInfo> infos = this.methodInfos.get(factName);
        if (infos != null) {
            for (MethodInfo info : infos) {
                if (!info.getNameWithParameters().equals(methodFullName)) continue;
                return info;
            }
        }
        return null;
    }

    public String getMethodClassType(String factName, String methodFullName) {
        List<MethodInfo> infos = this.methodInfos.get(factName);
        if (infos != null) {
            for (MethodInfo info : infos) {
                if (!info.getNameWithParameters().equals(methodFullName)) continue;
                return info.getReturnClassType();
            }
        }
        return null;
    }

    public List<String> getMethodFullNames(String factName) {
        return this.getMethodFullNames(factName, -1);
    }

    public List<String> getMethodFullNames(String factName, int paramCount) {
        List<MethodInfo> infos = this.methodInfos.get(factName);
        ArrayList<String> methodList = new ArrayList<String>();
        if (infos != null) {
            for (MethodInfo info : infos) {
                if (paramCount != -1 && info.getParams().size() > paramCount) continue;
                methodList.add(info.getNameWithParameters());
            }
        }
        return methodList;
    }

    public String getFactNameFromType(String type) {
        if (type == null) {
            return null;
        }
        if (this.getModelFields().containsKey(type)) {
            return type;
        }
        for (Map.Entry<String, ModelField[]> entry : this.getModelFields().entrySet()) {
            for (ModelField mf : entry.getValue()) {
                if (!TYPE_THIS.equals(mf.getName()) || !type.equals(mf.getClassName())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public String getParametricFieldType(String factType, String fieldName) {
        return this.getParametricFieldType(factType + "." + fieldName);
    }

    public String getParametricFieldType(String fieldName) {
        return this.fieldParametersType.get(fieldName);
    }

    public void putParametricFieldType(String fieldName, String type) {
        this.fieldParametersType.put(fieldName, type);
    }

    public String getGlobalVariable(String name) {
        return this.globalTypes.get(name);
    }

    public boolean isGlobalVariable(String name) {
        return this.globalTypes.containsKey(name);
    }

    public void setGlobalVariables(Map<String, String> globalTypes) {
        this.globalTypes = globalTypes;
    }

    public String[] getGlobalVariables() {
        return this.toStringArray(this.globalTypes.keySet());
    }

    public void setModifiers(Map<String, String[]> map) {
        this.modifiers = map;
    }

    public String[] getModifiers(String name) {
        return this.modifiers.get(name);
    }

    public void setGlobalCollections(String[] globalCollections) {
        this.globalCollections = globalCollections;
    }

    public String[] getGlobalCollections() {
        return this.globalCollections;
    }

    public String[] getDataEnumList(String type) {
        return this.dataEnumLists.get(type);
    }

    public void setDataEnumLists(Map<String, String[]> data) {
        this.dataEnumLists = data;
    }

    public void putDataEnumList(String name, String[] value) {
        this.dataEnumLists.put(name, value);
    }

    public void putAllDataEnumLists(Map<String, String[]> value) {
        this.dataEnumLists.putAll(value);
    }

    public int getDataEnumListsSize() {
        return this.dataEnumLists.size();
    }

    public boolean hasDataEnumLists() {
        return this.dataEnumLists != null && this.dataEnumLists.size() > 0;
    }

    public void setAnnotationsForTypes(Map<String, List<ModelAnnotation>> annotationsForTypes) {
        this.annotationsForTypes = annotationsForTypes;
    }

    public void setFactTypes(String[] factTypes) {
        for (String factType : factTypes) {
            this.getModelFields().put(factType, new ModelField[0]);
        }
    }

    public void setFactTypeFilter(FactTypeFilter filter) {
        this.factFilter = filter;
        this.filterModelFields();
    }

    public void setFieldsForTypes(Map<String, ModelField[]> fieldsForType) {
        this.getModelFields().clear();
        this.getModelFields().putAll(fieldsForType);
    }

    public String[] getFactTypes() {
        Object[] types = this.getModelFields().keySet().toArray(new String[this.getModelFields().size()]);
        Arrays.sort(types);
        return types;
    }

    public List<ModelAnnotation> getAnnotationsForFactType(String factType) {
        return this.annotationsForTypes.get(factType);
    }

    public Map<String, List<ModelAnnotation>> getAnnotations() {
        return this.annotationsForTypes;
    }

    public boolean isFactTypeAnEvent(String factType) {
        List<ModelAnnotation> annotations = this.annotationsForTypes.get(factType);
        if (annotations == null || annotations.size() == 0) {
            return false;
        }
        for (ModelAnnotation ma : annotations) {
            if (!ma.getAnnotationName().equals(ANNOTATION_ROLE)) continue;
            for (String v : ma.getAnnotationValues().values()) {
                if (!v.equals(ANNOTATION_ROLE_EVENT)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsFactType(String modelClassName) {
        if (modelClassName.contains(".")) {
            modelClassName = modelClassName.substring(modelClassName.lastIndexOf(".") + 1);
        }
        return this.getModelFields().containsKey(modelClassName);
    }

    private ModelField getField(String modelClassName, String fieldName) {
        String shortName = this.getFactNameFromType(modelClassName);
        ModelField[] fields = this.getModelFields().get(shortName);
        if (fields == null) {
            return null;
        }
        for (ModelField modelField : fields) {
            if (!modelField.getName().equals(fieldName)) continue;
            return modelField;
        }
        return null;
    }

    public String[] getModelFields(FieldAccessorsAndMutators accessorOrMutator, String modelClassName) {
        String shortName = this.getFactNameFromType(modelClassName);
        if (!this.getModelFields().containsKey(shortName)) {
            return new String[0];
        }
        ModelField[] fields = this.getModelFields().get(shortName);
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            if (!FieldAccessorsAndMutators.compare(accessorOrMutator, this.accessorsAndMutators.get(shortName + "." + fieldName))) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    public String[] getModelFields(String modelClassName) {
        String shortName = this.getFactNameFromType(modelClassName);
        if (!this.getModelFields().containsKey(shortName)) {
            return new String[0];
        }
        ModelField[] fields = this.getModelFields().get(shortName);
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    public String getFieldClassName(String propertyName) {
        String[] split = propertyName.split("\\.");
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid format '" + propertyName + "'. It must be of type className.propertyName");
        }
        return this.getFieldClassName(split[0], split[1]);
    }

    public String getFieldClassName(String modelClassName, String fieldName) {
        ModelField field = this.getField(modelClassName, fieldName);
        return field == null ? null : field.getClassName();
    }

    public ModelField.FIELD_CLASS_TYPE getFieldClassType(String modelClassName, String fieldName) {
        ModelField field = this.getField(modelClassName, fieldName);
        return field == null ? null : field.getClassType();
    }

    public String getFieldType(String propertyName) {
        String[] split = propertyName.split("\\.", 3);
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid format '" + propertyName + "'. It must be of type className.propertyName");
        }
        return this.getFieldType(split[0], split[1]);
    }

    public String getFieldType(String modelClassName, String fieldName) {
        ModelField field = this.getField(modelClassName, fieldName);
        return field == null ? null : field.getType();
    }

    public void setAccessorsAndMutators(Map<String, FieldAccessorsAndMutators> accessorsAndMutators) {
        this.accessorsAndMutators = accessorsAndMutators;
    }

    public void setModelFields(Map<String, ModelField[]> modelFields) {
        this.modelFields = modelFields;
        this.filterModelFields();
    }

    private void filterModelFields() {
        if (this.factFilter != null) {
            this.filterModelFields = new HashMap<String, ModelField[]>();
            for (Map.Entry<String, ModelField[]> entry : this.modelFields.entrySet()) {
                if (this.factFilter.filter(entry.getKey())) continue;
                this.filterModelFields.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<String, ModelField[]> getModelFields() {
        if (this.factFilter != null && this.isFilteringFacts()) {
            return this.filterModelFields;
        }
        return this.modelFields;
    }

    public boolean isFilteringFacts() {
        return this.filteringFacts;
    }

    public void setFilteringFacts(boolean filterFacts) {
        this.filteringFacts = filterFacts;
    }

    public static boolean isCEPOperator(String operator) {
        if (operator == null) {
            return false;
        }
        String[] operators = SuggestionCompletionEngine.joinArrays(SIMPLE_CEP_OPERATORS, COMPLEX_CEP_OPERATORS, SIMPLE_CEP_CONNECTIVES, COMPLEX_CEP_CONNECTIVES);
        for (int i = 0; i < operators.length; ++i) {
            if (!operator.equals(operators[i])) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> getCEPOperatorParameterSets(String operator) {
        ArrayList<Integer> sets = new ArrayList<Integer>();
        if (operator == null) {
            return sets;
        }
        if (operator.startsWith("|| ") || operator.startsWith("&& ")) {
            operator = operator.substring(3);
        }
        if (!CEP_OPERATORS_PARAMETERS.containsKey(operator)) {
            return sets;
        }
        return CEP_OPERATORS_PARAMETERS.get(operator);
    }

    public static List<String> getCEPWindowOperators() {
        return Arrays.asList(WINDOW_CEP_OPERATORS);
    }

    public static boolean isCEPWindowOperator(String operator) {
        if (operator == null) {
            return false;
        }
        for (int i = 0; i < WINDOW_CEP_OPERATORS.length; ++i) {
            if (!operator.equals(WINDOW_CEP_OPERATORS[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isCEPWindowOperatorTime(String operator) {
        if (operator == null) {
            return false;
        }
        return WINDOW_CEP_OPERATORS[0].equals(operator);
    }

    public static boolean isCEPWindowOperatorLength(String operator) {
        if (operator == null) {
            return false;
        }
        return WINDOW_CEP_OPERATORS[1].equals(operator);
    }

    private static String[] joinArrays(String[] first, String[] ... others) {
        int totalLength = first.length;
        for (String[] other : others) {
            totalLength += other.length;
        }
        String[] result = new String[totalLength];
        System.arraycopy(first, 0, result, 0, first.length);
        int offset = first.length;
        for (String[] other : others) {
            System.arraycopy(other, 0, result, offset, other.length);
            offset += other.length;
        }
        return result;
    }
}

