/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleModel
implements PortableObject {
    public String name;
    public String parentName;
    public String modelVersion = "1.0";
    public RuleAttribute[] attributes = new RuleAttribute[0];
    public RuleMetadata[] metadataList = new RuleMetadata[0];
    public IPattern[] lhs = new IPattern[0];
    public IAction[] rhs = new IAction[0];
    private boolean isNegated;

    public List<String> getLHSBoundFacts() {
        if (this.lhs == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            FactPattern p;
            if (!(this.lhs[i] instanceof FactPattern) || (p = (FactPattern)this.lhs[i]).getBoundName() == null) continue;
            list.add(p.getBoundName());
        }
        return list;
    }

    public FactPattern getLHSBoundFact(String var) {
        if (this.lhs == null) {
            return null;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            FactPattern p;
            if (!(this.lhs[i] instanceof FactPattern) || (p = (FactPattern)this.lhs[i]).getBoundName() == null || !var.equals(p.getBoundName())) continue;
            return p;
        }
        return null;
    }

    public FieldConstraint getLHSBoundField(String var) {
        if (this.lhs == null) {
            return null;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            for (int j = 0; j < p.getFieldConstraints().length; ++j) {
                FieldConstraint fc = p.getFieldConstraints()[j];
                List<String> fieldBindings = this.getFieldBinding(fc);
                if (!fieldBindings.contains(var)) continue;
                return fc;
            }
        }
        return null;
    }

    public String getLHSBindingType(String var) {
        if (this.lhs == null) {
            return null;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            if (p.isBound() && var.equals(p.getBoundName())) {
                return p.getFactType();
            }
            for (FieldConstraint fc : p.getFieldConstraints()) {
                String type = this.getFieldBinding(fc, var);
                if (type == null) continue;
                return type;
            }
        }
        return null;
    }

    private String getFieldBinding(FieldConstraint fc, String var) {
        FieldConstraint s;
        String fieldType = null;
        if (fc instanceof SingleFieldConstraint && ((SingleFieldConstraint)(s = (SingleFieldConstraint)fc)).isBound() && var.equals(((SingleFieldConstraint)s).getFieldBinding())) {
            fieldType = ((SingleFieldConstraint)s).getFieldType();
        }
        if (fc instanceof SingleFieldConstraintEBLeftSide && ((SingleFieldConstraintEBLeftSide)(s = (SingleFieldConstraintEBLeftSide)fc)).isBound() && var.equals(((SingleFieldConstraintEBLeftSide)s).getFieldBinding())) {
            fieldType = ((SingleFieldConstraintEBLeftSide)s).getExpressionLeftSide().getGenericType();
        }
        if (fc instanceof CompositeFieldConstraint) {
            s = (CompositeFieldConstraint)fc;
            if (((CompositeFieldConstraint)s).constraints != null) {
                for (FieldConstraint ss : ((CompositeFieldConstraint)s).constraints) {
                    fieldType = this.getFieldBinding(ss, var);
                }
            }
        }
        return fieldType;
    }

    public List<String> getRHSBoundFacts() {
        if (this.rhs == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.rhs.length; ++i) {
            ActionInsertFact p;
            if (!(this.rhs[i] instanceof ActionInsertFact) || (p = (ActionInsertFact)this.rhs[i]).getBoundName() == null) continue;
            list.add(p.getBoundName());
        }
        return list;
    }

    public ActionInsertFact getRHSBoundFact(String var) {
        if (this.rhs == null) {
            return null;
        }
        for (int i = 0; i < this.rhs.length; ++i) {
            ActionInsertFact p;
            if (!(this.rhs[i] instanceof ActionInsertFact) || (p = (ActionInsertFact)this.rhs[i]).getBoundName() == null || !var.equals(p.getBoundName())) continue;
            return p;
        }
        return null;
    }

    public FactPattern getLHSParentFactPatternForBinding(String var) {
        if (this.lhs == null) {
            return null;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            if (!(this.lhs[i] instanceof FactPattern)) continue;
            FactPattern p = (FactPattern)this.lhs[i];
            if (p.getBoundName() != null && var.equals(p.getBoundName())) {
                return p;
            }
            for (int j = 0; j < p.getFieldConstraints().length; ++j) {
                FieldConstraint fc = p.getFieldConstraints()[j];
                List<String> fieldBindings = this.getFieldBinding(fc);
                if (!fieldBindings.contains(var)) continue;
                return p;
            }
        }
        return null;
    }

    public List<String> getAllVariables() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getAllLHSVariables());
        result.addAll(this.getAllRHSVariables());
        return result;
    }

    public List<String> getAllLHSVariables() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            IPattern pat = this.lhs[i];
            if (!(pat instanceof FactPattern)) continue;
            FactPattern fact = (FactPattern)pat;
            if (fact.isBound()) {
                result.add(fact.getBoundName());
            }
            for (int j = 0; j < fact.getFieldConstraints().length; ++j) {
                FieldConstraint fc = fact.getFieldConstraints()[j];
                if (fc instanceof SingleFieldConstraintEBLeftSide) {
                    SingleFieldConstraintEBLeftSide exp = (SingleFieldConstraintEBLeftSide)fc;
                    if (exp.getExpressionLeftSide() == null || !exp.getExpressionLeftSide().isBound()) continue;
                    result.add(exp.getExpressionLeftSide().getBinding());
                    continue;
                }
                if (!(fc instanceof SingleFieldConstraint)) continue;
                SingleFieldConstraint con = (SingleFieldConstraint)fc;
                if (con.isBound()) {
                    result.add(con.getFieldBinding());
                }
                if (con.getExpressionValue() == null || !con.getExpressionValue().isBound()) continue;
                result.add(con.getExpressionValue().getBinding());
            }
        }
        return result;
    }

    public List<String> getAllRHSVariables() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.rhs.length; ++i) {
            ActionInsertFact fact;
            IAction pat = this.rhs[i];
            if (!(pat instanceof ActionInsertFact) || !(fact = (ActionInsertFact)pat).isBound()) continue;
            result.add(fact.getBoundName());
        }
        return result;
    }

    private List<String> getFieldBinding(FieldConstraint f) {
        ArrayList<String> result = new ArrayList<String>();
        if (f instanceof SingleFieldConstraint) {
            SingleFieldConstraintEBLeftSide exp;
            SingleFieldConstraint con = (SingleFieldConstraint)f;
            if (con.isBound()) {
                result.add(con.getFieldBinding());
            }
            if (con.getExpressionValue() != null && con.getExpressionValue().isBound()) {
                result.add(con.getExpressionValue().getBinding());
            }
            if (con instanceof SingleFieldConstraintEBLeftSide && (exp = (SingleFieldConstraintEBLeftSide)con).getExpressionLeftSide() != null && exp.getExpressionLeftSide().isBound()) {
                result.add(exp.getExpressionLeftSide().getBinding());
            }
        } else if (f instanceof CompositeFieldConstraint) {
            CompositeFieldConstraint cfc = (CompositeFieldConstraint)f;
            if (cfc.constraints != null) {
                for (FieldConstraint ss : cfc.constraints) {
                    List<String> t = this.getFieldBinding(ss);
                    result.addAll(t);
                }
            }
        }
        return result;
    }

    public boolean removeLhsItem(int idx) {
        IPattern[] newList = new IPattern[this.lhs.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.lhs.length; ++i) {
            FactPattern p;
            if (i != idx) {
                newList[newIdx] = this.lhs[i];
                ++newIdx;
                continue;
            }
            if (!(this.lhs[i] instanceof FactPattern) || (p = (FactPattern)this.lhs[i]).getBoundName() == null || !this.isBoundFactUsed(p.getBoundName())) continue;
            return false;
        }
        this.lhs = newList;
        return true;
    }

    public boolean isBoundFactUsed(String binding) {
        if (this.rhs == null) {
            return false;
        }
        for (int i = 0; i < this.rhs.length; ++i) {
            if (this.rhs[i] instanceof ActionSetField) {
                ActionSetField set = (ActionSetField)this.rhs[i];
                if (!set.variable.equals(binding)) continue;
                return true;
            }
            if (!(this.rhs[i] instanceof ActionRetractFact)) continue;
            ActionRetractFact ret = (ActionRetractFact)this.rhs[i];
            if (!ret.variableName.equals(binding)) continue;
            return true;
        }
        return false;
    }

    public void addLhsItem(IPattern pat) {
        this.addLhsItem(pat, true);
    }

    public void addLhsItem(IPattern pat, boolean append) {
        this.addLhsItem(pat, append ? this.lhs.length : 0);
    }

    public void addLhsItem(IPattern pat, int position) {
        if (this.lhs == null) {
            this.lhs = new IPattern[0];
        }
        if (position < 0) {
            position = 0;
        } else if (position > this.lhs.length) {
            position = this.lhs.length;
        }
        IPattern[] list = this.lhs;
        IPattern[] newList = new IPattern[list.length + 1];
        for (int i = 0; i < newList.length; ++i) {
            newList[i] = i < position ? list[i] : (i > position ? list[i - 1] : pat);
        }
        this.lhs = newList;
    }

    public void moveLhsItemDown(int itemIndex) {
        if (this.lhs == null) {
            this.lhs = new IPattern[0];
        }
        this.moveItemDown(this.lhs, itemIndex);
    }

    public void moveLhsItemUp(int itemIndex) {
        if (this.lhs == null) {
            this.lhs = new IPattern[0];
        }
        this.moveItemUp(this.lhs, itemIndex);
    }

    public void moveRhsItemDown(int itemIndex) {
        if (this.rhs == null) {
            this.rhs = new IAction[0];
        }
        this.moveItemDown(this.rhs, itemIndex);
    }

    public void moveRhsItemUp(int itemIndex) {
        if (this.rhs == null) {
            this.rhs = new IAction[0];
        }
        this.moveItemUp(this.rhs, itemIndex);
    }

    private void moveItemDown(Object[] array, int itemIndex) {
        for (int i = 0; i < array.length; ++i) {
            if (i != itemIndex || array.length <= i + 1) continue;
            Object tmp = array[i + 1];
            array[i + 1] = array[i];
            array[i] = tmp;
            ++i;
        }
    }

    private void moveItemUp(Object[] array, int itemIndex) {
        if (itemIndex == 0) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            if (i != itemIndex) continue;
            Object tmp = array[i - 1];
            array[i - 1] = array[i];
            array[i] = tmp;
        }
    }

    public void addRhsItem(IAction action) {
        this.addRhsItem(action, true);
    }

    public void addRhsItem(IAction action, boolean append) {
        this.addRhsItem(action, append ? this.rhs.length : 0);
    }

    public void addRhsItem(IAction action, int position) {
        if (this.rhs == null) {
            this.rhs = new IAction[0];
        }
        if (position < 0) {
            position = 0;
        } else if (position > this.rhs.length) {
            position = this.rhs.length;
        }
        IAction[] list = this.rhs;
        IAction[] newList = new IAction[list.length + 1];
        for (int i = 0; i < newList.length; ++i) {
            newList[i] = i < position ? list[i] : (i > position ? list[i - 1] : action);
        }
        this.rhs = newList;
    }

    public void removeRhsItem(int idx) {
        IAction[] newList = new IAction[this.rhs.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.rhs.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.rhs[i];
            ++newIdx;
        }
        this.rhs = newList;
    }

    public void addAttribute(RuleAttribute attribute) {
        RuleAttribute[] list = this.attributes;
        RuleAttribute[] newList = new RuleAttribute[list.length + 1];
        for (int i = 0; i < list.length; ++i) {
            newList[i] = list[i];
        }
        newList[list.length] = attribute;
        this.attributes = newList;
    }

    public void removeAttribute(int idx) {
        RuleAttribute[] newList = new RuleAttribute[this.attributes.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.attributes[i];
            ++newIdx;
        }
        this.attributes = newList;
    }

    public void addMetadata(RuleMetadata metadata) {
        RuleMetadata[] newList = new RuleMetadata[this.metadataList.length + 1];
        for (int i = 0; i < this.metadataList.length; ++i) {
            newList[i] = this.metadataList[i];
        }
        newList[this.metadataList.length] = metadata;
        this.metadataList = newList;
    }

    public void removeMetadata(int idx) {
        RuleMetadata[] newList = new RuleMetadata[this.metadataList.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.metadataList.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.metadataList[i];
            ++newIdx;
        }
        this.metadataList = newList;
    }

    public RuleMetadata getMetaData(String attributeName) {
        if (this.metadataList != null && attributeName != null) {
            for (int i = 0; i < this.metadataList.length; ++i) {
                if (!attributeName.equals(this.metadataList[i].attributeName)) continue;
                return this.metadataList[i];
            }
        }
        return null;
    }

    public boolean updateMetadata(RuleMetadata target) {
        RuleMetadata metaData = this.getMetaData(target.attributeName);
        if (metaData != null) {
            metaData.value = target.value;
            return true;
        }
        this.addMetadata(target);
        return false;
    }

    public List<String> getBoundVariablesInScope(BaseSingleFieldConstraint con) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            IPattern pat = this.lhs[i];
            if (!(pat instanceof FactPattern)) continue;
            FactPattern fact = (FactPattern)pat;
            if (fact.constraintList != null) {
                FieldConstraint[] cons = fact.constraintList.constraints;
                if (cons != null) {
                    for (int k = 0; k < cons.length; ++k) {
                        FieldConstraint fc = cons[k];
                        if (!(fc instanceof SingleFieldConstraint)) continue;
                        SingleFieldConstraint c = (SingleFieldConstraint)fc;
                        if (c == con) {
                            return result;
                        }
                        if (c.connectives != null) {
                            for (int j = 0; j < c.connectives.length; ++j) {
                                if (con != c.connectives[j]) continue;
                                return result;
                            }
                        }
                        if (!c.isBound()) continue;
                        result.add(c.getFieldBinding());
                    }
                }
                if (!fact.isBound()) continue;
                result.add(fact.getBoundName());
                continue;
            }
            if (!fact.isBound()) continue;
            result.add(fact.getBoundName());
        }
        return result;
    }

    public boolean isVariableNameUsed(String s) {
        return this.getAllVariables().contains(s);
    }

    public boolean hasDSLSentences() {
        if (this.lhs != null) {
            for (PortableObject portableObject : this.lhs) {
                if (!(portableObject instanceof DSLSentence)) continue;
                return true;
            }
        }
        if (this.rhs != null) {
            for (PortableObject portableObject : this.rhs) {
                if (!(portableObject instanceof DSLSentence)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public void setNegated(boolean isNegated) {
        this.isNegated = isNegated;
    }
}

