/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLSentence
implements IPattern,
IAction {
    public static final String ENUM_TAG = "ENUM";
    public static final String DATE_TAG = "DATE";
    public static final String BOOLEAN_TAG = "BOOLEAN";
    private String sentence;
    private String definition;
    private List<String> values;

    public String toString() {
        this.getDefinition();
        StringBuilder result = new StringBuilder(this.definition);
        int variableStart = this.definition.indexOf("{");
        while (variableStart >= 0) {
            int variableEnd = this.getIndexForEndOfVariable(result.toString(), variableStart);
            String variable = result.substring(variableStart + 1, variableEnd);
            int variableNameEnd = variable.indexOf(":");
            if (variableNameEnd == -1) {
                variableNameEnd = variable.length();
            }
            String variableName = variable.substring(0, variableNameEnd);
            result.replace(variableStart + 1, variableEnd, variableName);
            variableEnd = variableEnd - variable.length() + variableName.length();
            variableStart = result.indexOf("{", variableEnd);
        }
        return result.toString().replace("\\n", "\n");
    }

    public String interpolate() {
        this.getValues();
        if (this.definition == null) {
            return "";
        }
        int variableStart = this.definition.indexOf("{");
        if (variableStart < 0) {
            return this.definition;
        }
        int index = 0;
        int variableEnd = 0;
        StringBuilder sb = new StringBuilder();
        while (variableStart >= 0) {
            sb.append(this.definition.substring(variableEnd, variableStart));
            variableEnd = this.getIndexForEndOfVariable(this.definition, variableStart) + 1;
            variableStart = this.definition.indexOf("{", variableEnd);
            sb.append(this.values.get(index++));
        }
        if (variableEnd < this.definition.length()) {
            sb.append(this.definition.substring(variableEnd));
        }
        return sb.toString();
    }

    public DSLSentence copy() {
        DSLSentence newOne = new DSLSentence();
        newOne.definition = this.getDefinition();
        List<String> values = this.getValues();
        if (values != null) {
            for (String value : this.getValues()) {
                newOne.getValues().add(value);
            }
        }
        return newOne;
    }

    public String getDefinition() {
        if (this.definition == null) {
            this.parseSentence();
        }
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public List<String> getValues() {
        if (this.values == null) {
            this.parseDefinition();
        }
        return this.values;
    }

    public Map<String, String> getEnumFieldValueMap() {
        if (this.values == null) {
            this.parseDefinition();
        }
        HashMap<String, String> fieldValueMap = new HashMap<String, String>();
        if (this.getValues().isEmpty()) {
            return fieldValueMap;
        }
        int variableStart = this.definition.indexOf("{");
        int iVariable = 0;
        while (variableStart >= 0) {
            int variableEnd = this.getIndexForEndOfVariable(this.definition, variableStart);
            String variable = this.definition.substring(variableStart + 1, variableEnd);
            if (variable.contains(ENUM_TAG)) {
                int lastIndex = variable.lastIndexOf(":");
                String factAndField = variable.substring(lastIndex + 1, variable.length());
                int dotIndex = factAndField.indexOf(".");
                String field = factAndField.substring(dotIndex + 1, factAndField.length());
                fieldValueMap.put(field, this.values.get(iVariable));
            }
            ++iVariable;
            variableStart = this.definition.indexOf("{", variableEnd);
        }
        return fieldValueMap;
    }

    private void parseSentence() {
        if (this.sentence == null) {
            return;
        }
        this.definition = this.sentence;
        this.values = new ArrayList<String>();
        this.sentence = null;
        int variableStart = this.definition.indexOf("{");
        while (variableStart >= 0) {
            int variableEnd = this.getIndexForEndOfVariable(this.definition, variableStart);
            String variable = this.definition.substring(variableStart + 1, variableEnd);
            this.values.add(this.parseValue(variable));
            variableStart = this.definition.indexOf("{", variableEnd);
        }
    }

    private void parseDefinition() {
        this.values = new ArrayList<String>();
        if (this.getDefinition() == null) {
            return;
        }
        int variableStart = this.definition.indexOf("{");
        while (variableStart >= 0) {
            int variableEnd = this.getIndexForEndOfVariable(this.definition, variableStart);
            String variable = this.definition.substring(variableStart + 1, variableEnd);
            this.values.add(this.parseValue(variable));
            variableStart = this.definition.indexOf("{", variableEnd);
        }
    }

    private int getIndexForEndOfVariable(String dsl, int start) {
        int end = -1;
        int bracketCount = 0;
        if (start > dsl.length()) {
            return end;
        }
        for (int i = start; i < dsl.length(); ++i) {
            char c = dsl.charAt(i);
            if (c == '{') {
                ++bracketCount;
            }
            if (c != '}' || --bracketCount != 0) continue;
            end = i;
            return end;
        }
        return -1;
    }

    private String parseValue(String variable) {
        if (!variable.contains(":")) {
            return variable;
        }
        String value = variable.substring(0, variable.indexOf(":"));
        return value;
    }
}

