/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.ArrayList;
import java.util.HashSet;
import org.drools.Cheese;
import org.drools.StatefulSession;
import org.drools.event.AgendaEventListener;
import org.drools.testframework.RuleUnit;
import org.drools.testframework.TestingEventListener;
import org.junit.Assert;
import org.junit.Test;

public class TestingEventListenerTest
extends RuleUnit {
    @Test
    public void testInclusive() throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add("rule1");
        set.add("rule2");
        StatefulSession session = this.getWorkingMemory("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, true));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule4"));
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, true));
        Assert.assertEquals((Object)new Integer(2), (Object)((Integer)ls.firingCounts.get("rule1")));
        Assert.assertEquals((Object)new Integer(2), (Object)((Integer)ls.firingCounts.get("rule2")));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        Assert.assertEquals((long)4L, (long)ls.totalFires);
    }

    @Test
    public void testExclusive() throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add("rule3");
        StatefulSession session = this.getWorkingMemory("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, false));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        Assert.assertFalse((boolean)ls.firingCounts.containsKey("rule4"));
    }

    @Test
    public void testNoFilter() throws Exception {
        HashSet set = new HashSet();
        StatefulSession session = this.getWorkingMemory("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules(ls.getAgendaFilter(set, false));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule3")));
        String[] summary = ls.getRulesFiredSummary();
        Assert.assertEquals((long)3L, (long)summary.length);
        Assert.assertNotNull((Object)summary[0]);
        Assert.assertFalse((boolean)summary[1].equals(""));
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

