/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.dt;

import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.junit.Assert;
import org.junit.Test;

public class BRLRuleModelTest {
    @Test
    public void testOnlyDecisionTableColumns() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)3L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
    }

    @Test
    public void testDecisionTableColumnsWithLHS() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)5L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$brl1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$sfc1"));
    }

    @Test
    public void testDecisionTableColumnsWithLHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getLHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getLHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$p1"));
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$brl1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$p1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$p1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$brl1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$brl1"));
        FactPattern r1 = model.getLHSBoundFact("$p1");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof BRLRuleModel.Pattern52FactPatternAdaptor));
        BRLRuleModel.Pattern52FactPatternAdaptor raif1 = (BRLRuleModel.Pattern52FactPatternAdaptor)r1;
        Assert.assertEquals((Object)"Driver", (Object)raif1.getFactType());
        FactPattern r2 = model.getLHSBoundFact("$brl1");
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((Object)"Driver", (Object)r2.getFactType());
    }

    @Test
    public void testDecisionTableColumnsWithLHSBoundFields() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        FieldConstraint fcr1 = model.getLHSBoundField("$sfc1");
        Assert.assertNotNull((Object)fcr1);
        Assert.assertTrue((boolean)(fcr1 instanceof SingleFieldConstraint));
        SingleFieldConstraint fcr1sfc = (SingleFieldConstraint)fcr1;
        Assert.assertEquals((Object)"name", (Object)fcr1sfc.getFieldName());
        Assert.assertEquals((Object)"String", (Object)fcr1sfc.getFieldType());
    }

    @Test
    public void testDecisionTableColumnsWithRHS() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif = new ActionInsertFact("Person");
        aif.setBoundName("$aif");
        aif.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif.fieldValues[0].nature = 1L;
        brlAction.getDefinition().add(aif);
        dt.getActionCols().add(brlAction);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)4L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$aif"));
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof BRLRuleModel.ActionInsertFactCol52ActionInsertFactAdaptor));
        BRLRuleModel.ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (BRLRuleModel.ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.factType);
        Assert.assertEquals((Object)"rating", (Object)raif1.fieldValues[0].field);
        Assert.assertEquals((Object)"String", (Object)raif1.fieldValues[0].type);
        Assert.assertNull((Object)raif1.fieldValues[0].value);
        Assert.assertEquals((long)1L, (long)raif1.fieldValues[0].nature);
        ActionInsertFact r2 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFact));
        ActionInsertFact raif2 = r2;
        Assert.assertEquals((Object)"Person", (Object)raif2.factType);
        Assert.assertEquals((Object)"rating", (Object)raif2.fieldValues[0].field);
        Assert.assertEquals((Object)"String", (Object)raif2.fieldValues[0].type);
        Assert.assertNull((Object)raif2.fieldValues[0].value);
        Assert.assertEquals((long)1L, (long)raif2.fieldValues[0].nature);
    }

    @Test
    public void testDecisionTableColumnsWithRHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        ActionInsertFactCol52 ins2 = new ActionInsertFactCol52();
        ins2.setInsertLogical(true);
        ins2.setBoundName("$ins2");
        ins2.setFactField("rating2");
        ins2.setFactType("Person2");
        ins2.setType("String");
        dt.getActionCols().add(ins2);
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif = new ActionInsertFact("Person");
        aif.setBoundName("$aif");
        aif.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif.fieldValues[0].nature = 1L;
        brlAction.getDefinition().add(aif);
        dt.getActionCols().add(brlAction);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)3L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins2"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof BRLRuleModel.ActionInsertFactCol52ActionInsertFactAdaptor));
        BRLRuleModel.ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (BRLRuleModel.ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.factType);
        Assert.assertEquals((Object)"rating", (Object)raif1.fieldValues[0].field);
        Assert.assertEquals((Object)"String", (Object)raif1.fieldValues[0].type);
        Assert.assertNull((Object)raif1.fieldValues[0].value);
        Assert.assertEquals((long)1L, (long)raif1.fieldValues[0].nature);
        ActionInsertFact r2 = model.getRHSBoundFact("$ins2");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof BRLRuleModel.ActionInsertFactCol52ActionInsertLogicalFactAdaptor));
        BRLRuleModel.ActionInsertFactCol52ActionInsertLogicalFactAdaptor raif2 = (BRLRuleModel.ActionInsertFactCol52ActionInsertLogicalFactAdaptor)r2;
        Assert.assertEquals((Object)"Person2", (Object)raif2.factType);
        Assert.assertEquals((Object)"rating2", (Object)raif2.fieldValues[0].field);
        Assert.assertEquals((Object)"String", (Object)raif2.fieldValues[0].type);
        Assert.assertNull((Object)raif2.fieldValues[0].value);
        Assert.assertEquals((long)1L, (long)raif2.fieldValues[0].nature);
        ActionInsertFact r3 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r3);
        Assert.assertTrue((boolean)(r3 instanceof ActionInsertFact));
        ActionInsertFact raif3 = r3;
        Assert.assertEquals((Object)"Person", (Object)raif3.factType);
        Assert.assertEquals((Object)"rating", (Object)raif3.fieldValues[0].field);
        Assert.assertEquals((Object)"String", (Object)raif3.fieldValues[0].type);
        Assert.assertNull((Object)raif3.fieldValues[0].value);
        Assert.assertEquals((long)1L, (long)raif3.fieldValues[0].nature);
    }
}

