/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.CompositeColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.server.util.BRLPersistenceTest;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;
import org.drools.ide.common.server.util.GuidedDecisionTableModelUpgradeHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GuidedDTXMLPersistenceTest {
    private GuidedDecisionTableModelUpgradeHelper upgrader = new GuidedDecisionTableModelUpgradeHelper();

    @Before
    public void setUp() throws Exception {
        GuidedDTXMLPersistence.getInstance();
    }

    @Test
    public void testRoundTrip() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.getActionCols().add(new ActionInsertFactCol52());
        ActionSetFieldCol52 set = new ActionSetFieldCol52();
        set.setFactField("foo");
        dt.getActionCols().add(set);
        dt.getMetadataCols().add(new MetadataCol52());
        dt.getAttributeCols().add(new AttributeCol52());
        Pattern52 p = new Pattern52();
        ConditionCol52 c = new ConditionCol52();
        p.getChildColumns().add(c);
        dt.getConditions().add(p);
        dt.setData(this.upgrader.makeDataLists((Object[][])new String[][]{{"1", "hola"}}));
        dt.setTableName("blah");
        String xml = GuidedDTXMLPersistence.getInstance().marshal(dt);
        System.out.println(xml);
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((long)-1L, (long)xml.indexOf("ActionSetField"));
        Assert.assertEquals((long)-1L, (long)xml.indexOf("ConditionCol"));
        Assert.assertEquals((long)-1L, (long)xml.indexOf("GuidedDecisionTable"));
        GuidedDecisionTable52 dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)dt_);
        Assert.assertEquals((Object)"blah", (Object)dt_.getTableName());
        Assert.assertEquals((long)1L, (long)dt_.getMetadataCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getAttributeCols().size());
        Assert.assertEquals((long)2L, (long)dt_.getActionCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getConditions().size());
        Assert.assertEquals((long)1L, (long)((CompositeColumn)dt_.getConditions().get(0)).getChildColumns().size());
    }

    @Test
    public void testBackwardsCompatability() throws Exception {
        String xml = BRLPersistenceTest.loadResource("ExistingDecisionTable.xml");
        GuidedDecisionTable52 dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)dt_);
        Assert.assertEquals((Object)"blah", (Object)dt_.getTableName());
        Assert.assertEquals((long)1L, (long)dt_.getMetadataCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getAttributeCols().size());
        Assert.assertEquals((long)2L, (long)dt_.getActionCols().size());
        Assert.assertEquals((long)1L, (long)dt_.getConditions().size());
        Assert.assertEquals((long)1L, (long)((CompositeColumn)dt_.getConditions().get(0)).getChildColumns().size());
        Assert.assertTrue((boolean)(dt_.getActionCols().get(1) instanceof ActionSetFieldCol52));
        ActionSetFieldCol52 asf = (ActionSetFieldCol52)dt_.getActionCols().get(1);
        Assert.assertEquals((Object)"foo", (Object)asf.getFactField());
        Assert.assertEquals((Object)false, (Object)asf.isUpdate());
    }
}

