/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.rules;

import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.base.ClassTypeResolver;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.ClassToGenericClassConverter;
import org.drools.ide.common.server.util.ClassMethodInspector;
import org.drools.ide.common.server.util.DataEnumLoader;
import org.drools.ide.common.server.util.SuggestionCompletionEngineBuilder;
import org.drools.lang.descr.AnnotationDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.rule.MapBackedClassLoader;

public class SuggestionCompletionLoader
implements ClassToGenericClassConverter {
    private final SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();
    private final MapBackedClassLoader loader;
    private final List<String> errors = new ArrayList<String>();
    private final ClassTypeResolver resolver;
    private PackageDescr pkgDescr;
    private List<ExternalImportDescrProvider> externalImportDescrProviders = new ArrayList<ExternalImportDescrProvider>();

    public SuggestionCompletionLoader() {
        this(null);
    }

    public SuggestionCompletionLoader(ClassLoader classLoader) {
        this.loader = this.getMapBackedClassLoader(classLoader);
        this.resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)this.loader);
    }

    private MapBackedClassLoader getMapBackedClassLoader(ClassLoader classLoader) {
        MapBackedClassLoader mapBackedClassLoader = new MapBackedClassLoader(this.createClassLoader(classLoader));
        return mapBackedClassLoader;
    }

    private ClassLoader createClassLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List<JarInputStream> jars, List<DSLTokenizedMappingFile> dsls) {
        return this.getSuggestionEngine(header, jars, dsls, Collections.<String>emptyList());
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List<JarInputStream> jars, List<DSLTokenizedMappingFile> dsls, List<String> dataEnums) {
        this.builder.newCompletionEngine();
        if (this.headerNotEmpty(header)) {
            this.processPackageHeader(header, jars);
        }
        this.populateDSLSentences(dsls);
        this.populateDateEnums(dataEnums);
        return this.builder.getInstance();
    }

    private void populateDateEnums(List<String> dataEnums) {
        for (String enumFile : dataEnums) {
            DataEnumLoader enumLoader = new DataEnumLoader(enumFile);
            if (enumLoader.hasErrors()) {
                this.errors.addAll(enumLoader.getErrors());
                continue;
            }
            this.builder.addAllDataEnumsList(enumLoader.getData());
        }
    }

    private boolean headerNotEmpty(String header) {
        return !header.trim().equals("");
    }

    private void processPackageHeader(String header, List jars) {
        DrlParser parser = this.getParser(header);
        this.logErrors(parser);
        this.populateEngineBuilder(jars);
    }

    private void populateEngineBuilder(List jars) {
        if (this.thereWasNoErrorsAndPackageDescrWasCreated()) {
            this.populateModelInfo(jars);
            this.populateDeclaredFactTypes(jars);
            this.populateGlobalInfo(jars);
        }
    }

    private void logErrors(DrlParser parser) {
        if (parser.hasErrors()) {
            for (DroolsError droolsError : parser.getErrors()) {
                this.errors.add(droolsError.getMessage());
            }
        }
    }

    private DrlParser getParser(String header) {
        DrlParser parser = new DrlParser();
        try {
            this.pkgDescr = parser.parse(header);
        }
        catch (DroolsParserException e1) {
            throw new IllegalStateException("Serious error, unable to validate package.");
        }
        return parser;
    }

    private boolean thereWasNoErrorsAndPackageDescrWasCreated() {
        return this.pkgDescr != null;
    }

    private void populateDSLSentences(List<DSLTokenizedMappingFile> dsls) {
        for (DSLTokenizedMappingFile file : dsls) {
            for (DSLMappingEntry entry : file.getMapping().getEntries()) {
                if (entry.getSection() == DSLMappingEntry.CONDITION) {
                    this.builder.addDSLConditionSentence(entry.getMappingKey());
                    continue;
                }
                if (entry.getSection() == DSLMappingEntry.CONSEQUENCE) {
                    this.builder.addDSLActionSentence(entry.getMappingKey());
                    continue;
                }
                if (entry.getSection() == DSLMappingEntry.KEYWORD) {
                    this.builder.addDSLMapping(entry);
                    continue;
                }
                if (entry.getSection() != DSLMappingEntry.ANY) continue;
                this.builder.addDSLConditionSentence(entry.getMappingKey());
                this.builder.addDSLActionSentence(entry.getMappingKey());
            }
        }
    }

    private void populateGlobalInfo(List jars) {
        for (GlobalDescr global : this.pkgDescr.getGlobals()) {
            try {
                String shortTypeName = this.getShortNameOfClass(global.getType());
                Class clazz = this.loadClass(global.getType(), jars);
                if (!this.builder.hasFieldsForType(shortTypeName)) {
                    this.loadClassFields(clazz, shortTypeName);
                    this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
                }
                if (this.implementsCollection(clazz)) {
                    this.builder.addGlobalCollection(global.getIdentifier());
                }
                this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting class for global: " + global.getType() + " error message: " + e.getMessage());
            }
        }
    }

    private boolean implementsCollection(Class<?> clazz) {
        return clazz != null && Collection.class.isAssignableFrom(clazz);
    }

    private void populateModelInfo(List<?> jars) {
        ArrayList<ImportDescr> imports = new ArrayList<ImportDescr>(this.pkgDescr.getImports());
        this.addAnyExternalImports(imports);
        for (ImportDescr importDescr : imports) {
            String className = importDescr.getTarget();
            try {
                this.addImport(className);
                this.addFactType(jars, className);
            }
            catch (WildCardException e) {
                this.errors.add(String.format("Unable to introspect model for wild card imports (%s). Please explicitly import each fact type you require.", className));
            }
        }
    }

    private void populateDeclaredFactTypes(List<?> jars) {
        for (TypeDeclarationDescr baseType : this.pkgDescr.getTypeDeclarations()) {
            List<TypeDeclarationDescr> th = this.getDeclaredTypeHierachy(baseType, jars);
            this.populateDeclaredFactType(th);
        }
    }

    private List<TypeDeclarationDescr> getDeclaredTypeHierachy(TypeDeclarationDescr td, List<?> jars) {
        TypeDeclarationDescr std;
        ArrayList<TypeDeclarationDescr> th = new ArrayList<TypeDeclarationDescr>();
        th.add(td);
        while ((std = this.getDeclaredSuperType(td)) != null) {
            th.add(std);
            td = std;
        }
        if (this.pkgDescr.getImports().size() > 0) {
            for (ImportDescr imp : this.pkgDescr.getImports()) {
                TypeDeclarationDescr pseudoTypeDeclr;
                if (!imp.getTarget().endsWith("." + td.getTypeName()) || (pseudoTypeDeclr = this.makePseudoTypeDeclarationDescrFromSuperClassType(imp.getTarget(), jars)) == null) continue;
                th.add(pseudoTypeDeclr);
            }
        }
        return th;
    }

    private TypeDeclarationDescr getDeclaredSuperType(TypeDeclarationDescr td) {
        String declaredSuperTypeName = td.getSuperTypeName();
        if (declaredSuperTypeName == null) {
            return null;
        }
        for (TypeDeclarationDescr std : this.pkgDescr.getTypeDeclarations()) {
            if (!declaredSuperTypeName.equals(std.getTypeName())) continue;
            return std;
        }
        return null;
    }

    private TypeDeclarationDescr makePseudoTypeDeclarationDescrFromSuperClassType(String className, List<?> jars) {
        Class clazz = this.loadClass(className, jars);
        if (clazz != null) {
            Method[] methods = clazz.getMethods();
            Map<String, MethodSignature> methodSignatures = this.getMethodSignatures(className, methods);
            TypeDeclarationDescr td = new TypeDeclarationDescr();
            td.setTypeName(className);
            for (Map.Entry<String, MethodSignature> e : methodSignatures.entrySet()) {
                if (e.getValue().accessorAndMutator != FieldAccessorsAndMutators.BOTH) continue;
                String fieldShortName = this.getShortNameOfClass(e.getKey());
                TypeFieldDescr fieldDescr = new TypeFieldDescr(fieldShortName);
                PatternDescr patternDescr = new PatternDescr(e.getValue().returnType.getName());
                fieldDescr.setPattern(patternDescr);
                td.addField(fieldDescr);
            }
            return td;
        }
        return null;
    }

    private void populateDeclaredFactType(List<TypeDeclarationDescr> th) {
        String declaredType = th.get(0).getTypeName();
        Set<String> declaredTypes = this.getDeclaredTypes(this.pkgDescr);
        HashMap<String, FieldAccessorsAndMutators> accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();
        HashMap<String, Map<String, String>> annotations = new HashMap<String, Map<String, String>>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("this");
        this.builder.addFieldType(declaredType + "." + "this", declaredType, null);
        accessorsAndMutators.put(declaredType + "." + "this", FieldAccessorsAndMutators.ACCESSOR);
        for (TypeDeclarationDescr typeDeclarationDescr : th) {
            for (String string : typeDeclarationDescr.getAnnotationNames()) {
                AnnotationDescr annotation = typeDeclarationDescr.getAnnotation(string);
                annotations.put(string, annotation.getValues());
            }
            if (!this.typeDeclarationDescrHasFields(typeDeclarationDescr)) continue;
            this.builder.addFactType(declaredType, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS);
            for (Map.Entry entry : typeDeclarationDescr.getFields().entrySet()) {
                String fieldName = (String)entry.getKey();
                fieldNames.add(fieldName);
                String factField = declaredType + "." + fieldName;
                accessorsAndMutators.put(factField, FieldAccessorsAndMutators.BOTH);
                String fieldClass = ((TypeFieldDescr)entry.getValue()).getPattern().getObjectType();
                if (declaredTypes.contains(fieldClass)) {
                    this.builder.addFieldType(declaredType + "." + fieldName, fieldClass, null);
                    continue;
                }
                try {
                    Class clz = this.resolver.resolveType(fieldClass);
                    this.builder.addFieldType(declaredType + "." + fieldName, this.translateClassToGenericType(clz), clz);
                }
                catch (ClassNotFoundException e) {
                    this.errors.add("Class of field not found: " + fieldClass);
                }
            }
        }
        this.builder.addAnnotationsForType(declaredType, annotations);
        this.builder.addFieldsForType(declaredType, fieldNames.toArray(new String[fieldNames.size()]));
        this.builder.addFieldAccessorsAndMutatorsForField(accessorsAndMutators);
    }

    private Map<String, MethodSignature> getMethodSignatures(String className, Method[] methods) {
        HashMap<String, MethodSignature> methodSignatures = new HashMap<String, MethodSignature>();
        for (Method method : methods) {
            MethodSignature signature;
            String factField;
            boolean addMethod = false;
            String name = method.getName();
            if (method.getParameterTypes().length > 0) {
                if (name.startsWith("set")) {
                    addMethod = true;
                    name = Introspector.decapitalize(name.substring(3));
                }
                if (!addMethod) continue;
                factField = className + "." + name;
                if (!methodSignatures.containsKey(factField)) {
                    methodSignatures.put(factField, new MethodSignature(FieldAccessorsAndMutators.MUTATOR, Void.TYPE.getGenericSuperclass(), Void.TYPE));
                    continue;
                }
                if (((MethodSignature)methodSignatures.get((Object)factField)).accessorAndMutator != FieldAccessorsAndMutators.ACCESSOR) continue;
                signature = (MethodSignature)methodSignatures.get(factField);
                signature.accessorAndMutator = FieldAccessorsAndMutators.BOTH;
                continue;
            }
            if (method.getReturnType().equals("void")) continue;
            if (name.startsWith("get")) {
                addMethod = true;
                name = Introspector.decapitalize(name.substring(3));
            } else if (name.startsWith("is")) {
                addMethod = true;
                name = Introspector.decapitalize(name.substring(2));
            }
            if (!addMethod) continue;
            factField = className + "." + name;
            if (!methodSignatures.containsKey(factField)) {
                methodSignatures.put(factField, new MethodSignature(FieldAccessorsAndMutators.ACCESSOR, method.getGenericReturnType(), method.getReturnType()));
                continue;
            }
            if (((MethodSignature)methodSignatures.get((Object)factField)).accessorAndMutator != FieldAccessorsAndMutators.MUTATOR) continue;
            signature = (MethodSignature)methodSignatures.get(factField);
            signature.accessorAndMutator = FieldAccessorsAndMutators.BOTH;
        }
        return methodSignatures;
    }

    private Map<String, FieldAccessorsAndMutators> extractFieldAccessorsAndMutators(Map<String, MethodSignature> methodSignatures) {
        HashMap<String, FieldAccessorsAndMutators> accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();
        for (Map.Entry<String, MethodSignature> e : methodSignatures.entrySet()) {
            accessorsAndMutators.put(e.getKey(), e.getValue().accessorAndMutator);
        }
        return accessorsAndMutators;
    }

    private boolean typeDeclarationDescrHasFields(TypeDeclarationDescr typeDeclarationDescr) {
        return typeDeclarationDescr.getFields().size() > 0;
    }

    private Set<String> getDeclaredTypes(PackageDescr pkgDescr) {
        HashSet<String> declaredTypes = new HashSet<String>();
        for (TypeDeclarationDescr typeDeclarationDescr : pkgDescr.getTypeDeclarations()) {
            declaredTypes.add(typeDeclarationDescr.getTypeName());
        }
        return declaredTypes;
    }

    private void addImport(String className) throws WildCardException {
        if (this.isWildCardImport(className)) {
            throw new WildCardException();
        }
        this.resolver.addImport(className);
    }

    private void addFactType(List jars, String className) {
        Class clazz = this.loadClass(className, jars);
        if (clazz != null) {
            try {
                String shortTypeName = this.getShortNameOfClass(clazz.getName());
                this.builder.addFactType(shortTypeName, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS);
                this.loadClassFields(clazz, shortTypeName);
            }
            catch (IOException e) {
                this.errors.add(String.format("Error while inspecting the class: %s. The error was: %s", className, e.getMessage()));
            }
            catch (NoClassDefFoundError e) {
                this.errors.add(String.format("Unable to find the class: %s which is required by: %s. You may need to add more classes to the model.", e.getMessage().replace('/', '.'), className));
            }
        }
    }

    private boolean isWildCardImport(String className) {
        return className.endsWith("*");
    }

    private void addAnyExternalImports(List<ImportDescr> imports) {
        if (this.externalImportDescrProviders != null) {
            for (ExternalImportDescrProvider externalImportDescrProvider : this.externalImportDescrProviders) {
                imports.addAll(externalImportDescrProvider.getImportDescrs());
            }
        }
    }

    private Class loadClass(String className, List jars) {
        Class clazz = null;
        try {
            clazz = this.resolver.resolveType(className);
        }
        catch (ClassFormatError e1) {
            clazz = this.loadClass(className, jars, clazz);
        }
        catch (ClassNotFoundException e1) {
            clazz = this.loadClass(className, jars, clazz);
        }
        return clazz;
    }

    private Class loadClass(String className, List jars, Class clazz) {
        try {
            this.addJars(jars);
            clazz = this.resolver.resolveType(className);
        }
        catch (Exception e) {
            this.errors.add("Class not found: " + className);
        }
        return clazz;
    }

    private void loadClassFields(Class<?> clazz, String shortTypeName) throws IOException {
        String genericType;
        if (clazz == null) {
            return;
        }
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        TreeSet<String> fieldsSet = new TreeSet<String>(inspector.getFieldNames().keySet());
        List<String> fields = this.removeIrrelevantFields(fieldsSet);
        Method[] methods = clazz.getMethods();
        Map<String, MethodSignature> methodSignatures = this.removeIrrelevantMethods(this.getMethodSignatures(shortTypeName, methods));
        for (String field : fields) {
            Field f = (Field)inspector.getFieldTypesField().get(field);
            if (f == null) {
                String qualifiedName = shortTypeName + "." + field;
                if (!methodSignatures.containsKey(qualifiedName)) continue;
                MethodSignature m = methodSignatures.get(qualifiedName);
                Class<?> returnType = m.returnType;
                String genericType2 = this.translateClassToGenericType(returnType);
                this.builder.addFieldType(qualifiedName, genericType2, returnType);
                FieldInfo fi = new FieldInfo(m.genericType, m.returnType);
                this.builder.addFieldTypeField(qualifiedName, fi);
                continue;
            }
            Class returnType = (Class)inspector.getFieldTypes().get(field);
            genericType = this.translateClassToGenericType(returnType);
            this.builder.addFieldType(shortTypeName + "." + field, genericType, returnType);
            FieldInfo fi = new FieldInfo(f.getGenericType(), f.getType());
            this.builder.addFieldTypeField(shortTypeName + "." + field, fi);
        }
        fields.add(0, "this");
        methodSignatures.put(shortTypeName + "." + "this", new MethodSignature(FieldAccessorsAndMutators.ACCESSOR, clazz.getGenericSuperclass(), clazz));
        this.builder.addFieldType(shortTypeName + "." + "this", shortTypeName, clazz);
        this.builder.addFieldAccessorsAndMutatorsForField(this.extractFieldAccessorsAndMutators(methodSignatures));
        this.builder.addFieldsForType(shortTypeName, fields.toArray(new String[fields.size()]));
        ClassMethodInspector methodInspector = new ClassMethodInspector(clazz, this);
        List<MethodInfo> methodInfos = methodInspector.getMethodInfos();
        for (MethodInfo mi : methodInfos) {
            genericType = mi.getParametricReturnType();
            if (genericType == null) continue;
            this.builder.putParametricFieldType(shortTypeName + "." + mi.getNameWithParameters(), genericType);
        }
        this.builder.getInstance().addMethodInfo(shortTypeName, methodInfos);
    }

    public String getShortNameOfClass(String clazz) {
        return clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    public List<String> removeIrrelevantFields(Collection<String> fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (String field : fields) {
            if (field.equals("class") || field.equals("hashCode") || field.equals("toString")) continue;
            result.add(field);
        }
        return result;
    }

    public Map<String, MethodSignature> removeIrrelevantMethods(Map<String, MethodSignature> methods) {
        HashMap<String, MethodSignature> result = new HashMap<String, MethodSignature>();
        for (Map.Entry<String, MethodSignature> methodSignature : methods.entrySet()) {
            String methodName = methodSignature.getKey();
            if ((methodName = methodName.substring(methodName.lastIndexOf(".") + 1)).equals("class")) continue;
            result.put(methodSignature.getKey(), methodSignature.getValue());
        }
        return result;
    }

    private void addJars(List<JarInputStream> jars) throws IOException {
        for (JarInputStream jis : jars) {
            JarEntry entry;
            byte[] buf = new byte[1024];
            while ((entry = jis.getNextJarEntry()) != null) {
                int len;
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                this.loader.addResource(entry.getName(), out.toByteArray());
            }
        }
    }

    @Override
    public String translateClassToGenericType(Class<?> type) {
        String fieldType = null;
        if (type != null) {
            if (type.isPrimitive() && type != Boolean.TYPE) {
                fieldType = "Numeric";
            } else if (Number.class.isAssignableFrom(type)) {
                fieldType = "Numeric";
            } else if (String.class.isAssignableFrom(type)) {
                fieldType = "String";
            } else if (Collection.class.isAssignableFrom(type)) {
                fieldType = "Collection";
            } else if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                fieldType = "Boolean";
            } else if (Date.class.isAssignableFrom(type)) {
                fieldType = "Date";
            } else if (Comparable.class.isAssignableFrom(type)) {
                fieldType = "Comparable";
            } else {
                try {
                    Class clazz = this.resolver.resolveType(type.getName());
                    fieldType = clazz.getSimpleName();
                }
                catch (ClassNotFoundException e) {
                    fieldType = "Object";
                }
            }
        }
        return fieldType;
    }

    public void addExternalImportDescrProvider(ExternalImportDescrProvider provider) {
        this.externalImportDescrProviders.add(provider);
    }

    public Set<ImportDescr> getExternalImportDescrs() {
        HashSet<ImportDescr> result = new HashSet<ImportDescr>();
        for (ExternalImportDescrProvider externalImportDescrProvider : this.externalImportDescrProviders) {
            result.addAll(externalImportDescrProvider.getImportDescrs());
        }
        return result;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    class WildCardException
    extends Exception {
        WildCardException() {
        }
    }

    public static class FieldInfo {
        private Type genericType;
        private Class<?> type;

        public FieldInfo(Type genericType, Class<?> type) {
            this.genericType = genericType;
            this.type = type;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public Class<?> getType() {
            return this.type;
        }
    }

    private static class MethodSignature {
        FieldAccessorsAndMutators accessorAndMutator;
        Type genericType;
        Class<?> returnType;

        MethodSignature(FieldAccessorsAndMutators accessorAndMutator, Type genericType, Class<?> returnType) {
            this.accessorAndMutator = accessorAndMutator;
            this.genericType = genericType;
            this.returnType = returnType;
        }
    }

    public static interface ExternalImportDescrProvider {
        public Set<ImportDescr> getImportDescrs();
    }
}

