/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.Map;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.DRLConstraintValueBuilder;
import org.drools.ide.common.server.util.TemplateDataProvider;

public class GuidedDTBRDRLPersistence
extends BRDRLPersistence {
    private TemplateDataProvider rowDataProvider;

    public GuidedDTBRDRLPersistence(TemplateDataProvider rowDataProvider) {
        if (rowDataProvider == null) {
            throw new NullPointerException("rowDataProvider cannot be null");
        }
        this.rowDataProvider = rowDataProvider;
    }

    @Override
    protected LHSPatternVisitor getLHSPatternVisitor(boolean isDSLEnhanced, StringBuilder buf, String nestedIndentation, boolean isNegated) {
        return new LHSPatternVisitor(isDSLEnhanced, this.rowDataProvider, this.bindingsPatterns, this.bindingsFields, buf, nestedIndentation, isNegated);
    }

    @Override
    protected RHSActionVisitor getRHSActionVisitor(boolean isDSLEnhanced, StringBuilder buf, String indentation) {
        return new RHSActionVisitor(isDSLEnhanced, this.rowDataProvider, this.bindingsPatterns, this.bindingsFields, buf, indentation);
    }

    public static class RHSActionVisitor
    extends BRDRLPersistence.RHSActionVisitor {
        private TemplateDataProvider rowDataProvider;

        public RHSActionVisitor(boolean isDSLEnhanced, TemplateDataProvider rowDataProvider, Map<String, IFactPattern> bindingsPatterns, Map<String, FieldConstraint> bindingsFields, StringBuilder b, String indentation) {
            super(isDSLEnhanced, bindingsPatterns, bindingsFields, b, indentation);
            this.rowDataProvider = rowDataProvider;
        }

        @Override
        protected void buildTemplateFieldValue(ActionFieldValue fieldValue, StringBuilder buf) {
            DRLConstraintValueBuilder.buildRHSFieldValue(buf, fieldValue.type, this.rowDataProvider.getTemplateKeyValue(fieldValue.value));
        }
    }

    public static class LHSPatternVisitor
    extends BRDRLPersistence.LHSPatternVisitor {
        private TemplateDataProvider rowDataProvider;

        public LHSPatternVisitor(boolean isDSLEnhanced, TemplateDataProvider rowDataProvider, Map<String, IFactPattern> bindingsPatterns, Map<String, FieldConstraint> bindingsFields, StringBuilder b, String indentation, boolean isPatternNegated) {
            super(isDSLEnhanced, bindingsPatterns, bindingsFields, b, indentation, isPatternNegated);
            this.rowDataProvider = rowDataProvider;
        }

        @Override
        protected void buildTemplateFieldValue(int type, String fieldType, String value, StringBuilder buf) {
            buf.append(" ");
            DRLConstraintValueBuilder.buildLHSFieldValue(buf, type, fieldType, this.rowDataProvider.getTemplateKeyValue(value));
            buf.append(" ");
        }
    }
}

