/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.modeldriven;

import org.drools.ide.common.client.modeldriven.brl.DSLComplexVariableValue;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.DSLVariableValue;
import org.junit.Assert;
import org.junit.Test;

public class DSLSentenceTest {
    @Test
    public void testSentence() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("this is {something} here and {here}");
        Assert.assertEquals((Object)"this is {something} here and {here}", (Object)sen.toString());
        sen.setDefinition("foo bar");
        Assert.assertEquals((Object)"foo bar", (Object)sen.toString());
        DSLSentence newOne = sen.copy();
        Assert.assertFalse((newOne == sen ? 1 : 0) != 0);
        Assert.assertEquals((Object)newOne.getDefinition(), (Object)sen.getDefinition());
        Assert.assertEquals((Object)newOne.getValues(), (Object)sen.getValues());
    }

    @Test
    public void testEnumSentence() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("this is {variable:ENUM:Value.test} here and {here}");
        Assert.assertEquals((Object)"this is {variable} here and {here}", (Object)sen.toString());
    }

    @Test
    public void testLogColonSentence() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("Log : \"{message}\"");
        Assert.assertEquals((Object)"Log : \"{message}\"", (Object)sen.toString());
    }

    @Test
    public void testWithNewLines() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("this is {variable}\\n here and {here}");
        Assert.assertEquals((Object)"this is {variable}\n here and {here}", (Object)sen.toString());
    }

    @Test
    public void testInterpolate1() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("{something} here");
        sen.getValues().set(0, new DSLVariableValue("word"));
        Assert.assertEquals((Object)"word here", (Object)sen.interpolate());
    }

    @Test
    public void testInterpolate2() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("a {here}");
        sen.getValues().set(0, new DSLVariableValue("word"));
        Assert.assertEquals((Object)"a word", (Object)sen.interpolate());
    }

    @Test
    public void testInterpolate3() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("a {here} and {here}");
        sen.getValues().set(0, new DSLVariableValue("word"));
        sen.getValues().set(1, new DSLVariableValue("word"));
        Assert.assertEquals((Object)"a word and word", (Object)sen.interpolate());
    }

    @Test
    public void testEnumSentenceContainingRegEx() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("When a person exists with social security number \"{chooseSSN:\\d{3}-\\d{2}-\\d{4}}\"");
        sen.getValues().set(0, new DSLVariableValue("333-22-4444"));
        Assert.assertEquals((Object)"When a person exists with social security number \"333-22-4444\"", (Object)sen.interpolate());
    }

    @Test
    public void testEnumSentenceWithBoolean() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("When a person is alive {alive:BOOLEAN:checked}");
        sen.getValues().set(0, new DSLVariableValue("true"));
        Assert.assertEquals((Object)"When a person is alive true", (Object)sen.interpolate());
    }

    @Test
    public void testEnumSentenceWithEnumeration() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("When a person is \"{rating:ENUM:Person.gender}\"");
        sen.getValues().set(0, new DSLVariableValue("Male"));
        Assert.assertEquals((Object)"When a person is \"Male\"", (Object)sen.interpolate());
    }

    @Test
    public void testEnumSentenceWithDate() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("When a person was born on \"{dob:DATE:default}\"");
        sen.getValues().set(0, new DSLVariableValue("31-Dec-1999"));
        Assert.assertEquals((Object)"When a person was born on \"31-Dec-1999\"", (Object)sen.interpolate());
    }

    @Test
    public void testDSLComplexVariableValueInterpolation() {
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("a {here} and {here}");
        sen.getValues().set(0, new DSLComplexVariableValue("123", "word"));
        sen.getValues().set(1, new DSLComplexVariableValue("some-other-value", "word"));
        Assert.assertEquals((Object)"a word and word", (Object)sen.interpolate());
    }
}

