/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.modeldriven;

import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.junit.Assert;
import org.junit.Test;

public class FactPatternTest {
    @Test
    public void testAddConstraint() {
        FactPattern p = new FactPattern();
        SingleFieldConstraint x = new SingleFieldConstraint("x");
        p.addConstraint((FieldConstraint)x);
        Assert.assertEquals((long)1L, (long)p.constraintList.constraints.length);
        Assert.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
        SingleFieldConstraint y = new SingleFieldConstraint("y");
        p.addConstraint((FieldConstraint)y);
        Assert.assertEquals((long)2L, (long)p.constraintList.constraints.length);
        Assert.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
        Assert.assertEquals((Object)y, (Object)p.constraintList.constraints[1]);
    }

    @Test
    public void testWithCompositeNesting() {
        FactPattern p = new FactPattern();
        SingleFieldConstraint x = new SingleFieldConstraint("x");
        p.addConstraint((FieldConstraint)x);
        Assert.assertEquals((long)1L, (long)p.constraintList.constraints.length);
        Assert.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
        CompositeFieldConstraint y = new CompositeFieldConstraint();
        y.addConstraint((FieldConstraint)new SingleFieldConstraint("y"));
        y.addConstraint((FieldConstraint)new SingleFieldConstraint("z"));
        p.addConstraint((FieldConstraint)y);
        Assert.assertEquals((long)2L, (long)p.constraintList.constraints.length);
        Assert.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
        Assert.assertEquals((Object)y, (Object)p.constraintList.constraints[1]);
    }

    @Test
    public void testRemoveConstraint() {
        FactPattern p = new FactPattern();
        SingleFieldConstraint x = new SingleFieldConstraint("x");
        p.addConstraint((FieldConstraint)x);
        SingleFieldConstraint y = new SingleFieldConstraint("y");
        p.addConstraint((FieldConstraint)y);
        Assert.assertEquals((long)2L, (long)p.constraintList.constraints.length);
        p.removeConstraint(1);
        Assert.assertEquals((long)1L, (long)p.constraintList.constraints.length);
        Assert.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
    }

    @Test
    public void testIsBound() {
        FactPattern pat = new FactPattern();
        pat.setBoundName("x");
        Assert.assertTrue((boolean)pat.isBound());
        pat = new FactPattern();
        Assert.assertFalse((boolean)pat.isBound());
    }

    @Test
    public void testGetFieldConstraints() {
        FactPattern pat = new FactPattern();
        Assert.assertEquals((long)0L, (long)pat.getFieldConstraints().length);
        Assert.assertNull((Object)pat.constraintList);
        pat.addConstraint((FieldConstraint)new SingleFieldConstraint());
        Assert.assertNotNull((Object)pat.constraintList);
        Assert.assertEquals((long)1L, (long)pat.getFieldConstraints().length);
    }
}

