/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.drools.StatefulSession;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.ide.common.client.modeldriven.testing.ActivateRuleFlowGroup;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Expectation;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.RetractFact;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;
import org.drools.ide.common.server.testscenarios.MockWorkingMemory;
import org.drools.ide.common.server.testscenarios.RuleUnit;
import org.drools.ide.common.server.testscenarios.ScenarioRunner;
import org.drools.ide.common.server.testscenarios.TestingEventListener;
import org.drools.time.SessionClock;
import org.drools.time.impl.PseudoClockScheduler;
import org.drools.util.CompositeClassLoader;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioRunnerTest
extends RuleUnit {
    @Test
    public void testPopulateFactsWithInterfaces() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("List", "ls", new ArrayList(), false));
        List<FactData> globals = this.ls(new FactData("List", "ls", new ArrayList(), false));
        sc.getFixtures().addAll(facts);
        sc.getGlobals().addAll(globals);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), this.getClassLoader());
        resolver.addImport("java.util.List");
        ScenarioRunner runner = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)new MockWorkingMemory());
        runner.run(sc);
    }

    @Test
    public void testVerifyFacts() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        Scenario scenario = new Scenario();
        ScenarioRunner runner = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)new MockWorkingMemory());
        scenario.getFixtures().add(new FactData("Cheese", "f1", Arrays.asList(new FieldData("type", "cheddar"), new FieldData("price", "42")), false));
        scenario.getFixtures().add(new FactData("Person", "f2", Arrays.asList(new FieldData("name", "michael"), new FieldData("age", "33")), false));
        VerifyFact verifyCheddar = new VerifyFact();
        verifyCheddar.setName("f1");
        verifyCheddar.setFieldValues(Arrays.asList(new VerifyField("type", "cheddar", "=="), new VerifyField("price", "42", "==")));
        scenario.getFixtures().add(verifyCheddar);
        VerifyFact michaelVerifyFact = new VerifyFact();
        michaelVerifyFact.setName("f2");
        michaelVerifyFact.setFieldValues(Arrays.asList(new VerifyField("name", "michael", "=="), new VerifyField("age", "33", "==")));
        scenario.getFixtures().add(michaelVerifyFact);
        VerifyFact markVerifyFact = new VerifyFact();
        markVerifyFact.setName("f2");
        markVerifyFact.setFieldValues(Arrays.asList(new VerifyField("name", "mark", "=="), new VerifyField("age", "33", "==")));
        scenario.getFixtures().add(markVerifyFact);
        VerifyFact mark2VerifyFact = new VerifyFact();
        mark2VerifyFact.setName("f2");
        mark2VerifyFact.setFieldValues(Arrays.asList(new VerifyField("name", "mark", "=="), new VerifyField("age", "32", "==")));
        scenario.getFixtures().add(mark2VerifyFact);
        runner.run(scenario);
        for (VerifyField verifyField : verifyCheddar.getFieldValues()) {
            Assert.assertTrue((boolean)verifyField.getSuccessResult());
        }
        for (VerifyField verifyField : michaelVerifyFact.getFieldValues()) {
            Assert.assertTrue((boolean)verifyField.getSuccessResult());
        }
        Assert.assertFalse((boolean)((VerifyField)markVerifyFact.getFieldValues().get(0)).getSuccessResult());
        Assert.assertTrue((boolean)((VerifyField)markVerifyFact.getFieldValues().get(1)).getSuccessResult());
        Assert.assertEquals((Object)"michael", (Object)((VerifyField)markVerifyFact.getFieldValues().get(0)).getActualResult());
        Assert.assertEquals((Object)"mark", (Object)((VerifyField)markVerifyFact.getFieldValues().get(0)).getExpected());
        Assert.assertFalse((boolean)((VerifyField)mark2VerifyFact.getFieldValues().get(0)).getSuccessResult());
        Assert.assertFalse((boolean)((VerifyField)mark2VerifyFact.getFieldValues().get(1)).getSuccessResult());
        Assert.assertEquals((Object)"michael", (Object)((VerifyField)mark2VerifyFact.getFieldValues().get(0)).getActualResult());
        Assert.assertEquals((Object)"mark", (Object)((VerifyField)mark2VerifyFact.getFieldValues().get(0)).getExpected());
        Assert.assertEquals((Object)"33", (Object)((VerifyField)mark2VerifyFact.getFieldValues().get(1)).getActualResult());
        Assert.assertEquals((Object)"32", (Object)((VerifyField)mark2VerifyFact.getFieldValues().get(1)).getExpected());
    }

    @Test
    public void testVerifyFactsWithEnum() throws Exception {
        FieldData fieldData = new FieldData("cheeseType", "CheeseType.CHEDDAR");
        fieldData.setNature(4L, null);
        FactData cheeseFactData = new FactData("Cheese", "c1", Arrays.asList(fieldData), false);
        FieldData cheeseType = new FieldData("cheeseType", "CheeseType.CHEDDAR");
        cheeseType.setNature(4L, null);
        FactData f1 = new FactData("Cheese", "f1", Arrays.asList(cheeseType), false);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.CheeseType");
        Scenario scenario = new Scenario();
        scenario.getFixtures().add(cheeseFactData);
        scenario.getFixtures().add(f1);
        ScenarioRunner runner = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)new MockWorkingMemory());
        VerifyFact vf = new VerifyFact();
        vf.setName("f1");
        VerifyField verifyField = new VerifyField("cheeseType", "CheeseType.CHEDDAR", "==");
        verifyField.setNature(4L);
        vf.setFieldValues(this.ls(verifyField));
        scenario.getFixtures().add(vf);
        runner.run(scenario);
        for (VerifyField field : vf.getFieldValues()) {
            Assert.assertTrue((boolean)field.getSuccessResult());
        }
    }

    @Test
    public void testTestingEventListener() throws Exception {
        Scenario sc = new Scenario();
        sc.getRules().add("foo");
        sc.getRules().add("bar");
        ExecutionTrace ext = new ExecutionTrace();
        sc.getFixtures().add(ext);
        MockWorkingMemory wm = new MockWorkingMemory();
        PseudoClockScheduler clock = new PseudoClockScheduler();
        long time = new Date().getTime();
        clock.setStartupTime(time);
        clock.setSession((InternalWorkingMemory)wm);
        wm.setSessionClock((SessionClock)clock);
        ScenarioRunner run = new ScenarioRunner(null, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        Assert.assertNotNull((Object)wm.agendaEventListener);
        Assert.assertTrue((boolean)(wm.agendaEventListener instanceof TestingEventListener));
        Assert.assertEquals((long)2L, (long)sc.getRules().size());
        Assert.assertTrue((boolean)sc.getRules().contains("foo"));
        Assert.assertTrue((boolean)sc.getRules().contains("bar"));
    }

    @Test
    public void testWithGlobalList() throws Exception {
        Scenario sc = new Scenario();
        sc.getGlobals().add(new FactData("List", "testList", new ArrayList(), false));
        Expectation[] assertions = new Expectation[]{new VerifyFact("testList", this.ls(new VerifyField("empty", "true", "=="))), new VerifyFact("testList", this.ls(new VerifyField("size", "0", "==")))};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("java.util.List");
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner run = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        List testList = (List)wm.globals.get("testList");
        Assert.assertTrue((boolean)testList.isEmpty());
        Assert.assertEquals((long)0L, (long)testList.size());
    }

    @Test
    public void testSimulatedDate() throws Exception {
        Scenario sc = new Scenario();
        MockWorkingMemory wm = new MockWorkingMemory();
        PseudoClockScheduler clock = new PseudoClockScheduler();
        long time = new Date().getTime();
        clock.setStartupTime(time);
        clock.setSession((InternalWorkingMemory)wm);
        wm.setSessionClock((SessionClock)clock);
        ScenarioRunner run = new ScenarioRunner(null, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        Assert.assertEquals((long)time, (long)wm.getSessionClock().getCurrentTime());
        ExecutionTrace ext = new ExecutionTrace();
        ext.setScenarioSimulatedDate(new Date("10-Jul-1974"));
        sc.getFixtures().add(ext);
        run = new ScenarioRunner(null, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        long expected = ext.getScenarioSimulatedDate().getTime();
        Assert.assertEquals((long)expected, (long)wm.getSessionClock().getCurrentTime());
    }

    @Test
    public void testIntegrationWithSuccess() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", Arrays.asList(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.getGlobals().add(new FactData("Person", "p", new ArrayList(), false));
        sc.getFixtures().addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.getRules().add("rule1");
        sc.getRules().add("rule2");
        sc.setInclusive(true);
        sc.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "rule1", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(0), null)};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules2.drl");
        ScenarioRunner run = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        Assert.assertEquals((long)2L, (long)executionTrace.getNumberOfRulesFired().intValue());
        Assert.assertTrue((boolean)sc.wasSuccessful());
        Thread.sleep(50L);
        Assert.assertTrue((boolean)new Date().after(sc.getLastRunResult()));
        Assert.assertTrue((executionTrace.getExecutionTimeResult() != null ? 1 : 0) != 0);
        Assert.assertTrue((executionTrace.getRulesFired().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntegrationInfiniteLoop() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", Arrays.asList(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.getGlobals().add(new FactData("Person", "p", new ArrayList(), false));
        sc.getFixtures().addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.getRules().add("rule1");
        sc.getRules().add("rule2");
        sc.setInclusive(true);
        sc.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "rule1", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(0), null)};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules_infinite_loop.drl");
        ScenarioRunner run = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        Assert.assertEquals((long)sc.getMaxRuleFirings(), (long)executionTrace.getNumberOfRulesFired().intValue());
    }

    @Test
    public void testIntegrationWithDeclaredTypes() throws Exception {
        Scenario scenario = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Coolness", "c", Arrays.asList(new FieldData("num", "42"), new FieldData("name", "mic")), false)};
        scenario.getFixtures().addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        scenario.getRules().add("rule1");
        scenario.setInclusive(true);
        scenario.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c", this.ls(new VerifyField("num", "42", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null)};
        scenario.getFixtures().addAll(Arrays.asList(assertions));
        StatefulSession workingMemory = this.getWorkingMemory("test_rules3.drl");
        CompositeClassLoader cl = ((InternalRuleBase)workingMemory.getRuleBase()).getRootClassLoader();
        HashSet<String> imports = new HashSet<String>();
        imports.add("foo.bar.*");
        Assert.assertNotNull(cl.loadClass("foo.bar.Coolness"));
        ClassLoader cl_ = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        ScenarioRunner run = new ScenarioRunner((TypeResolver)new ClassTypeResolver(imports, (ClassLoader)cl), this.getClassLoader(), (InternalWorkingMemory)workingMemory);
        run.run(scenario);
        Assert.assertEquals((long)1L, (long)executionTrace.getNumberOfRulesFired().intValue());
        Assert.assertTrue((boolean)scenario.wasSuccessful());
        Thread.currentThread().setContextClassLoader(cl_);
    }

    @Test
    public void testRuleFlowGroupActivation() throws Exception {
        Scenario scenario = new Scenario();
        Fixture[] given = new Fixture[]{new FactData("Coolness", "c", Arrays.asList(new FieldData("num", "42"), new FieldData("name", "mic")), false)};
        scenario.getFixtures().addAll(Arrays.asList(given));
        ExecutionTrace executionTrace = new ExecutionTrace();
        scenario.getRules().add("rule1");
        scenario.setInclusive(true);
        scenario.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c", this.ls(new VerifyField("num", "42", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null)};
        scenario.getFixtures().addAll(Arrays.asList(assertions));
        StatefulSession workingMemory = this.getWorkingMemory("rule_flow_actication.drl");
        CompositeClassLoader classLoader = ((InternalRuleBase)workingMemory.getRuleBase()).getRootClassLoader();
        HashSet<String> imports = new HashSet<String>();
        imports.add("foo.bar.*");
        ClassTypeResolver resolver = new ClassTypeResolver(imports, (ClassLoader)classLoader);
        Class<?> coolnessClass = classLoader.loadClass("foo.bar.Coolness");
        Assert.assertNotNull(coolnessClass);
        ClassLoader cl_ = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        ScenarioRunner scenarioRunner = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)workingMemory);
        scenarioRunner.run(scenario);
        Assert.assertEquals((long)0L, (long)executionTrace.getNumberOfRulesFired().intValue());
        Assert.assertFalse((boolean)scenario.wasSuccessful());
        scenario.getFixtures().clear();
        given = new Fixture[]{new FactData("Coolness", "c", Arrays.asList(new FieldData("num", "42"), new FieldData("name", "mic")), false), new ActivateRuleFlowGroup("asdf")};
        workingMemory.clearAgenda();
        scenario.getFixtures().addAll(Arrays.asList(given));
        scenario.getFixtures().add(executionTrace);
        workingMemory.getAgenda().getRuleFlowGroup("asdf").setAutoDeactivate(false);
        scenarioRunner = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)workingMemory);
        scenarioRunner.run(scenario);
        Assert.assertEquals((long)1L, (long)executionTrace.getNumberOfRulesFired().intValue());
        Assert.assertTrue((boolean)scenario.wasSuccessful());
        Thread.currentThread().setContextClassLoader(cl_);
    }

    @Test
    public void testIntgerationStateful() throws Exception {
        Scenario sc = new Scenario();
        sc.getFixtures().add(new FactData("Cheese", "c1", Arrays.asList(new FieldData("price", "1")), false));
        ExecutionTrace ex = new ExecutionTrace();
        sc.getFixtures().add(ex);
        sc.getFixtures().add(new FactData("Cheese", "c2", Arrays.asList(new FieldData("price", "2")), false));
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule1", "=="))));
        ex = new ExecutionTrace();
        sc.getFixtures().add(ex);
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule2", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        Assert.assertTrue((boolean)sc.wasSuccessful());
    }

    @Test
    public void testIntegrationWithModify() throws Exception {
        Scenario sc = new Scenario();
        sc.getFixtures().add(new FactData("Cheese", "c1", Arrays.asList(new FieldData("price", "1")), false));
        sc.getFixtures().add(new ExecutionTrace());
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule1", "=="))));
        sc.getFixtures().add(new FactData("Cheese", "c1", Arrays.asList(new FieldData("price", "42")), true));
        sc.getFixtures().add(new ExecutionTrace());
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule3", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        Assert.assertTrue((boolean)sc.wasSuccessful());
    }

    @Test
    public void testIntegrationWithRetract() throws Exception {
        Scenario sc = new Scenario();
        sc.getFixtures().add(new FactData("Cheese", "c1", Arrays.asList(new FieldData("price", "46"), new FieldData("type", "XXX")), false));
        sc.getFixtures().add(new FactData("Cheese", "c2", Arrays.asList(new FieldData("price", "42")), false));
        sc.getFixtures().add(new ExecutionTrace());
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "XXX", "=="))));
        sc.getFixtures().add(new RetractFact("c2"));
        sc.getFixtures().add(new ExecutionTrace());
        sc.getFixtures().add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule4", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        Assert.assertTrue((boolean)sc.wasSuccessful());
    }

    @Test
    public void testIntegrationWithFailure() throws Exception {
        Scenario sc = new Scenario();
        Expectation[] assertions = this.populateScenarioForFailure(sc);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules2.drl");
        ScenarioRunner run = new ScenarioRunner((TypeResolver)resolver, this.getClassLoader(), (InternalWorkingMemory)wm);
        run.run(sc);
        Assert.assertFalse((boolean)sc.wasSuccessful());
        VerifyFact vf = (VerifyFact)assertions[1];
        Assert.assertFalse((boolean)((VerifyField)vf.getFieldValues().get(0)).getSuccessResult());
        Assert.assertEquals((Object)"XXX", (Object)((VerifyField)vf.getFieldValues().get(0)).getExpected());
        Assert.assertEquals((Object)"rule1", (Object)((VerifyField)vf.getFieldValues().get(0)).getActualResult());
        Assert.assertNotNull((Object)((VerifyField)vf.getFieldValues().get(0)).getExplanation());
        VerifyRuleFired vr = (VerifyRuleFired)assertions[4];
        Assert.assertFalse((boolean)vr.getSuccessResult());
        Assert.assertEquals((long)2L, (long)vr.getExpectedCount().intValue());
        Assert.assertEquals((long)0L, (long)vr.getActualResult().intValue());
    }

    private Expectation[] populateScenarioForFailure(Scenario sc) {
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", Arrays.asList(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.getFixtures().addAll(Arrays.asList(facts));
        sc.getGlobals().add(new FactData("Person", "p", new ArrayList(), false));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.getRules().add("rule1");
        sc.getRules().add("rule2");
        sc.setInclusive(true);
        sc.getFixtures().add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "XXX", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(2), null)};
        sc.getFixtures().addAll(Arrays.asList(assertions));
        return assertions;
    }

    private <T> List<T> ls(T ... objects) {
        return Arrays.asList(objects);
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader;
    }
}

