/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.populators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.Cheese;
import org.drools.CheeseType;
import org.drools.Cheesery;
import org.drools.OuterFact;
import org.drools.Person;
import org.drools.SqlDateWrapper;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.InternalWorkingMemory;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.server.testscenarios.MockWorkingMemory;
import org.drools.ide.common.server.testscenarios.populators.ExistingFactPopulator;
import org.drools.ide.common.server.testscenarios.populators.FactPopulator;
import org.drools.ide.common.server.testscenarios.populators.NewFactPopulator;
import org.drools.ide.common.server.testscenarios.populators.Populator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FactPopulatorTest {
    private MockWorkingMemory workingMemory;
    private Map<String, Object> populatedData;
    private FactPopulator factPopulator;

    @Before
    public void setUp() throws Exception {
        this.workingMemory = new MockWorkingMemory();
        this.populatedData = new HashMap<String, Object>();
        this.factPopulator = new FactPopulator((InternalWorkingMemory)this.workingMemory, this.populatedData);
    }

    @Test
    public void testPopulateFacts() throws Exception {
        FactData factData = new FactData("Person", "p1", Arrays.asList(new FieldData("name", "mic"), new FieldData("age", "=30 + 3")), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), factData));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("p1"));
        Person person = (Person)this.populatedData.get("p1");
        Assert.assertEquals((Object)"mic", (Object)person.getName());
        Assert.assertEquals((long)33L, (long)person.getAge());
    }

    @Test
    public void testPopulateEnum() throws Exception {
        FieldData fieldData = new FieldData("cheeseType", "CheeseType.CHEDDAR");
        fieldData.setNature(4L, null);
        FactData factData = new FactData("Cheese", "c1", Arrays.asList(fieldData), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), factData));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        Cheese cheese = (Cheese)this.populatedData.get("c1");
        Assert.assertEquals((Object)((Object)CheeseType.CHEDDAR), (Object)((Object)cheese.getCheeseType()));
    }

    @Test
    public void testPopulateNested() throws Exception {
        TypeResolver typeResolver = this.getTypeResolver();
        FactData cheeseFactData = new FactData("Cheese", "c1", Arrays.asList(new FieldData("type", "cheddar"), new FieldData("price", "42")), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, typeResolver, this.getClassLoader(), cheeseFactData));
        FactData outerFactData = new FactData("OuterFact", "p1", Arrays.asList(new FieldData("name", "mic"), new FieldData("innerFact", "=c1")), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, typeResolver, this.getClassLoader(), outerFactData));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        Assert.assertTrue((boolean)this.populatedData.containsKey("p1"));
        OuterFact o = (OuterFact)this.populatedData.get("p1");
        Assert.assertEquals((Object)this.populatedData.get("c1"), (Object)o.getInnerFact());
    }

    @Test
    public void testPopulateNestedWrongOrder() throws Exception {
        TypeResolver typeResolver = this.getTypeResolver();
        FactData outerFactData = new FactData("OuterFact", "p1", Arrays.asList(new FieldData("name", "mic"), new FieldData("innerFact", "=c1")), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, typeResolver, this.getClassLoader(), outerFactData));
        FactData cheeseFactData = new FactData("Cheese", "c1", Arrays.asList(new FieldData("type", "cheddar"), new FieldData("price", "42")), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, typeResolver, this.getClassLoader(), cheeseFactData));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        Assert.assertTrue((boolean)this.populatedData.containsKey("p1"));
        OuterFact o = (OuterFact)this.populatedData.get("p1");
        Assert.assertEquals((Object)this.populatedData.get("c1"), (Object)o.getInnerFact());
    }

    @Test
    public void testPopulateFactWithoutFields() throws Exception {
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("Cheese", "c1", new ArrayList(), false)));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        Assert.assertTrue((boolean)(this.populatedData.get("c1") instanceof Cheese));
    }

    @Test
    public void testPopulateEmptyIntegerField() throws Exception {
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("Cheese", "c1", Arrays.asList(new FieldData("price", "")), false)));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        Assert.assertTrue((boolean)(this.populatedData.get("c1") instanceof Cheese));
    }

    @Test
    public void testPopulatingExistingFact() throws Exception {
        Cheese cheese = new Cheese();
        cheese.setType("whee");
        cheese.setPrice(1);
        HashMap<String, Cheese> populatedData = new HashMap<String, Cheese>();
        populatedData.put("x", cheese);
        this.factPopulator.add((Populator)new ExistingFactPopulator(populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("Cheese", "x", Arrays.asList(new FieldData("type", null), new FieldData("price", "42")), false)));
        this.factPopulator.populate();
        Assert.assertEquals((Object)"whee", (Object)cheese.getType());
        Assert.assertEquals((long)42L, (long)cheese.getPrice());
    }

    @Test
    public void testDateField() throws Exception {
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("Cheese", "c1", Arrays.asList(new FieldData("type", "cheddar"), new FieldData("usedBy", "10-Jul-2008")), false)));
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("OuterFact", "p1", Arrays.asList(new FieldData("name", "mic"), new FieldData("innerFact", "=c1")), false)));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        Assert.assertTrue((boolean)this.populatedData.containsKey("p1"));
        Cheese c = (Cheese)this.populatedData.get("c1");
        Assert.assertNotNull((Object)c.getUsedBy());
    }

    @Test
    public void testSQLDateField() throws Exception {
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("SqlDateWrapper", "c1", Arrays.asList(new FieldData("sqlDate", "10-Jul-2008")), false)));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        SqlDateWrapper sqlDateWrapper = (SqlDateWrapper)this.populatedData.get("c1");
        Assert.assertNotNull((Object)sqlDateWrapper.getSqlDate());
    }

    @Test
    public void testPopulateFactsWithExpressions() throws Exception {
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("Cheese", "c1", Arrays.asList(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)));
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("Cheese", "c2", Arrays.asList(new FieldData("type", "= c1.type")), false)));
        this.factPopulator.populate();
        Assert.assertTrue((boolean)this.populatedData.containsKey("c1"));
        Assert.assertTrue((boolean)this.populatedData.containsKey("c2"));
        Cheese c = (Cheese)this.populatedData.get("c1");
        Assert.assertEquals((Object)"cheddar", (Object)c.getType());
        Assert.assertEquals((long)42L, (long)c.getPrice());
        Cheese c2 = (Cheese)this.populatedData.get("c2");
        Assert.assertEquals((Object)c.getType(), (Object)c2.getType());
    }

    @Test
    public void testPopulateEmptyString() throws Exception {
        Cheese cheese = new Cheese();
        cheese.setType("whee");
        cheese.setPrice(1);
        this.populatedData.put("x", cheese);
        Assert.assertEquals((long)1L, (long)cheese.getPrice());
        this.factPopulator.add((Populator)new ExistingFactPopulator(this.populatedData, this.getTypeResolver(), this.getClassLoader(), new FactData("Cheese", "x", Arrays.asList(new FieldData("type", ""), new FieldData("price", "42")), false)));
        this.factPopulator.populate();
        Assert.assertEquals((Object)"", (Object)cheese.getType());
        Assert.assertEquals((long)42L, (long)cheese.getPrice());
    }

    @Test
    public void testCollectionFieldInFacts() throws Exception {
        TypeResolver typeResolver = this.getTypeResolver();
        FactData fd1 = new FactData("Cheese", "f1", Arrays.asList(new FieldData("type", ""), new FieldData("price", "42")), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, typeResolver, this.getClassLoader(), fd1));
        FactData fd2 = new FactData("Cheese", "f2", Arrays.asList(new FieldData("type", ""), new FieldData("price", "43")), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, typeResolver, this.getClassLoader(), fd2));
        FactData fd3 = new FactData("Cheese", "f3", Arrays.asList(new FieldData("type", ""), new FieldData("price", "45")), false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, typeResolver, this.getClassLoader(), fd3));
        FieldData field = new FieldData();
        field.setName("cheeses");
        field.collectionType = "Cheese";
        field.setNature(6L);
        field.setValue("=[f1,f2,f3]");
        ArrayList<FieldData> lstField = new ArrayList<FieldData>();
        lstField.add(field);
        FactData lst = new FactData("Cheesery", "listChesse", lstField, false);
        this.factPopulator.add((Populator)new NewFactPopulator(this.populatedData, typeResolver, this.getClassLoader(), lst));
        this.factPopulator.populate();
        Cheesery listChesse = (Cheesery)this.populatedData.get("listChesse");
        Cheese f1 = (Cheese)this.populatedData.get("f1");
        Cheese f2 = (Cheese)this.populatedData.get("f2");
        Cheese f3 = (Cheese)this.populatedData.get("f3");
        Assert.assertEquals((long)3L, (long)listChesse.getCheeses().size());
        Assert.assertTrue((boolean)listChesse.getCheeses().contains(f1));
        Assert.assertTrue((boolean)listChesse.getCheeses().contains(f2));
        Assert.assertTrue((boolean)listChesse.getCheeses().contains(f3));
    }

    private TypeResolver getTypeResolver() {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), this.getClassLoader());
        resolver.addImport("org.drools.Cheesery");
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.SqlDateWrapper");
        resolver.addImport("org.drools.CheeseType");
        resolver.addImport("org.drools.Person");
        resolver.addImport("org.drools.OuterFact");
        return resolver;
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader;
    }

    static {
        try {
            Class.forName("org.drools.base.mvel.MVELCompilationUnit");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

