/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.drools.base.TypeResolver;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.AgendaEventListener;
import org.drools.ide.common.client.modeldriven.testing.CallMethod;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Expectation;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;
import org.drools.ide.common.server.testscenarios.ScenarioSettings;
import org.drools.ide.common.server.testscenarios.TestingEventListener;
import org.drools.ide.common.server.testscenarios.executors.MethodExecutor;
import org.drools.ide.common.server.testscenarios.verifiers.FactVerifier;
import org.drools.ide.common.server.testscenarios.verifiers.RuleFiredVerifier;
import org.drools.time.impl.PseudoClockScheduler;

public class TestScenarioWorkingMemoryWrapper {
    private final InternalWorkingMemory workingMemory;
    private final FactVerifier factVerifier;
    private final RuleFiredVerifier ruleFiredVerifier = new RuleFiredVerifier();
    private TestingEventListener eventListener = null;
    private final MethodExecutor methodExecutor;
    private final Map<String, Object> populatedData;
    private final ClassLoader classLoader;

    public TestScenarioWorkingMemoryWrapper(InternalWorkingMemory workingMemory, TypeResolver resolver, ClassLoader classLoader, Map<String, Object> populatedData, Map<String, Object> globalData) {
        this.workingMemory = workingMemory;
        this.populatedData = populatedData;
        this.methodExecutor = new MethodExecutor(populatedData);
        this.classLoader = classLoader;
        this.factVerifier = this.initFactVerifier(resolver, globalData);
    }

    private FactVerifier initFactVerifier(TypeResolver resolver, Map<String, Object> globalData) {
        return new FactVerifier(this.populatedData, resolver, this.classLoader, this.workingMemory, globalData);
    }

    public void activateRuleFlowGroup(String activateRuleFlowGroupName) {
        this.workingMemory.getAgenda().getRuleFlowGroup(activateRuleFlowGroupName).setAutoDeactivate(false);
        this.workingMemory.getAgenda().activateRuleFlowGroup(activateRuleFlowGroupName);
    }

    public void verifyExpectation(Expectation expectation) {
        if (expectation instanceof VerifyFact) {
            this.factVerifier.verify((VerifyFact)expectation);
        } else if (expectation instanceof VerifyRuleFired) {
            this.ruleFiredVerifier.verifyFiringCounts((VerifyRuleFired)expectation);
        }
    }

    public void executeMethod(CallMethod callMethod) {
        this.methodExecutor.executeMethod(callMethod);
    }

    private void fireAllRules(ScenarioSettings scenarioSettings) {
        this.workingMemory.fireAllRules(this.eventListener.getAgendaFilter(scenarioSettings.getRuleList(), scenarioSettings.isInclusive()), scenarioSettings.getMaxRuleFirings());
    }

    private void resetEventListener() {
        if (this.eventListener != null) {
            this.workingMemory.removeEventListener((AgendaEventListener)this.eventListener);
        }
        this.eventListener = new TestingEventListener();
        this.workingMemory.addEventListener((AgendaEventListener)this.eventListener);
        this.ruleFiredVerifier.setFireCounter(this.eventListener.getFiringCounts());
    }

    public void executeSubScenario(ExecutionTrace executionTrace, ScenarioSettings scenarioSettings) {
        this.resetEventListener();
        this.applyTimeMachine(executionTrace);
        long startTime = System.currentTimeMillis();
        this.fireAllRules(scenarioSettings);
        executionTrace.setExecutionTimeResult(System.currentTimeMillis() - startTime);
        executionTrace.setNumberOfRulesFired(this.eventListener.totalFires);
        executionTrace.setRulesFired(this.eventListener.getRulesFiredSummary());
    }

    private void applyTimeMachine(ExecutionTrace executionTrace) {
        ((PseudoClockScheduler)this.workingMemory.getSessionClock()).advanceTime(this.getTargetTime(executionTrace) - this.getCurrentTime(), TimeUnit.MILLISECONDS);
    }

    private long getTargetTime(ExecutionTrace executionTrace) {
        if (executionTrace.getScenarioSimulatedDate() != null) {
            return executionTrace.getScenarioSimulatedDate().getTime();
        }
        return new Date().getTime();
    }

    private long getCurrentTime() {
        return this.workingMemory.getSessionClock().getCurrentTime();
    }
}

