/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.populators;

import java.util.Map;
import org.drools.base.TypeResolver;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.server.testscenarios.populators.ExistingFactPopulator;
import org.drools.ide.common.server.testscenarios.populators.GlobalFactPopulator;
import org.drools.ide.common.server.testscenarios.populators.NewFactPopulator;
import org.drools.ide.common.server.testscenarios.populators.Populator;

public class FactPopulatorFactory {
    private Map<String, Object> populatedData;
    private Map<String, Object> globalData;
    private final TypeResolver typeResolver;
    private ClassLoader classLoader;

    public FactPopulatorFactory(Map<String, Object> populatedData, Map<String, Object> globalData, TypeResolver typeResolver, ClassLoader classLoader) {
        this.populatedData = populatedData;
        this.globalData = globalData;
        this.typeResolver = typeResolver;
        this.classLoader = classLoader;
    }

    public Populator createFactPopulator(FactData fact) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (fact.isModify()) {
            return new ExistingFactPopulator(this.populatedData, this.typeResolver, this.classLoader, fact);
        }
        return new NewFactPopulator(this.populatedData, this.typeResolver, this.classLoader, fact);
    }

    public Populator createGlobalFactPopulator(FactData fact) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return new GlobalFactPopulator(this.populatedData, this.typeResolver, this.classLoader, fact, this.globalData);
    }
}

