/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.verifiers;

import java.util.Iterator;
import java.util.Map;
import org.drools.base.TypeResolver;
import org.drools.common.InternalWorkingMemory;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.server.testscenarios.verifiers.FactFieldValueVerifier;

public class FactVerifier {
    private final Map<String, Object> populatedData;
    private final TypeResolver resolver;
    private final InternalWorkingMemory workingMemory;
    private final Map<String, Object> globalData;
    private final ClassLoader classLoader;

    public FactVerifier(Map<String, Object> populatedData, TypeResolver resolver, ClassLoader classLoader, InternalWorkingMemory workingMemory, Map<String, Object> globalData) {
        this.populatedData = populatedData;
        this.resolver = resolver;
        this.classLoader = classLoader;
        this.workingMemory = workingMemory;
        this.globalData = globalData;
    }

    public void verify(VerifyFact verifyFact) {
        for (VerifyField vf : verifyFact.getFieldValues()) {
            vf.setSuccessResult(null);
            vf.setExplanation("Fact of type [" + verifyFact.getName() + "] was not found in the results.");
        }
        if (!verifyFact.anonymous) {
            FactFieldValueVerifier fieldVerifier = new FactFieldValueVerifier(this.populatedData, verifyFact.getName(), this.getFactObject(verifyFact.getName(), this.populatedData, this.globalData), this.resolver, this.classLoader);
            fieldVerifier.checkFields(verifyFact.getFieldValues());
        } else {
            Iterator objects = this.workingMemory.iterateObjects();
            while (objects.hasNext()) {
                if (!this.verifyFact(objects.next(), verifyFact, this.populatedData, this.resolver)) continue;
                return;
            }
            for (VerifyField verifyField : verifyFact.getFieldValues()) {
                if (verifyField.getSuccessResult() != null) continue;
                verifyField.setSuccessResult(Boolean.FALSE);
                verifyField.setActualResult("No match");
            }
        }
    }

    private boolean verifyFact(Object factObject, VerifyFact verifyFact, Map<String, Object> populatedData, TypeResolver resolver) {
        if (factObject.getClass().getSimpleName().equals(verifyFact.getName())) {
            FactFieldValueVerifier fieldVerifier = new FactFieldValueVerifier(populatedData, verifyFact.getName(), factObject, resolver, this.classLoader);
            fieldVerifier.checkFields(verifyFact.getFieldValues());
            if (verifyFact.wasSuccessful()) {
                return true;
            }
        }
        return false;
    }

    private Object getFactObject(String factName, Map<String, Object> populatedData, Map<String, Object> globalData) {
        if (populatedData.containsKey(factName)) {
            return populatedData.get(factName);
        }
        return globalData.get(factName);
    }
}

