/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.populators;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.base.TypeResolver;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Field;
import org.drools.ide.common.server.testscenarios.populators.FieldPopulator;
import org.drools.ide.common.server.testscenarios.populators.FieldPopulatorFactory;
import org.drools.ide.common.server.testscenarios.populators.Populator;

abstract class FactPopulatorBase
implements Populator {
    protected final Map<String, Object> populatedData;
    protected final TypeResolver typeResolver;
    protected final ClassLoader classLoader;
    protected final FactData fact;

    public FactPopulatorBase(Map<String, Object> populatedData, TypeResolver typeResolver, ClassLoader classLoader, FactData fact) throws ClassNotFoundException {
        this.populatedData = populatedData;
        this.typeResolver = typeResolver;
        this.classLoader = classLoader;
        this.fact = fact;
    }

    @Override
    public String getName() {
        return this.fact.getName();
    }

    protected List<FieldPopulator> getFieldPopulators(Object factObject) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        FieldPopulatorFactory fieldPopulatorFactory = new FieldPopulatorFactory(factObject, this.typeResolver, this.classLoader);
        ArrayList<FieldPopulator> fieldPopulators = new ArrayList<FieldPopulator>();
        for (Field field : this.fact.getFieldData()) {
            try {
                fieldPopulators.add(fieldPopulatorFactory.getFieldPopulator(field));
            }
            catch (IllegalArgumentException e) {}
        }
        return fieldPopulators;
    }

    protected String getTypeName(TypeResolver resolver, FactData fact) throws ClassNotFoundException {
        String fullName = resolver.getFullTypeName(fact.getType());
        if (fullName.equals("java.util.List") || fullName.equals("java.util.Collection")) {
            return "java.util.ArrayList";
        }
        return fullName;
    }
}

