/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.modeldriven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.server.util.DataEnumLoader;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mvel2.MVEL;
import org.mvel2.templates.TemplateRuntime;

public class DataEnumLoaderTest {
    @Test
    @Ignore
    public void testEnumGeneration() throws Exception {
        Object result = MVEL.eval((String)"[2, 3, 4, ]", new HashMap());
        Assert.assertTrue((boolean)(result instanceof List));
        List l = (List)result;
        Assert.assertEquals((long)3L, (long)l.size());
        result = MVEL.eval((String)"['Person.age' : [2, 3]\n, 'Person.name' : ['qqq', \n'ccc']]", new HashMap());
        DataEnumLoader loader = new DataEnumLoader(this.readLines().toString());
        Assert.assertFalse((String)loader.getErrors().toString(), (boolean)loader.hasErrors());
        Map enumeration = loader.getData();
        Assert.assertEquals((String)loader.getErrors().toString(), (long)0L, (long)loader.getErrors().size());
        Assert.assertEquals((long)3L, (long)enumeration.size());
        String[] list = (String[])enumeration.get("Person.age");
        Assert.assertEquals((long)4L, (long)list.length);
        Assert.assertEquals((Object)"1", (Object)list[0]);
        Assert.assertEquals((Object)"2", (Object)list[1]);
        list = (String[])enumeration.get("Person.rating");
        Assert.assertEquals((long)2L, (long)list.length);
        Assert.assertEquals((Object)"High", (Object)list[0]);
        Assert.assertEquals((Object)"Low", (Object)list[1]);
        loader = new DataEnumLoader("goober poo error");
        Assert.assertEquals((long)0L, (long)loader.getData().size());
        Assert.assertFalse((loader.getErrors().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)loader.hasErrors());
    }

    @Test
    public void testNoOp() {
        DataEnumLoader loader = new DataEnumLoader(" ");
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertEquals((long)0L, (long)loader.getData().size());
        loader = new DataEnumLoader("");
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertEquals((long)0L, (long)loader.getData().size());
    }

    @Test
    public void testLiteralHelperUtilityClass() {
        DataEnumLoader loader = new DataEnumLoader("=(new org.drools.ide.common.modeldriven.SampleDataSource2()).loadData()");
        Assert.assertFalse((boolean)loader.hasErrors());
        Assert.assertEquals((long)1L, (long)loader.getData().size());
        String[] res = (String[])loader.getData().get("whee");
        Assert.assertEquals((long)2L, (long)res.length);
        Assert.assertEquals((Object)"hey", (Object)res[0]);
        Assert.assertEquals((Object)"ho", (Object)res[1]);
    }

    @Test
    public void testNewLines() {
        String s = "yeah yeah, \nyeah \nyeah";
        Assert.assertEquals((Object)"yeah yeah,\nyeah,\nyeah", (Object)DataEnumLoader.addCommasForNewLines((String)s));
    }

    @Test
    public void testLazyString() {
        DataEnumLoader loader = new DataEnumLoader("'Person.type[sex]' : 'something @{sex}'");
        Assert.assertFalse((boolean)loader.hasErrors());
        Map data = loader.getData();
        String[] sl = (String[])data.get("Person.type[sex]");
        String s = sl[0];
        Assert.assertEquals((Object)"something @{sex}", (Object)s);
        HashMap context = new HashMap(){
            {
                this.put("sex", "cool");
            }
        };
        Object r = TemplateRuntime.eval((String)s, (Map)context);
        Assert.assertEquals((Object)"something cool", (Object)r);
        loader = new DataEnumLoader("'Person.type[sex, money]' : '@{sex} @{money}'");
        Assert.assertFalse((boolean)loader.hasErrors());
        sl = (String[])loader.getData().get("Person.type[sex, money]");
        s = sl[0];
        Assert.assertEquals((Object)"@{sex} @{money}", (Object)s);
    }

    private StringBuilder readLines() throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("Some.enumeration")));
        String line = "";
        StringBuilder buf = new StringBuilder();
        while ((line = r.readLine()) != null) {
            buf.append(line);
            buf.append('\n');
        }
        return buf;
    }
}

